/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.test;

import org.alfresco.webservice.dictionary.ClassPredicate;
import org.alfresco.webservice.test.BaseWebServiceSystemTest;
import org.alfresco.webservice.types.AssociationDefinition;
import org.alfresco.webservice.types.ClassDefinition;
import org.alfresco.webservice.types.PropertyDefinition;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DictionaryServiceSystemTest
extends BaseWebServiceSystemTest {
    private static Log logger = LogFactory.getLog(DictionaryServiceSystemTest.class);

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testGetClasses() throws Exception {
        ClassDefinition[] classDefs = WebServiceFactory.getDictionaryService().getClasses(null, null);
        DictionaryServiceSystemTest.assertNotNull((Object)classDefs);
        DictionaryServiceSystemTest.assertTrue((classDefs.length >= 1 ? 1 : 0) != 0);
    }

    public void testSingleTypePredicate() throws Exception {
        ClassPredicate types = new ClassPredicate(new String[]{"cm:content"}, false, false);
        ClassPredicate aspects = new ClassPredicate(new String[0], false, false);
        ClassDefinition[] classDefs = WebServiceFactory.getDictionaryService().getClasses(types, aspects);
        DictionaryServiceSystemTest.assertNotNull((Object)classDefs);
        DictionaryServiceSystemTest.assertEquals((int)1, (int)classDefs.length);
        DictionaryServiceSystemTest.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}content", (String)classDefs[0].getName());
    }

    public void testSingleAspectPredicate() throws Exception {
        ClassPredicate types = new ClassPredicate(new String[0], false, false);
        ClassPredicate aspects = new ClassPredicate(new String[]{"cm:auditable"}, false, false);
        ClassDefinition[] classDefs = WebServiceFactory.getDictionaryService().getClasses(types, aspects);
        DictionaryServiceSystemTest.assertNotNull((Object)classDefs);
        DictionaryServiceSystemTest.assertEquals((int)1, (int)classDefs.length);
        DictionaryServiceSystemTest.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}auditable", (String)classDefs[0].getName());
    }

    public void testSingleTypeAspectPredicate() throws Exception {
        ClassPredicate types = new ClassPredicate(new String[]{"cm:content"}, false, false);
        ClassPredicate aspects = new ClassPredicate(new String[]{"cm:auditable"}, false, false);
        ClassDefinition[] classDefs = WebServiceFactory.getDictionaryService().getClasses(types, aspects);
        DictionaryServiceSystemTest.assertNotNull((Object)classDefs);
        DictionaryServiceSystemTest.assertEquals((int)2, (int)classDefs.length);
    }

    public void testSingleTypeAllAspectsPredicate() throws Exception {
        ClassPredicate types = new ClassPredicate(new String[]{"cm:content"}, false, false);
        ClassDefinition[] classDefs = WebServiceFactory.getDictionaryService().getClasses(types, null);
        DictionaryServiceSystemTest.assertNotNull((Object)classDefs);
        DictionaryServiceSystemTest.assertTrue((classDefs.length > 1 ? 1 : 0) != 0);
    }

    public void testSingleAspectAllTypesPredicate() throws Exception {
        ClassPredicate aspects = new ClassPredicate(new String[]{"cm:auditable"}, false, false);
        ClassDefinition[] classDefs = WebServiceFactory.getDictionaryService().getClasses(null, aspects);
        DictionaryServiceSystemTest.assertNotNull((Object)classDefs);
        DictionaryServiceSystemTest.assertTrue((classDefs.length > 1 ? 1 : 0) != 0);
    }

    public void testTypeWithSubTypesPredicate() throws Exception {
        ClassPredicate types = new ClassPredicate(new String[]{"cm:content"}, true, false);
        ClassDefinition[] classDefs = WebServiceFactory.getDictionaryService().getClasses(types, null);
        DictionaryServiceSystemTest.assertNotNull((Object)classDefs);
        DictionaryServiceSystemTest.assertTrue((classDefs.length > 1 ? 1 : 0) != 0);
    }

    public void testGetProperties() throws Exception {
        PropertyDefinition[] propDefs = WebServiceFactory.getDictionaryService().getProperties(new String[]{"cm:modified", "cm:creator"});
        DictionaryServiceSystemTest.assertNotNull((Object)propDefs);
        DictionaryServiceSystemTest.assertTrue((propDefs.length == 2 ? 1 : 0) != 0);
        DictionaryServiceSystemTest.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}modified", (String)propDefs[0].getName());
        DictionaryServiceSystemTest.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}creator", (String)propDefs[1].getName());
    }

    public void testGetAssociations() throws Exception {
        AssociationDefinition[] assocDefs = WebServiceFactory.getDictionaryService().getAssociations(new String[]{"sys:children", "cm:contains"});
        DictionaryServiceSystemTest.assertNotNull((Object)assocDefs);
        DictionaryServiceSystemTest.assertTrue((assocDefs.length == 2 ? 1 : 0) != 0);
        DictionaryServiceSystemTest.assertEquals((String)"{http://www.alfresco.org/model/system/1.0}children", (String)assocDefs[0].getName());
        DictionaryServiceSystemTest.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}contains", (String)assocDefs[1].getName());
    }

    public void testisSubClass() throws Exception {
        boolean test1 = WebServiceFactory.getDictionaryService().isSubClass("cm:content", "sys:base");
        DictionaryServiceSystemTest.assertTrue((boolean)test1);
        boolean test2 = WebServiceFactory.getDictionaryService().isSubClass("sys:base", "cm:content");
        DictionaryServiceSystemTest.assertTrue((!test2 ? 1 : 0) != 0);
    }
}

