/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.test;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.webservice.content.Content;
import org.alfresco.webservice.repository.Association;
import org.alfresco.webservice.repository.QueryResult;
import org.alfresco.webservice.repository.RepositoryServiceLocator;
import org.alfresco.webservice.repository.RepositoryServiceSoapBindingStub;
import org.alfresco.webservice.repository.UpdateResult;
import org.alfresco.webservice.test.BaseWebServiceSystemTest;
import org.alfresco.webservice.types.CML;
import org.alfresco.webservice.types.CMLAddAspect;
import org.alfresco.webservice.types.CMLCopy;
import org.alfresco.webservice.types.CMLCreate;
import org.alfresco.webservice.types.CMLDelete;
import org.alfresco.webservice.types.CMLUpdate;
import org.alfresco.webservice.types.CMLWriteContent;
import org.alfresco.webservice.types.ClassDefinition;
import org.alfresco.webservice.types.ContentFormat;
import org.alfresco.webservice.types.NamedValue;
import org.alfresco.webservice.types.Node;
import org.alfresco.webservice.types.NodeDefinition;
import org.alfresco.webservice.types.ParentReference;
import org.alfresco.webservice.types.Predicate;
import org.alfresco.webservice.types.PropertyDefinition;
import org.alfresco.webservice.types.Query;
import org.alfresco.webservice.types.QueryConfiguration;
import org.alfresco.webservice.types.Reference;
import org.alfresco.webservice.types.ResultSet;
import org.alfresco.webservice.types.ResultSetRow;
import org.alfresco.webservice.types.ResultSetRowNode;
import org.alfresco.webservice.types.Store;
import org.alfresco.webservice.types.ValueDefinition;
import org.alfresco.webservice.util.Constants;
import org.alfresco.webservice.util.ContentUtils;
import org.alfresco.webservice.util.ISO9075;
import org.alfresco.webservice.util.Utils;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class RepositoryServiceSystemTest
extends BaseWebServiceSystemTest {
    private static Log logger = LogFactory.getLog(RepositoryServiceSystemTest.class);

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void test01FetchMoreAndbatchSize() throws Exception {
        long NUMBEER_CREATED_FILES = 14L;
        long fetchRows = 0L;
        for (long i = 0L; i < NUMBEER_CREATED_FILES; ++i) {
            this.createTestFetchMoreContent();
        }
        System.out.println("testFetchMore_AND_BatcSize:created " + NUMBEER_CREATED_FILES + " files");
        RepositoryServiceSoapBindingStub repositoryService = WebServiceFactory.getRepositoryService();
        Query query = new Query("lucene", "TYPE:\"{http://www.alfresco.org/model/content/1.0}content\" AND @\\{http\\://www.alfresco.org/model/content/1.0\\}name:Web Services sample*");
        QueryConfiguration queryCfg = new QueryConfiguration();
        int batchSize = 3;
        queryCfg.setFetchSize(batchSize);
        repositoryService.setHeader(new RepositoryServiceLocator().getServiceName().getNamespaceURI(), "QueryHeader", queryCfg);
        QueryResult queryResult = repositoryService.query(BaseWebServiceSystemTest.store, query, false);
        ResultSet resultSet = queryResult.getResultSet();
        long totalRowCount = resultSet.getTotalRowCount();
        RepositoryServiceSystemTest.assertTrue((String)"Number of the created files and resultSet.getTotalRowCount() are equal", (NUMBEER_CREATED_FILES == totalRowCount ? 1 : 0) != 0);
        System.out.println("*************************************");
        System.out.println(" getTotalRowCount(),all rows:" + resultSet.getTotalRowCount());
        System.out.println("*************************************");
        fetchRows = this.showRows(queryResult, batchSize);
        System.out.println("==============PagedQuery===============");
        String querySession = queryResult.getQuerySession();
        while (querySession != null) {
            queryResult = repositoryService.fetchMore(querySession);
            fetchRows += this.showRows(queryResult, batchSize);
            querySession = queryResult.getQuerySession();
        }
        RepositoryServiceSystemTest.assertTrue((String)"Number of the created files to equally number of the fetcheded files ", (NUMBEER_CREATED_FILES == fetchRows ? 1 : 0) != 0);
    }

    private long showRows(QueryResult queryResult, int batchSize) {
        long fetchedRows = 0L;
        ResultSetRow[] rows = queryResult.getResultSet().getRows();
        System.out.println(String.format("--batch size = [%d]----getting next [%d] rows: ", batchSize, rows.length));
        for (int x = 0; x < rows.length; ++x) {
            ResultSetRow row = rows[x];
            System.out.println(row.getColumns(2).getValue());
            ++fetchedRows;
        }
        return fetchedRows;
    }

    private void createTestFetchMoreContent() throws Exception {
        ParentReference parentRef = new ParentReference(BaseWebServiceSystemTest.store, null, BaseWebServiceSystemTest.folderReference.getPath(), Constants.ASSOC_CONTAINS, null);
        String name = "Web Services sample (" + System.currentTimeMillis() + ")";
        parentRef.setChildName("cm:" + name);
        NamedValue[] contentProps = new NamedValue[]{Utils.createNamedValue(Constants.PROP_NAME, name)};
        CMLCreate create = new CMLCreate("1", parentRef, null, null, null, Constants.TYPE_CONTENT, contentProps);
        NamedValue[] titledProps = new NamedValue[]{Utils.createNamedValue(Constants.PROP_TITLE, name), Utils.createNamedValue(Constants.PROP_DESCRIPTION, name)};
        CMLAddAspect addAspect = new CMLAddAspect(Constants.ASPECT_TITLED, titledProps, null, "1");
        CML cml = new CML();
        cml.setCreate(new CMLCreate[]{create});
        cml.setAddAspect(new CMLAddAspect[]{addAspect});
        WebServiceFactory.getRepositoryService().update(cml);
    }

    public void test02GetStores() throws Exception {
        Store[] stores = WebServiceFactory.getRepositoryService().getStores();
        RepositoryServiceSystemTest.assertNotNull((String)"Stores array should not be null", (Object)stores);
        RepositoryServiceSystemTest.assertTrue((String)"There should be at least 1 store", (stores.length >= 1 ? 1 : 0) != 0);
    }

    public void test03Query() throws Exception {
        Query query = new Query("lucene", "( +@\\{http\\://www.alfresco.org/1.0\\}name:test*) OR  TEXT:test*");
        QueryResult queryResult = WebServiceFactory.getRepositoryService().query(BaseWebServiceSystemTest.store, query, false);
        RepositoryServiceSystemTest.assertNotNull((String)"queryResult should not be null", (Object)queryResult);
        ResultSet resultSet = queryResult.getResultSet();
        RepositoryServiceSystemTest.assertNotNull((String)"The result set should not be null", (Object)resultSet);
        logger.debug((Object)("There are " + resultSet.getTotalRowCount() + " rows:"));
        if (resultSet.getTotalRowCount() > 0L) {
            ResultSetRow[] rows = resultSet.getRows();
            for (int x = 0; x < rows.length; ++x) {
                ResultSetRow row = rows[x];
                NamedValue[] columns = row.getColumns();
                for (int y = 0; y < columns.length; ++y) {
                    logger.debug((Object)("row " + x + ": " + row.getColumns(y).getName() + " = " + row.getColumns(y).getValue()));
                }
                ResultSetRowNode node = row.getNode();
                RepositoryServiceSystemTest.assertNotNull((Object)node);
                RepositoryServiceSystemTest.assertNotNull((Object)node.getId());
                RepositoryServiceSystemTest.assertNotNull((Object)node.getType());
                String[] aspects = node.getAspects();
                RepositoryServiceSystemTest.assertNotNull((Object)aspects);
            }
        } else {
            logger.debug((Object)"The query returned no results");
            RepositoryServiceSystemTest.fail((String)"The query returned no results");
        }
    }

    private String[] getMissingProperties(List<PropertyDefinition> actualProperties, Map<String, NamedValue> searchProperties) {
        ArrayList<String> missingProps = new ArrayList<String>();
        for (PropertyDefinition propDef : actualProperties) {
            System.out.print("Checking whether " + propDef.getName() + " exists in search properties...");
            if (!searchProperties.containsKey(propDef.getName())) {
                System.out.println("Nope");
                missingProps.add(propDef.getName());
                continue;
            }
            System.out.println("");
        }
        return missingProps.toArray(new String[0]);
    }

    /*
     * Could not resolve type clashes
     */
    public void test04ALF649() throws Exception {
        Query query = new Query("lucene", "( +@\\{http\\://www.alfresco.org/1.0\\}name:test*) OR  TEXT:test*");
        QueryResult queryResult = WebServiceFactory.getRepositoryService().query(BaseWebServiceSystemTest.store, query, false);
        RepositoryServiceSystemTest.assertNotNull((String)"queryResult should not be null", (Object)queryResult);
        ResultSet resultSet = queryResult.getResultSet();
        RepositoryServiceSystemTest.assertNotNull((String)"The result set should not be null", (Object)resultSet);
        logger.debug((Object)("There are " + resultSet.getTotalRowCount() + " rows:"));
        if (resultSet.getTotalRowCount() > 0L) {
            ResultSetRow[] rows = resultSet.getRows();
            for (int x = 0; x < rows.length; ++x) {
                ResultSetRow row = rows[x];
                NamedValue[] columns = row.getColumns();
                for (int y = 0; y < columns.length; ++y) {
                    logger.debug((Object)("row " + x + ": " + row.getColumns(y).getName() + " = " + row.getColumns(y).getValue()));
                }
                ResultSetRowNode node = row.getNode();
                Reference ref = new Reference();
                ref.setStore(BaseWebServiceSystemTest.store);
                ref.setUuid(node.getId());
                Predicate predicate = new Predicate(new Reference[]{ref}, null, null);
                NodeDefinition[] nodeDefs = WebServiceFactory.getRepositoryService().describe(predicate);
                RepositoryServiceSystemTest.assertNotNull((String)"SearchTest nodeDefs is null", (Object)nodeDefs);
                RepositoryServiceSystemTest.assertTrue((String)"SearchTest expected only 1 node match", (nodeDefs.length == 1 ? 1 : 0) != 0);
                ArrayList<PropertyDefinition> nodeProperties = new ArrayList<PropertyDefinition>();
                ClassDefinition type = nodeDefs[0].getType();
                RepositoryServiceSystemTest.assertNotNull((String)"SearchTest node type is null", (Object)type);
                PropertyDefinition[] propDefs = type.getProperties();
                if (null != propDefs) {
                    for (Serializable propDef : propDefs) {
                        System.out.println("Adding " + ((ValueDefinition)propDef).getName() + " to node properties.");
                        nodeProperties.add((PropertyDefinition)propDef);
                    }
                }
                for (Serializable classDef : nodeDefs[0].getAspects()) {
                    System.out.println("SearchTest classDef name = " + ((ClassDefinition)classDef).getName());
                    propDefs = ((ClassDefinition)classDef).getProperties();
                    if (null == propDefs) continue;
                    for (PropertyDefinition propDef : propDefs) {
                        if (propDef.isMandatory()) {
                            System.out.println("Adding " + propDef.getName() + " from aspect " + ((ClassDefinition)classDef).getName() + " to node properties.");
                            nodeProperties.add(propDef);
                            continue;
                        }
                        System.out.println("Property " + propDef.getName() + " from aspect " + ((ClassDefinition)classDef).getName() + " is not mandatory, not adding to node properties.");
                    }
                }
                HashMap<String, NamedValue> searchProperties = new HashMap<String, NamedValue>();
                for (NamedValue column : row.getColumns()) {
                    System.out.println("Adding " + column.getName() + " to search properties.");
                    searchProperties.put(column.getName(), column);
                }
                String[] missingProperties = this.getMissingProperties(nodeProperties, searchProperties);
                if (missingProperties.length <= 0) continue;
                StringBuilder sb = new StringBuilder("Search results do not include all node properties\n");
                for (String missingProp : missingProperties) {
                    sb.append("Missing property: " + missingProp + "\n");
                }
                RepositoryServiceSystemTest.fail((String)sb.toString());
            }
        } else {
            logger.debug((Object)"The query returned no results");
            RepositoryServiceSystemTest.fail((String)"The query returned no results");
        }
    }

    public void test05QueryParents() throws Exception {
        Reference node = BaseWebServiceSystemTest.rootReference;
        String rootId = node.getUuid();
        QueryResult rootChildren = WebServiceFactory.getRepositoryService().queryChildren(node);
        RepositoryServiceSystemTest.assertNotNull((String)"rootChildren should not be null", (Object)rootChildren);
        ResultSet rootChildrenResults = rootChildren.getResultSet();
        RepositoryServiceSystemTest.assertNotNull((String)"rootChildrenResults should not be null", (Object)rootChildrenResults);
        RepositoryServiceSystemTest.assertTrue((String)"There should be at least one child of the root node", (rootChildrenResults.getRows().length > 0 ? 1 : 0) != 0);
        ResultSetRow firstRow = rootChildrenResults.getRows(0);
        RepositoryServiceSystemTest.assertNotNull((String)"getColumns() should not return null", (Object)firstRow.getColumns());
        String id = firstRow.getNode().getId();
        logger.debug((Object)("Retrieving parents for first node found: " + id + "...."));
        node = new Reference();
        node.setStore(BaseWebServiceSystemTest.store);
        node.setUuid(id);
        QueryResult parents = WebServiceFactory.getRepositoryService().queryParents(node);
        RepositoryServiceSystemTest.assertNotNull((String)"parents should not be null", (Object)parents);
        ResultSet parentsResults = parents.getResultSet();
        RepositoryServiceSystemTest.assertNotNull((String)"parentsResults should not be null", (Object)parentsResults);
        RepositoryServiceSystemTest.assertTrue((String)"There should be at least one parent", (parentsResults.getRows().length > 0 ? 1 : 0) != 0);
        boolean rootFound = false;
        ResultSetRow[] rows = parentsResults.getRows();
        logger.debug((Object)("There are " + rows.length + " rows:"));
        for (int x = 0; x < rows.length; ++x) {
            ResultSetRow row = rows[x];
            RepositoryServiceSystemTest.assertNotNull((String)"getColumns() should not return null", (Object)row.getColumns());
            ResultSetRowNode rowNode = row.getNode();
            String nodeId = rowNode.getId();
            logger.debug((Object)("parent node = " + nodeId + ", type = " + rowNode.getType()));
            NamedValue[] columns = row.getColumns();
            for (int y = 0; y < columns.length; ++y) {
                logger.debug((Object)("row " + x + ": " + row.getColumns(y).getName() + " = " + row.getColumns(y).getValue()));
            }
            RepositoryServiceSystemTest.assertNotNull((Object)rowNode);
            RepositoryServiceSystemTest.assertNotNull((Object)rowNode.getId());
            RepositoryServiceSystemTest.assertNotNull((Object)rowNode.getType());
            String[] aspects = rowNode.getAspects();
            RepositoryServiceSystemTest.assertNotNull((Object)aspects);
            if (!nodeId.equals(rootId)) continue;
            rootFound = true;
        }
        RepositoryServiceSystemTest.assertTrue((String)"The root node was not found as one of the parents!!", (boolean)rootFound);
    }

    public void test06QueryChildren() throws Exception {
        Reference node = BaseWebServiceSystemTest.rootReference;
        QueryResult rootChildren = WebServiceFactory.getRepositoryService().queryChildren(node);
        RepositoryServiceSystemTest.assertNotNull((String)"rootChildren should not be null", (Object)rootChildren);
        ResultSet rootChildrenResults = rootChildren.getResultSet();
        RepositoryServiceSystemTest.assertNotNull((String)"rootChildrenResults should not be null", (Object)rootChildrenResults);
        RepositoryServiceSystemTest.assertTrue((String)"There should be at least one child of the root node", (rootChildrenResults.getRows().length > 0 ? 1 : 0) != 0);
        ResultSetRow[] rows = rootChildrenResults.getRows();
        logger.debug((Object)("There are " + rows.length + " rows:"));
        for (int x = 0; x < rows.length; ++x) {
            ResultSetRow row = rows[x];
            RepositoryServiceSystemTest.assertNotNull((String)"getColumns() should not return null", (Object)row.getColumns());
            ResultSetRowNode rowNode = row.getNode();
            String nodeId = rowNode.getId();
            logger.debug((Object)("child node = " + nodeId + ", type = " + rowNode.getType()));
            RepositoryServiceSystemTest.assertNotNull((Object)rowNode);
            RepositoryServiceSystemTest.assertNotNull((Object)rowNode.getId());
            RepositoryServiceSystemTest.assertNotNull((Object)rowNode.getType());
            String[] aspects = rowNode.getAspects();
            RepositoryServiceSystemTest.assertNotNull((Object)aspects);
            NamedValue[] columns = row.getColumns();
            for (int y = 0; y < columns.length; ++y) {
                logger.debug((Object)("row " + x + ": " + row.getColumns(y).getName() + " = " + row.getColumns(y).getValue()));
            }
        }
    }

    public void test07QueryAssociated() throws Exception {
        Association association = new Association(Constants.createQNameString("http://www.alfresco.org/model/content/1.0", "attachments"), "target");
        QueryResult result = WebServiceFactory.getRepositoryService().queryAssociated(BaseWebServiceSystemTest.contentReference, association);
        RepositoryServiceSystemTest.assertNotNull((Object)result);
        RepositoryServiceSystemTest.assertNotNull((Object)result.getResultSet());
        RepositoryServiceSystemTest.assertNotNull((Object)result.getResultSet().getRows());
        RepositoryServiceSystemTest.assertEquals((int)1, (int)result.getResultSet().getRows().length);
        logger.debug((Object)"There is 1 result row:");
        ResultSetRow row = result.getResultSet().getRows()[0];
        NamedValue[] columns = row.getColumns();
        for (int y = 0; y < columns.length; ++y) {
            logger.debug((Object)("row 0: " + row.getColumns(y).getName() + " = " + row.getColumns(y).getValue()));
        }
        ResultSetRowNode rowNode = row.getNode();
        RepositoryServiceSystemTest.assertNotNull((Object)rowNode);
        RepositoryServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.contentReference2.getUuid(), (String)rowNode.getId());
        RepositoryServiceSystemTest.assertNotNull((Object)rowNode.getType());
        String[] aspects = rowNode.getAspects();
        RepositoryServiceSystemTest.assertNotNull((Object)aspects);
        Association association2 = new Association(Constants.createQNameString("http://www.alfresco.org/model/content/1.0", "attachments"), "source");
        QueryResult result2 = WebServiceFactory.getRepositoryService().queryAssociated(BaseWebServiceSystemTest.contentReference2, association2);
        RepositoryServiceSystemTest.assertNotNull((Object)result2);
        RepositoryServiceSystemTest.assertNotNull((Object)result2.getResultSet());
        RepositoryServiceSystemTest.assertNotNull((Object)result2.getResultSet().getRows());
        RepositoryServiceSystemTest.assertEquals((int)1, (int)result2.getResultSet().getRows().length);
        ResultSetRow row2 = result2.getResultSet().getRows()[0];
        ResultSetRowNode rowNode2 = row2.getNode();
        RepositoryServiceSystemTest.assertNotNull((Object)rowNode2);
        RepositoryServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.contentReference.getUuid(), (String)rowNode2.getId());
        RepositoryServiceSystemTest.assertNotNull((Object)rowNode2.getType());
        String[] aspects2 = rowNode2.getAspects();
        RepositoryServiceSystemTest.assertNotNull((Object)aspects2);
    }

    public void test08Describe() throws Exception {
        Query query = new Query("lucene", "( +@\\{http\\://www.alfresco.org/1.0\\}name:test*) OR  TEXT:test*");
        QueryResult queryResult = this.repositoryService.query(BaseWebServiceSystemTest.store, query, false);
        RepositoryServiceSystemTest.assertNotNull((String)"queryResult should not be null", (Object)queryResult);
        ResultSet resultSet = queryResult.getResultSet();
        RepositoryServiceSystemTest.assertNotNull((String)"The result set should not be null", (Object)resultSet);
        RepositoryServiceSystemTest.assertTrue((String)"There should be at least one result", (resultSet.getTotalRowCount() > 0L ? 1 : 0) != 0);
        String id = resultSet.getRows(0).getNode().getId();
        RepositoryServiceSystemTest.assertNotNull((String)"Id of Alfresco Tutorial PDF should not be null", (Object)id);
        Reference ref = new Reference();
        ref.setStore(BaseWebServiceSystemTest.store);
        ref.setUuid(id);
        Predicate predicate = new Predicate(new Reference[]{ref}, null, null);
        NodeDefinition[] nodeDefs = WebServiceFactory.getRepositoryService().describe(predicate);
        RepositoryServiceSystemTest.assertNotNull((String)"nodeDefs should not be null", (Object)nodeDefs);
        RepositoryServiceSystemTest.assertTrue((String)"There should only be one result", (nodeDefs.length == 1 ? 1 : 0) != 0);
        NodeDefinition nodeDef = nodeDefs[0];
        RepositoryServiceSystemTest.assertNotNull((String)"The nodeDef should not be null", (Object)nodeDef);
        ClassDefinition typeDef = nodeDef.getType();
        RepositoryServiceSystemTest.assertNotNull((String)"Type definition should not be null", (Object)typeDef);
        RepositoryServiceSystemTest.assertEquals((String)"Type name is incorrect", (String)"{http://www.alfresco.org/model/content/1.0}content", (String)typeDef.getName());
        RepositoryServiceSystemTest.assertEquals((String)"Superclass type name is incorrect", (String)"{http://www.alfresco.org/model/content/1.0}cmobject", (String)typeDef.getSuperClass());
        RepositoryServiceSystemTest.assertEquals((String)"Type title is incorrect", (String)"Content", (String)typeDef.getTitle());
        RepositoryServiceSystemTest.assertEquals((String)"Type description is incorrect", (String)"Base Content Object", (String)typeDef.getDescription());
        RepositoryServiceSystemTest.assertFalse((String)"Type is an aspect and it shouldn't be", (boolean)typeDef.isIsAspect());
        RepositoryServiceSystemTest.assertNull((String)"There should not be any associations", (Object)typeDef.getAssociations());
        RepositoryServiceSystemTest.assertNotNull((String)"Properties should not be null", (Object)typeDef.getProperties());
        RepositoryServiceSystemTest.assertEquals((String)"There should be 2 properties", (int)2, (int)typeDef.getProperties().length);
        PropertyDefinition[] propertyDefs = typeDef.getProperties();
        boolean foundContent = false;
        boolean foundName = false;
        for (PropertyDefinition propertyDef : propertyDefs) {
            String name = propertyDef.getName();
            if (name.equals("{http://www.alfresco.org/model/content/1.0}content")) {
                foundContent = true;
                RepositoryServiceSystemTest.assertEquals((String)"cm:content property data type is incorrect", (String)"{http://www.alfresco.org/model/dictionary/1.0}content", (String)propertyDef.getDataType());
                continue;
            }
            if (!name.equals("{http://www.alfresco.org/model/content/1.0}name")) continue;
            foundName = true;
            RepositoryServiceSystemTest.assertEquals((String)"cm:name property data type is incorrect", (String)"{http://www.alfresco.org/model/dictionary/1.0}text", (String)propertyDef.getDataType());
        }
        RepositoryServiceSystemTest.assertTrue((boolean)foundContent);
        RepositoryServiceSystemTest.assertTrue((boolean)foundName);
        ClassDefinition[] aspectDefs = nodeDef.getAspects();
        RepositoryServiceSystemTest.assertNotNull((String)"aspects should not be null", (Object)aspectDefs);
        RepositoryServiceSystemTest.assertEquals((String)"There should be 4 aspects", (int)4, (int)aspectDefs.length);
        for (ClassDefinition aspectDef : aspectDefs) {
            RepositoryServiceSystemTest.assertTrue((String)"Not an aspect", (boolean)aspectDef.isIsAspect());
            String name = aspectDef.getName();
            if (name.equals("{http://www.alfresco.org/model/system/1.0}referenceable")) {
                RepositoryServiceSystemTest.assertEquals((String)"Wrong number of properties", (int)4, (int)aspectDef.getProperties().length);
                continue;
            }
            if (name.equals("{http://www.alfresco.org/model/system/1.0}localized")) {
                RepositoryServiceSystemTest.assertEquals((String)"Wrong number of properties", (int)1, (int)aspectDef.getProperties().length);
                continue;
            }
            if (!name.equals("{http://www.alfresco.org/model/content/1.0}auditable")) continue;
            RepositoryServiceSystemTest.assertEquals((String)"Wrong number of properties", (int)5, (int)aspectDef.getProperties().length);
        }
    }

    public void test09PredicateQuery() throws Exception {
        Query query = new Query("lucene", "( +@\\{http\\://www.alfresco.org/1.0\\}name:test*) OR  TEXT:test*");
        Predicate predicate = new Predicate();
        predicate.setQuery(query);
        predicate.setStore(BaseWebServiceSystemTest.store);
        NodeDefinition[] nodeDefs = WebServiceFactory.getRepositoryService().describe(predicate);
        RepositoryServiceSystemTest.assertNotNull((String)"nodeDefs should not be null", (Object)nodeDefs);
        RepositoryServiceSystemTest.assertTrue((String)"There should be at least one result", (nodeDefs.length > 0 ? 1 : 0) != 0);
        NodeDefinition nodeDef = nodeDefs[0];
        RepositoryServiceSystemTest.assertNotNull((String)"The nodeDef should not be null", (Object)nodeDef);
        ClassDefinition typeDef = nodeDef.getType();
        RepositoryServiceSystemTest.assertNotNull((String)"Type definition should not be null", (Object)typeDef);
        logger.debug((Object)("type name = " + typeDef.getName()));
        logger.debug((Object)("is aspect = " + typeDef.isIsAspect()));
        PropertyDefinition[] propDefs = typeDef.getProperties();
        if (propDefs != null) {
            logger.debug((Object)("There are " + propDefs.length + " properties:"));
            for (int x = 0; x < propDefs.length; ++x) {
                PropertyDefinition propDef = propDefs[x];
                logger.debug((Object)("name = " + propDef.getName() + " type = " + propDef.getDataType()));
            }
        }
    }

    public void test10PathReference() throws Exception {
        Reference ref = new Reference();
        ref.setStore(BaseWebServiceSystemTest.store);
        ref.setPath("//*[@cm:name = 'test folder']");
        Predicate predicate = new Predicate();
        predicate.setNodes(new Reference[]{ref});
        NodeDefinition[] nodeDefs = WebServiceFactory.getRepositoryService().describe(predicate);
        RepositoryServiceSystemTest.assertNotNull((String)"nodeDefs should not be null", (Object)nodeDefs);
        RepositoryServiceSystemTest.assertTrue((String)"There should be at least one result", (nodeDefs.length > 0 ? 1 : 0) != 0);
        NodeDefinition nodeDef = nodeDefs[0];
        RepositoryServiceSystemTest.assertNotNull((String)"The nodeDef should not be null", (Object)nodeDef);
        ClassDefinition typeDef = nodeDef.getType();
        RepositoryServiceSystemTest.assertNotNull((String)"Type definition should not be null", (Object)typeDef);
        logger.debug((Object)("type name = " + typeDef.getName()));
        RepositoryServiceSystemTest.assertEquals((String)"Type is incorrect", (String)"{http://www.alfresco.org/model/content/1.0}folder", (String)typeDef.getName());
        logger.debug((Object)("is aspect = " + typeDef.isIsAspect()));
        RepositoryServiceSystemTest.assertFalse((String)"Item should not be an aspect", (boolean)typeDef.isIsAspect());
        PropertyDefinition[] propDefs = typeDef.getProperties();
        if (propDefs != null) {
            logger.debug((Object)("There are " + propDefs.length + " properties:"));
            for (int x = 0; x < propDefs.length; ++x) {
                PropertyDefinition propDef = propDefs[x];
                logger.debug((Object)("name = " + propDef.getName() + " type = " + propDef.getDataType()));
            }
        }
    }

    public void test11Update() throws Exception {
        CMLCreate create = new CMLCreate();
        create.setId("id1");
        create.setType(Constants.TYPE_CONTENT);
        ParentReference parentReference = new ParentReference();
        parentReference.setAssociationType(Constants.ASSOC_CHILDREN);
        parentReference.setChildName(Constants.ASSOC_CHILDREN);
        parentReference.setStore(BaseWebServiceSystemTest.store);
        parentReference.setUuid(BaseWebServiceSystemTest.rootReference.getUuid());
        create.setParent(parentReference);
        create.setProperty(new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, "name.txt", null)});
        CMLCreate createFolder = new CMLCreate();
        createFolder.setId("folder1");
        createFolder.setType(Constants.TYPE_FOLDER);
        createFolder.setParent(parentReference);
        createFolder.setProperty(new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, "tempFolder", null)});
        CMLAddAspect aspect = new CMLAddAspect();
        aspect.setAspect(Constants.ASPECT_VERSIONABLE);
        aspect.setWhere_id("id1");
        ContentFormat format = new ContentFormat("text/plain", "UTF-8");
        CMLWriteContent write = new CMLWriteContent();
        write.setProperty(Constants.PROP_CONTENT);
        write.setContent("this is a test".getBytes());
        write.setFormat(format);
        write.setWhere_id("id1");
        CML cml = new CML();
        cml.setCreate(new CMLCreate[]{create, createFolder});
        cml.setAddAspect(new CMLAddAspect[]{aspect});
        cml.setWriteContent(new CMLWriteContent[]{write});
        UpdateResult[] results = WebServiceFactory.getRepositoryService().update(cml);
        RepositoryServiceSystemTest.assertNotNull((Object)results);
        RepositoryServiceSystemTest.assertEquals((int)4, (int)results.length);
        Reference reference = results[0].getDestination();
        Reference folderReference = results[1].getDestination();
        Content[] content = WebServiceFactory.getContentService().read(new Predicate(new Reference[]{reference}, null, null), Constants.PROP_CONTENT);
        RepositoryServiceSystemTest.assertNotNull((Object)content);
        RepositoryServiceSystemTest.assertEquals((int)1, (int)content.length);
        RepositoryServiceSystemTest.assertEquals((String)"this is a test", (String)ContentUtils.getContentAsString(content[0]));
        CMLCopy copy = new CMLCopy();
        copy.setTo(new ParentReference(folderReference.getStore(), folderReference.getUuid(), null, Constants.ASSOC_CONTAINS, "{http://www.alfresco.org/model/content/1.0}name.txt"));
        copy.setWhere(new Predicate(new Reference[]{reference}, null, null));
        CML cmlCopy = new CML();
        cmlCopy.setCopy(new CMLCopy[]{copy});
        UpdateResult[] results2 = WebServiceFactory.getRepositoryService().update(cmlCopy);
        RepositoryServiceSystemTest.assertNotNull((Object)results2);
        RepositoryServiceSystemTest.assertEquals((int)1, (int)results2.length);
        Reference newCopy = results2[0].getDestination();
        RepositoryServiceSystemTest.assertNotNull((Object)newCopy);
        Node[] nodes = this.repositoryService.get(new Predicate(new Reference[]{newCopy}, null, null));
        Node node = nodes[0];
        boolean checked = false;
        for (NamedValue namedValue : node.getProperties()) {
            if (!namedValue.getName().equals(Constants.PROP_NAME)) continue;
            RepositoryServiceSystemTest.assertEquals((String)"name.txt", (String)namedValue.getValue());
            checked = true;
        }
        RepositoryServiceSystemTest.assertTrue((boolean)checked);
        CMLCopy copy2 = new CMLCopy();
        copy2.setTo(new ParentReference(folderReference.getStore(), folderReference.getUuid(), null, Constants.ASSOC_CONTAINS, "{http://www.alfresco.org/model/content/1.0}name.txt"));
        copy2.setWhere(new Predicate(new Reference[]{reference}, null, null));
        CML cmlCopy2 = new CML();
        cmlCopy2.setCopy(new CMLCopy[]{copy2});
        UpdateResult[] results22 = WebServiceFactory.getRepositoryService().update(cmlCopy2);
        RepositoryServiceSystemTest.assertNotNull((Object)results22);
        RepositoryServiceSystemTest.assertEquals((int)1, (int)results22.length);
        Reference newCopy2 = results22[0].getDestination();
        RepositoryServiceSystemTest.assertNotNull((Object)newCopy2);
        Node[] nodes2 = this.repositoryService.get(new Predicate(new Reference[]{newCopy2}, null, null));
        Node node2 = nodes2[0];
        boolean checked2 = false;
        for (NamedValue namedValue : node2.getProperties()) {
            if (!namedValue.getName().equals(Constants.PROP_NAME)) continue;
            RepositoryServiceSystemTest.assertFalse((boolean)"name.txt".equals(namedValue.getValue()));
            RepositoryServiceSystemTest.assertTrue((boolean)namedValue.getValue().contains("name.txt"));
            checked2 = true;
        }
        RepositoryServiceSystemTest.assertTrue((boolean)checked2);
        QueryResult result = this.repositoryService.queryChildren(folderReference);
        RepositoryServiceSystemTest.assertEquals((long)2L, (long)result.getResultSet().getTotalRowCount());
        CMLDelete delete = new CMLDelete();
        delete.setWhere(new Predicate(new Reference[]{newCopy}, null, null));
        CML cmlDelete = new CML();
        cmlDelete.setDelete(new CMLDelete[]{delete});
        UpdateResult[] results3 = WebServiceFactory.getRepositoryService().update(cmlDelete);
        RepositoryServiceSystemTest.assertNotNull((Object)results3);
        RepositoryServiceSystemTest.assertEquals((int)1, (int)results3.length);
        UpdateResult updateResult3 = results3[0];
        RepositoryServiceSystemTest.assertNull((Object)updateResult3.getDestination());
        RepositoryServiceSystemTest.assertEquals((String)newCopy.getUuid(), (String)updateResult3.getSource().getUuid());
    }

    public void test12ADB12() throws Exception {
        String fileName = "this is my file.txt";
        String folderName = "this is my folder";
        CMLCreate create = new CMLCreate();
        create.setId("id1");
        create.setType(Constants.TYPE_CONTENT);
        ParentReference parentReference = new ParentReference();
        parentReference.setAssociationType(Constants.ASSOC_CHILDREN);
        parentReference.setChildName(Constants.createQNameString("http://www.alfresco.org/model/content/1.0", fileName));
        parentReference.setStore(BaseWebServiceSystemTest.store);
        parentReference.setUuid(BaseWebServiceSystemTest.rootReference.getUuid());
        create.setParent(parentReference);
        create.setProperty(new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, fileName, null)});
        ParentReference parentReference2 = new ParentReference();
        parentReference2.setAssociationType(Constants.ASSOC_CHILDREN);
        parentReference2.setChildName(Constants.createQNameString("http://www.alfresco.org/model/content/1.0", folderName));
        parentReference2.setStore(BaseWebServiceSystemTest.store);
        parentReference2.setUuid(BaseWebServiceSystemTest.rootReference.getUuid());
        CMLCreate createFolder = new CMLCreate();
        createFolder.setId("folder1");
        createFolder.setType(Constants.TYPE_FOLDER);
        createFolder.setParent(parentReference2);
        createFolder.setProperty(new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, folderName, null)});
        ContentFormat format = new ContentFormat("text/plain", "UTF-8");
        CMLWriteContent write = new CMLWriteContent();
        write.setProperty(Constants.PROP_CONTENT);
        write.setContent("this is a test".getBytes());
        write.setFormat(format);
        write.setWhere_id("id1");
        CML cml = new CML();
        cml.setCreate(new CMLCreate[]{create, createFolder});
        cml.setWriteContent(new CMLWriteContent[]{write});
        UpdateResult[] results = WebServiceFactory.getRepositoryService().update(cml);
        RepositoryServiceSystemTest.assertNotNull((Object)results);
        RepositoryServiceSystemTest.assertEquals((int)3, (int)results.length);
        Reference reference = results[0].getDestination();
        RepositoryServiceSystemTest.assertNotNull((Object)reference);
        Reference folderReference = results[1].getDestination();
        RepositoryServiceSystemTest.assertNotNull((Object)folderReference);
    }

    public void test13Get() throws Exception {
        Predicate predicate = new Predicate(null, BaseWebServiceSystemTest.store, null);
        Node[] nodes = WebServiceFactory.getRepositoryService().get(predicate);
        RepositoryServiceSystemTest.assertNotNull((Object)nodes);
        RepositoryServiceSystemTest.assertEquals((int)1, (int)nodes.length);
        Node rootNode = nodes[0];
        RepositoryServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.rootReference.getUuid(), (String)rootNode.getReference().getUuid());
        logger.debug((Object)("Root node type = " + rootNode.getType()));
        String aspects = "";
        for (String aspect : rootNode.getAspects()) {
            aspects = aspects + aspect + ", ";
        }
        logger.debug((Object)("Root node aspects = " + aspects));
        for (NamedValue prop : rootNode.getProperties()) {
            logger.debug((Object)("Root node property " + prop.getName() + " = " + prop.getValue()));
        }
    }

    public void test14GetPath() throws Exception {
        Predicate predicate = new Predicate(new Reference[]{BaseWebServiceSystemTest.folderReference}, null, null);
        Node[] nodes = WebServiceFactory.getRepositoryService().get(predicate);
        RepositoryServiceSystemTest.assertNotNull((Object)nodes);
        RepositoryServiceSystemTest.assertEquals((int)1, (int)nodes.length);
        Node node = nodes[0];
        String path = node.getReference().getPath();
        String uuid = node.getReference().getUuid();
        logger.debug((Object)("Folder reference path = " + BaseWebServiceSystemTest.folderReference.getPath()));
        logger.debug((Object)("Retrieved node path = " + path));
        logger.debug((Object)("Retrieved node uuid = " + uuid));
        RepositoryServiceSystemTest.assertNotNull((Object)path);
        RepositoryServiceSystemTest.assertNotNull((Object)uuid);
        RepositoryServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.folderReference.getPath(), (String)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test15PropertySetGet() throws Exception {
        CMLCreate create = new CMLCreate();
        create.setId("id1");
        create.setType(Constants.createQNameString("http://www.alfresco.org/model/content/1.0", "dictionaryModel"));
        ParentReference parentReference = new ParentReference(new Store("workspace", "SpacesStore"), null, "/app:company_home/app:dictionary/app:models", Constants.ASSOC_CONTAINS, Constants.ASSOC_CONTAINS);
        create.setParent(parentReference);
        create.setProperty(new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, "testModel.xml", null), new NamedValue(Constants.createQNameString("http://www.alfresco.org/model/content/1.0", "modelActive"), false, "true", null)});
        CML cml = new CML();
        cml.setCreate(new CMLCreate[]{create});
        UpdateResult[] results = WebServiceFactory.getRepositoryService().update(cml);
        Reference model = results[0].getDestination();
        InputStream viewStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/webservice/test/resources/propertymodel.xml");
        byte[] bytes = ContentUtils.convertToByteArray(viewStream);
        this.contentService.write(model, Constants.PROP_CONTENT, bytes, new ContentFormat("text/xml", "UTF-8"));
        try {
            ParentReference parentReference2 = new ParentReference();
            parentReference2.setAssociationType(Constants.ASSOC_CHILDREN);
            parentReference2.setChildName(Constants.ASSOC_CHILDREN);
            parentReference2.setStore(BaseWebServiceSystemTest.store);
            parentReference2.setUuid(BaseWebServiceSystemTest.rootReference.getUuid());
            create = new CMLCreate();
            create.setId("id1");
            create.setType(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "testproperties"));
            create.setParent(parentReference2);
            cml = new CML();
            cml.setCreate(new CMLCreate[]{create});
            UpdateResult[] results2 = WebServiceFactory.getRepositoryService().update(cml);
            Reference reference = results2[0].getDestination();
            ArrayList<String> list = new ArrayList<String>();
            list.add("Filrst sadf d");
            list.add("Seconf sdfasdf");
            System.out.println(((Object)list).toString());
            System.out.println(new String[]{"firstValue", "secondValue", "thirdValue"}.toString());
            NamedValue[] properties = new NamedValue[]{Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "textProp"), "some text"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "intProp"), "12"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "longProp"), "1234567890"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "floatProp"), "12.345"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "doubleProp"), "12.345"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "dateProp"), "2005-09-16T00:00:00.000+00:00"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "datetimeProp"), "2005-09-16T17:01:03.456+01:00"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "booleanProp"), "false"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "qnameProp"), "{http://www.alfresco.org/model/webservicetestmodel/1.0}testProperties"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "noderefProp"), "workspace://SpacesStore/123123123"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "textMultiProp"), new String[]{"firstValue", "secondValue", "thirdValue"})};
            CMLUpdate cmlUpdate = new CMLUpdate(properties, new Predicate(new Reference[]{reference}, null, null), null);
            cml = new CML();
            cml.setUpdate(new CMLUpdate[]{cmlUpdate});
            WebServiceFactory.getRepositoryService().update(cml);
            Node[] nodes = WebServiceFactory.getRepositoryService().get(new Predicate(new Reference[]{reference}, null, null));
            Node node = nodes[0];
            for (NamedValue namedValue : node.getProperties()) {
                if (namedValue.getIsMultiValue() == null || !namedValue.getIsMultiValue().booleanValue()) {
                    System.out.println(namedValue.getName() + " = " + namedValue.getValue());
                    continue;
                }
                System.out.print(namedValue.getName() + " = ");
                for (String value : namedValue.getValues()) {
                    System.out.print(value + " ");
                }
                System.out.println("");
            }
        }
        catch (Throwable throwable) {
            Predicate where = new Predicate(new Reference[]{model}, null, null);
            CMLDelete cmlDelete = new CMLDelete(where);
            cml = new CML();
            cml.setDelete(new CMLDelete[]{cmlDelete});
            WebServiceFactory.getRepositoryService().update(cml);
            throw throwable;
        }
        Predicate where = new Predicate(new Reference[]{model}, null, null);
        CMLDelete cmlDelete = new CMLDelete(where);
        cml = new CML();
        cml.setDelete(new CMLDelete[]{cmlDelete});
        WebServiceFactory.getRepositoryService().update(cml);
    }

    public void test16FolderCreate() throws Exception {
        Reference newFolder = this.createFolder(BaseWebServiceSystemTest.rootReference, "123TestFolder");
        RepositoryServiceSystemTest.assertNotNull((Object)newFolder);
        Reference newFolder2 = this.createFolder(BaseWebServiceSystemTest.rootReference, "2007");
        RepositoryServiceSystemTest.assertNotNull((Object)newFolder2);
    }

    public void test17PathLookup() throws Exception {
        Reference newFolder = this.createFolder(BaseWebServiceSystemTest.rootReference, "A Test Folder");
        this.queryForFolder(newFolder.getPath(), newFolder);
        this.queryForFolder("/cm:" + ISO9075.encode("A Test Folder"), newFolder);
    }

    public void xtestQuerySession() throws Exception {
        String querySession;
        Query query = new Query("lucene", "*");
        int batchSize = 5;
        QueryConfiguration queryCfg = new QueryConfiguration();
        queryCfg.setFetchSize(batchSize);
        WebServiceFactory.getRepositoryService().setHeader(new RepositoryServiceLocator().getServiceName().getNamespaceURI(), "QueryHeader", queryCfg);
        QueryResult queryResult = WebServiceFactory.getRepositoryService().query(BaseWebServiceSystemTest.store, query, false);
        RepositoryServiceSystemTest.assertNotNull((String)"queryResult should not be null", (Object)queryResult);
        String origQuerySession = querySession = queryResult.getQuerySession();
        RepositoryServiceSystemTest.assertNotNull((String)"querySession should not be null", (Object)querySession);
        ResultSet resultSet = queryResult.getResultSet();
        RepositoryServiceSystemTest.assertNotNull((String)"The result set should not be null", (Object)resultSet);
        logger.debug((Object)("There are " + resultSet.getTotalRowCount() + " rows in total"));
        logger.debug((Object)("There are " + resultSet.getRows().length + " rows in the first set"));
        RepositoryServiceSystemTest.assertTrue((String)("The result set size should be " + batchSize), (resultSet.getRows().length == batchSize ? 1 : 0) != 0);
        queryResult = WebServiceFactory.getRepositoryService().fetchMore(querySession);
        RepositoryServiceSystemTest.assertNotNull((String)"queryResult should not be null", (Object)queryResult);
        querySession = queryResult.getQuerySession();
        RepositoryServiceSystemTest.assertNotNull((String)"querySession should not be null", (Object)querySession);
        ResultSet resultSet2 = queryResult.getResultSet();
        RepositoryServiceSystemTest.assertNotNull((String)"The second result set should not be null", (Object)resultSet2);
        logger.debug((Object)("There are " + resultSet2.getRows().length + " rows in the second set"));
        RepositoryServiceSystemTest.assertEquals((String)("The result set size should be " + batchSize), (int)batchSize, (int)resultSet2.getRows().length);
        while (querySession != null) {
            queryResult = WebServiceFactory.getRepositoryService().fetchMore(querySession);
            RepositoryServiceSystemTest.assertNotNull((String)"queryResult returned in loop should not be null", (Object)queryResult);
            querySession = queryResult.getQuerySession();
            logger.debug((Object)("There were another " + queryResult.getResultSet().getRows().length + " rows returned"));
        }
        try {
            queryResult = WebServiceFactory.getRepositoryService().fetchMore(origQuerySession);
            RepositoryServiceSystemTest.fail((String)"We should have seen an error as all the results have been returned");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private Reference createFolder(Reference parent, String folderName) throws Exception {
        ParentReference parentReference = new ParentReference();
        parentReference.setAssociationType(Constants.ASSOC_CHILDREN);
        parentReference.setChildName(Constants.createQNameString("http://www.alfresco.org/model/content/1.0", folderName));
        parentReference.setStore(parent.getStore());
        parentReference.setUuid(parent.getUuid());
        NamedValue[] properties = new NamedValue[]{Utils.createNamedValue(Constants.PROP_NAME, folderName)};
        CMLCreate create = new CMLCreate("1", parentReference, null, null, null, Constants.TYPE_FOLDER, properties);
        CML cml = new CML();
        cml.setCreate(new CMLCreate[]{create});
        UpdateResult[] results = WebServiceFactory.getRepositoryService().update(cml);
        return results[0].getDestination();
    }

    private void queryForFolder(String pathName, Reference expected) throws Exception {
        Reference folderRef = new Reference(BaseWebServiceSystemTest.store, null, pathName);
        Node[] nodes = this.repositoryService.get(new Predicate(new Reference[]{folderRef}, null, null));
        if (nodes == null || nodes.length < 1) {
            RepositoryServiceSystemTest.fail((String)"No such folder found.");
        } else if (nodes.length > 1) {
            RepositoryServiceSystemTest.fail((String)"Found more than one reference--should only be one.");
        } else {
            Reference ref = nodes[0].getReference();
            RepositoryServiceSystemTest.assertNotNull((Object)ref);
            RepositoryServiceSystemTest.assertEquals((String)expected.getUuid(), (String)ref.getUuid());
            RepositoryServiceSystemTest.assertEquals((String)expected.getPath(), (String)ref.getPath());
        }
    }
}

