/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.runner;

import java.io.File;
import java.io.PrintWriter;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestProgressMonitor;
import org.apache.chemistry.opencmis.tck.report.TextReport;
import org.apache.chemistry.opencmis.tck.runner.AbstractRunner;

public class ConsoleRunner
extends AbstractRunner {
    public ConsoleRunner(String[] args) throws Exception {
        if (args.length < 1) {
            this.setParameters(null);
        } else {
            this.loadParameters(new File(args[0]));
        }
        if (args.length < 2) {
            this.loadDefaultTckGroups();
        } else {
            this.loadGroups(new File(args[1]));
        }
        this.run(new ConsoleProgressMonitor());
        TextReport report = new TextReport();
        report.createReport(this.getParameters(), this.getGroups(), new PrintWriter(System.out));
    }

    public static void main(String[] args) throws Exception {
        new ConsoleRunner(args);
    }

    private static class ConsoleProgressMonitor
    implements CmisTestProgressMonitor {
        private ConsoleProgressMonitor() {
        }

        public void startGroup(CmisTestGroup group) {
            System.out.println(group.getName() + " (" + group.getTests().size() + " tests)");
        }

        public void endGroup(CmisTestGroup group) {
            System.out.println();
        }

        public void startTest(CmisTest test) {
            System.out.print(".");
        }

        public void endTest(CmisTest test) {
        }

        public void message(String msg) {
            System.out.println(msg);
        }
    }
}

