/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.filing;

import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnfilingTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Unfiling Test");
        this.setDescription("Creates a folder and a document, removes the document from the folder and then adds it again.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        if (this.supportsUnfiling(session)) {
            try {
                Folder testFolder = this.createTestFolder(session);
                Folder folder1 = this.createFolder(session, testFolder, "folder1");
                Document doc1 = this.createDocument(session, folder1, "testdoc.txt", "unfiling test");
                this.addResult(this.checkChildren(session, folder1, "Folder after createDocument()"));
                int count = this.countFolderChildren(folder1);
                CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Folder should have exactly one child but has " + count + " children!");
                this.addResult(this.assertEquals(1, count, null, (CmisTestResult)f));
                int parents = doc1.getParents().size();
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document should have one parent but has " + parents + " parents!");
                this.addResult(this.assertEquals(1, parents, null, (CmisTestResult)f));
                doc1.removeFromFolder((ObjectId)folder1);
                this.addResult(this.checkChildren(session, folder1, "Folder after removeFromFolder()"));
                count = this.countFolderChildren(folder1);
                f = this.createResult(CmisTestResultStatus.FAILURE, "Folder should have no children but has " + count + " children!");
                this.addResult(this.assertEquals(0, count, null, (CmisTestResult)f));
                parents = doc1.getParents().size();
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document should not have no parents but has " + parents + " parents!");
                this.addResult(this.assertEquals(0, parents, null, (CmisTestResult)f));
                doc1.addToFolder((ObjectId)folder1, true);
                this.addResult(this.checkChildren(session, folder1, "Folder after addToFolder()"));
                count = this.countFolderChildren(folder1);
                f = this.createResult(CmisTestResultStatus.FAILURE, "Folder should have exactly one child but has " + count + " children!");
                this.addResult(this.assertEquals(1, count, null, (CmisTestResult)f));
                parents = doc1.getParents().size();
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document should have one parent but has " + parents + " parents!");
                this.addResult(this.assertEquals(1, parents, null, (CmisTestResult)f));
                this.deleteObject((CmisObject)doc1);
                this.deleteObject((CmisObject)folder1);
            }
            finally {
                this.deleteTestFolder();
            }
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Unfiling not supported. Test Skipped!"));
        }
    }

    protected boolean supportsUnfiling(Session session) {
        RepositoryInfo repository = session.getRepositoryInfo();
        if (repository.getCapabilities().isUnfilingSupported() == null) {
            return false;
        }
        return repository.getCapabilities().isUnfilingSupported();
    }
}

