/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import java.io.File;
import java.util.Properties;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.commands.BaseCommand;

public class InitializeCommand
extends BaseCommand {
    public InitializeCommand(File repository, String environment, boolean force) {
        super(repository, environment, force);
    }

    public void execute(String ... args) {
        this.printStream.println("Initializing: " + this.basePath);
        this.createDirectoryIfNecessary(this.basePath);
        this.ensureDirectoryIsEmpty(this.basePath);
        this.createDirectoryIfNecessary(this.envPath);
        this.createDirectoryIfNecessary(this.scriptPath);
        this.createDirectoryIfNecessary(this.driverPath);
        this.copyResourceTo("org/apache/ibatis/migration/template_README", this.baseFile("README"));
        this.copyResourceTo("org/apache/ibatis/migration/template_environment.properties", this.environmentFile());
        this.copyResourceTo("org/apache/ibatis/migration/template_bootstrap.sql", this.scriptFile("bootstrap.sql"));
        this.copyResourceTo("org/apache/ibatis/migration/template_changelog.sql", this.scriptFile(this.getNextIDAsString() + "_create_changelog.sql"));
        this.copyResourceTo("org/apache/ibatis/migration/template_migration.sql", this.scriptFile(this.getNextIDAsString() + "_first_migration.sql"), new Properties(){
            {
                this.setProperty("description", "First migration.");
            }
        });
        this.printStream.println("Done!");
        this.printStream.println();
    }

    protected void ensureDirectoryIsEmpty(File path) {
        String[] list = path.list();
        if (list.length != 0) {
            for (String entry : list) {
                if (entry.startsWith(".")) continue;
                throw new MigrationException("Directory must be empty (.svn etc allowed): " + path.getAbsolutePath());
            }
        }
    }

    protected void createDirectoryIfNecessary(File path) {
        if (!path.exists()) {
            File parent = new File(path.getParent());
            this.createDirectoryIfNecessary(parent);
            this.printStream.println("Creating: " + path.getName());
            if (!path.mkdir()) {
                throw new MigrationException("Could not create directory path for an unknown reason. Make sure you have access to the directory.");
            }
        }
    }
}

