/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.ReaderInputStream;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.defaults.DefaultSqlSessionFactory;

public class SqlSessionFactoryBuilder {
    public SqlSessionFactory build(Reader reader) {
        return this.build(reader, null, null);
    }

    public SqlSessionFactory build(Reader reader, String environment) {
        return this.build(reader, environment, null);
    }

    public SqlSessionFactory build(Reader reader, Properties properties) {
        return this.build(reader, null, properties);
    }

    public SqlSessionFactory build(Reader reader, String environment, Properties props) {
        return this.build(new ReaderInputStream(reader), environment, props);
    }

    public SqlSessionFactory build(InputStream inputStream) {
        return this.build(inputStream, null, null);
    }

    public SqlSessionFactory build(InputStream inputStream, String environment) {
        return this.build(inputStream, environment, null);
    }

    public SqlSessionFactory build(InputStream inputStream, Properties properties) {
        return this.build(inputStream, null, properties);
    }

    public SqlSessionFactory build(InputStream inputStream, String environment, Properties props) {
        try {
            XMLConfigBuilder parser = new XMLConfigBuilder(inputStream, environment, props);
            Configuration config = parser.parse();
            SqlSessionFactory sqlSessionFactory = this.build(config);
            return sqlSessionFactory;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException("Error building SqlSession.", e);
        }
        finally {
            ErrorContext.instance().reset();
            try {
                inputStream.close();
            }
            catch (IOException e) {}
        }
    }

    public SqlSessionFactory build(Configuration config) {
        return new DefaultSqlSessionFactory(config);
    }
}

