/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.blogger;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.data.blogger.BlogCommentFeed;
import com.google.gdata.data.blogger.BlogFeed;
import com.google.gdata.data.blogger.BlogPostFeed;
import com.google.gdata.data.blogger.PostCommentFeed;
import com.google.gdata.util.Version;
import com.google.gdata.util.VersionRegistry;

public class BloggerService
extends GoogleService {
    public static final String BLOGGER_SERVICE = "blogger";
    public static final String BLOGGER_SERVICE_VERSION = "GBlogger-Java/" + BloggerService.class.getPackage().getImplementationVersion();
    public static final Version DEFAULT_VERSION = Service.initServiceVersion(BloggerService.class, (Version)Versions.V2);
    public static final Version BLOGSPOT_VERSION = Versions.V2;

    public BloggerService(String applicationName) {
        super(BLOGGER_SERVICE, applicationName);
        this.declareExtensions();
    }

    public BloggerService(String applicationName, Service.GDataRequestFactory requestFactory, AuthTokenFactory authTokenFactory) {
        super(applicationName, requestFactory, authTokenFactory);
        this.declareExtensions();
    }

    public BloggerService(String applicationName, String protocol, String domainName) {
        super(BLOGGER_SERVICE, applicationName, protocol, domainName);
        this.declareExtensions();
    }

    public String getServiceVersion() {
        return BLOGGER_SERVICE_VERSION + " " + super.getServiceVersion();
    }

    public static Version getVersion() {
        return VersionRegistry.get().getVersion(BloggerService.class);
    }

    private void declareExtensions() {
        new BlogCommentFeed().declareExtensions(this.extProfile);
        new BlogFeed().declareExtensions(this.extProfile);
        new BlogPostFeed().declareExtensions(this.extProfile);
        new PostCommentFeed().declareExtensions(this.extProfile);
    }

    public static final class Versions {
        public static final Version V1 = new Version(BloggerService.class, "1.0", new Version[]{Service.Versions.V1});
        public static final Version V2 = new Version(BloggerService.class, "2.0", new Version[]{Service.Versions.V2});
    }
}

