/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import marquee.xmlrpc.XmlRpcException;
import marquee.xmlrpc.XmlRpcInvocationHandler;
import marquee.xmlrpc.XmlRpcInvocationProcessor;
import marquee.xmlrpc.XmlRpcParser;
import marquee.xmlrpc.XmlRpcSerializer;
import marquee.xmlrpc.XmlRpcServer;
import marquee.xmlrpc.util.Log;
import marquee.xmlrpc.util.Trace;
import org.xml.sax.SAXException;

public class XmlRpcDispatcher
extends XmlRpcParser {
    private static Stack dispatchers = new Stack();
    private static int callSequence;
    private XmlRpcServer server;
    private String callerIp;
    private String methodName;
    private List arguments = new ArrayList();
    private StringBuffer response = new StringBuffer(2048);

    public static synchronized XmlRpcDispatcher getDispatcher(XmlRpcServer server, String callerIp) {
        XmlRpcDispatcher dispatcher = dispatchers.empty() ? new XmlRpcDispatcher() : (XmlRpcDispatcher)dispatchers.pop();
        dispatcher.server = server;
        dispatcher.callerIp = callerIp;
        return dispatcher;
    }

    public void release() {
        this.server = null;
        dispatchers.push(this);
    }

    public byte[] dispatch(InputStream xmlInput) throws Throwable {
        block13: {
            this.arguments.clear();
            this.parse(xmlInput);
            int separator = this.methodName.lastIndexOf(".");
            if (separator > -1) {
                String handlerName = this.methodName.substring(0, separator);
                this.methodName = this.methodName.substring(separator + 1);
                XmlRpcInvocationHandler handler = (XmlRpcInvocationHandler)this.server.handlers.get(handlerName);
                if (handler != null) {
                    int callId = ++callSequence;
                    try {
                        if (!this.preProcess(callId, this.callerIp, handlerName, this.methodName, this.arguments)) {
                            if (Trace.Messages) {
                                Log.append(Trace.Message, "A processor cancelled the invocation");
                            }
                            this.writeError("marquee.xmlrpc.XmlRpcException: The invocation was cancelled by a processor object.");
                            break block13;
                        }
                        Object returnValue = handler.invoke(this.methodName, this.arguments);
                        this.postProcess(callId, this.callerIp, handlerName, this.methodName, this.arguments, returnValue);
                        this.writeResponse(returnValue);
                    }
                    catch (Throwable t) {
                        if (Trace.Errors) {
                            if (t instanceof XmlRpcException) {
                                Log.append(Trace.Error, "Could not setup call. ".concat(String.valueOf(String.valueOf(t.getMessage()))));
                            } else {
                                Log.append(Trace.Error, t);
                            }
                        }
                        this.processException(callId, this.callerIp, handlerName, this.methodName, this.arguments, t);
                        this.writeError(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(t.getClass().getName()))).append(": ").append(t.getMessage()))));
                    }
                } else {
                    if (Trace.Warnings) {
                        Log.append(Trace.Warning, "Unknown handler called: ".concat(String.valueOf(String.valueOf(handlerName))));
                    }
                    this.writeError("marquee.xmlrpc.XmlRpcException: The specified handler cannot be found");
                }
            } else {
                if (Trace.Warnings) {
                    Log.append(Trace.Warning, "Invalid method name format used.");
                }
                this.writeError("marquee.xmlrpc.XmlRpcException: Invalid method name format.");
            }
        }
        return this.response.toString().getBytes();
    }

    public void endElement(String name) throws SAXException {
        if (name.equals("methodName")) {
            this.methodName = this.consumeCharData();
        } else {
            super.endElement(name);
        }
    }

    protected void handleParsedValue(Object value) {
        this.arguments.add(value);
    }

    private boolean preProcess(int callId, String callerIp, String handlerName, String methodName, List arguments) {
        for (int i = 0; i < this.server.processors.size(); ++i) {
            XmlRpcInvocationProcessor p = (XmlRpcInvocationProcessor)this.server.processors.get(i);
            if (p.preProcess(callId, callerIp, handlerName, methodName, arguments)) continue;
            return false;
        }
        return true;
    }

    private void postProcess(int callId, String callerIp, String handlerName, String methodName, List arguments, Object returnValue) {
        for (int i = 0; i < this.server.processors.size(); ++i) {
            XmlRpcInvocationProcessor p = (XmlRpcInvocationProcessor)this.server.processors.get(i);
            p.postProcess(callId, callerIp, handlerName, methodName, arguments, returnValue);
        }
    }

    private void processException(int callId, String callerIp, String handlerName, String methodName, List arguments, Throwable t) {
        for (int i = 0; i < this.server.processors.size(); ++i) {
            XmlRpcInvocationProcessor p = (XmlRpcInvocationProcessor)this.server.processors.get(i);
            p.onException(callId, callerIp, handlerName, methodName, arguments, t);
        }
    }

    private void writeResponse(Object value) {
        this.response.setLength(0);
        this.response.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><methodResponse><params><param>");
        if (value != null) {
            try {
                XmlRpcSerializer.serialize(value, this.response);
                this.response.append("</param></params></methodResponse>");
            }
            catch (XmlRpcException e) {
                this.response.setLength(0);
                this.writeError(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(e.getClass().getName()))).append(": ").append(e.getMessage()))));
            }
        } else {
            this.response.append("<value><string>void</string></value></param></params></methodResponse>");
        }
    }

    private void writeError(String message) {
        this.response.setLength(0);
        this.response.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><methodResponse><fault><value><struct><member><name>faultCode</name><value><int>-1</int></value></member><member><name>faultString</name><value><string>");
        this.response.append(message);
        this.response.append("</string></value></member></struct></value></fault></methodResponse>");
    }
}

