/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc.connections;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import marquee.xmlrpc.XmlRpcClientConnection;
import marquee.xmlrpc.XmlRpcClientConnectionFactory;

public class URLConnectionFactory
implements XmlRpcClientConnectionFactory {
    private final URL url;

    public URLConnectionFactory(URL url) {
        this.url = url;
    }

    public XmlRpcClientConnection createConnection() throws IOException {
        return new URLConnectionImpl(this);
    }

    private class URLConnectionImpl
    implements XmlRpcClientConnection {
        private URLConnection urlConnection;
        private OutputStream output;

        private URLConnectionImpl(URLConnectionFactory this$0) throws IOException {
            this.urlConnection = this$0.url.openConnection();
            this.urlConnection.setDoOutput(true);
            this.urlConnection.setDoInput(true);
            this.urlConnection.setRequestProperty("Content-Type", "text/xml");
        }

        public void setOutputContentLength(int contentLength) {
            this.urlConnection.setRequestProperty("Content-Length", String.valueOf(contentLength));
        }

        public void setKeepAlive(boolean keepAlive) {
            this.urlConnection.setRequestProperty("Connection", keepAlive ? "keep-alive" : "close");
        }

        public void setGzip(boolean gzip) {
            if (gzip) {
                this.urlConnection.setRequestProperty("Accept-Encoding", "gzip");
            }
        }

        public OutputStream getOutputStream() throws IOException {
            this.output = this.urlConnection.getOutputStream();
            return this.output;
        }

        public InputStream getInputStream() throws IOException {
            this.output.close();
            return this.urlConnection.getInputStream();
        }

        public int getInputContentLength() {
            return this.urlConnection.getContentLength();
        }

        public boolean isServerKeepAlive() {
            String connectionHeader = this.urlConnection.getHeaderField("connection");
            return connectionHeader != null && connectionHeader.equals("keep-alive");
        }

        public boolean isInputGzipped() {
            String encodingHeader = this.urlConnection.getContentEncoding();
            return encodingHeader != null && encodingHeader.equals("gzip");
        }

        public void close() throws IOException {
            if (this.urlConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.urlConnection).disconnect();
            }
        }
    }
}

