/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import marquee.xmlrpc.XmlRpcException;
import marquee.xmlrpc.XmlRpcInvocationHandler;

public class ReflectiveInvocationHandler
implements XmlRpcInvocationHandler {
    protected Object target;
    private String[] entryPoints;

    public ReflectiveInvocationHandler() {
        this.target = this;
    }

    public ReflectiveInvocationHandler(Object target) {
        this.target = target;
    }

    public ReflectiveInvocationHandler(Object target, String[] entryPoints) {
        this.target = target;
        this.entryPoints = entryPoints;
    }

    public void setEntryPoints(String[] entryPoints) {
        this.entryPoints = entryPoints;
    }

    public Object invoke(String methodName, Collection arguments) throws Throwable {
        if (this.entryPoints != null) {
            this.checkEntryPoint(methodName);
        }
        Class[] argClasses = null;
        Object[] argValues = null;
        if (arguments != null) {
            argValues = arguments.toArray();
            argClasses = new Class[argValues.length];
            for (int i = 0; i < argValues.length; ++i) {
                argClasses[i] = argValues[i].getClass();
            }
        }
        return this.execute(methodName, argClasses, argValues);
    }

    protected Object execute(String methodName, Class[] argClasses, Object[] argValues) throws Throwable {
        Method[] methods = this.target.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameterTypes;
            Method method = methods[i];
            if (!method.getName().equals(methodName) || (parameterTypes = method.getParameterTypes()).length != argClasses.length) continue;
            for (int j = 0; j < parameterTypes.length && parameterTypes[j].isAssignableFrom(argClasses[j]); ++j) {
            }
            try {
                Object j = method.invoke(this.target, argValues);
                return j;
            }
            catch (InvocationTargetException it_e) {
                throw it_e.getTargetException();
            }
        }
        throw new XmlRpcException("The method cannot be found.");
    }

    private void checkEntryPoint(String methodName) throws XmlRpcException {
        for (int i = 0; i < this.entryPoints.length; ++i) {
            if (!this.entryPoints[i].equals(methodName)) continue;
            return;
        }
        throw new XmlRpcException("The method has not been published or does not exist.");
    }
}

