/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import marquee.xmlrpc.util.ExceptionPrintWriter;
import marquee.xmlrpc.util.LogBackEnd;

public class Log {
    private static Vector backEnds = new Vector(4);
    private static boolean userBackEndAdded = false;

    public static void addBackEnd(LogBackEnd backEnd) {
        if (!userBackEndAdded) {
            backEnds.clear();
            userBackEndAdded = true;
        }
        backEnds.addElement(backEnd);
    }

    public static void append(String type, String message) {
        for (int i = 0; i < backEnds.size(); ++i) {
            ((LogBackEnd)backEnds.elementAt(i)).append(type, message);
        }
    }

    public static void append(String type, Throwable t) {
        if (!userBackEndAdded) {
            ((LogBackEnd)backEnds.elementAt(0)).append(type, t);
        } else {
            Log.append(type, t.toString());
        }
    }

    static {
        backEnds.addElement(new DefaultLogBackEnd());
    }

    public static class DefaultLogBackEnd
    implements LogBackEnd {
        public static final boolean LOG_TIME = true;
        public static final boolean LOG_THREAD = true;
        public static final boolean LOG_FILE = true;
        private static ExceptionPrintWriter writer;
        private static Date time;
        private static DateFormat dateFormat;

        public void append(String type, String message) {
            this.appendPrefix(type);
            writer.write(message);
            writer.write(10);
            writer.flush();
        }

        public void append(String type, Throwable t) {
            this.appendPrefix(type);
            writer.printException(t);
            writer.write(10);
            writer.flush();
        }

        private void appendPrefix(String type) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                time.setTime(System.currentTimeMillis());
                writer.write(dateFormat.format(time));
                writer.write("  ");
            }
            Thread t = Thread.currentThread();
            writer.write(t.getName());
            writer.write("  ");
            writer.write(type);
            writer.write(": ");
        }

        static {
            LOG_TIME = true;
            LOG_THREAD = true;
            LOG_FILE = true;
            writer = new ExceptionPrintWriter(System.out);
            time = new Date();
            dateFormat = new SimpleDateFormat();
        }
    }
}

