/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.format.FormatUtils;

public abstract class AbstractDuration
implements ReadableDuration {
    protected AbstractDuration() {
    }

    public Duration toDuration() {
        return new Duration(this.getMillis());
    }

    public Period toPeriod() {
        return new Period(this.getMillis());
    }

    public int compareTo(Object obj) {
        long otherMillis;
        AbstractDuration thisDuration = this;
        ReadableDuration otherDuration = (ReadableDuration)obj;
        long thisMillis = thisDuration.getMillis();
        if (thisMillis < (otherMillis = otherDuration.getMillis())) {
            return -1;
        }
        if (thisMillis > otherMillis) {
            return 1;
        }
        return 0;
    }

    public boolean isEqual(ReadableDuration duration) {
        if (duration == null) {
            duration = Duration.ZERO;
        }
        return this.compareTo(duration) == 0;
    }

    public boolean isLongerThan(ReadableDuration duration) {
        if (duration == null) {
            duration = Duration.ZERO;
        }
        return this.compareTo(duration) > 0;
    }

    public boolean isShorterThan(ReadableDuration duration) {
        if (duration == null) {
            duration = Duration.ZERO;
        }
        return this.compareTo(duration) < 0;
    }

    public boolean equals(Object duration) {
        if (this == duration) {
            return true;
        }
        if (!(duration instanceof ReadableDuration)) {
            return false;
        }
        ReadableDuration other = (ReadableDuration)duration;
        return this.getMillis() == other.getMillis();
    }

    public int hashCode() {
        long len = this.getMillis();
        return (int)(len ^ len >>> 32);
    }

    public String toString() {
        long millis = this.getMillis();
        StringBuffer buf = new StringBuffer();
        buf.append("PT");
        FormatUtils.appendUnpaddedInteger(buf, millis / 1000L);
        long part = Math.abs(millis % 1000L);
        if (part > 0L) {
            buf.append('.');
            FormatUtils.appendPaddedInteger(buf, part, 3);
        }
        buf.append('S');
        return buf.toString();
    }

    public abstract long getMillis();
}

