/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.chrono.BasicMonthOfYearDateTimeField;
import org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.chrono.ZonedChronology;

public final class IslamicChronology
extends BasicChronology {
    private static final long serialVersionUID = -3663823829888L;
    public static final int AH = 1;
    private static final DateTimeField ERA_FIELD = new BasicSingleEraDateTimeField("AH");
    public static final LeapYearPatternType LEAP_YEAR_15_BASED = new LeapYearPatternType(0, 623158436);
    public static final LeapYearPatternType LEAP_YEAR_16_BASED = new LeapYearPatternType(1, 623191204);
    public static final LeapYearPatternType LEAP_YEAR_INDIAN = new LeapYearPatternType(2, 690562340);
    public static final LeapYearPatternType LEAP_YEAR_HABASH_AL_HASIB = new LeapYearPatternType(3, 0x9292925);
    private static final int MIN_YEAR = -292269337;
    private static final int MAX_YEAR = 292271022;
    private static final int MONTH_PAIR_LENGTH = 59;
    private static final int LONG_MONTH_LENGTH = 30;
    private static final int SHORT_MONTH_LENGTH = 29;
    private static final long MILLIS_PER_MONTH_PAIR = 5097600000L;
    private static final long MILLIS_PER_MONTH = 2551440384L;
    private static final long MILLIS_PER_LONG_MONTH = 2592000000L;
    private static final long MILLIS_PER_YEAR = 30617280288L;
    private static final long MILLIS_PER_SHORT_YEAR = 30585600000L;
    private static final long MILLIS_PER_LONG_YEAR = 30672000000L;
    private static final long MILLIS_YEAR_1 = -42521587200000L;
    private static final int CYCLE = 30;
    private static final long MILLIS_PER_CYCLE = 918518400000L;
    private static final Map cCache = new HashMap();
    private static final IslamicChronology INSTANCE_UTC = IslamicChronology.getInstance(DateTimeZone.UTC);
    private final LeapYearPatternType iLeapYears;

    public static IslamicChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static IslamicChronology getInstance() {
        return IslamicChronology.getInstance(DateTimeZone.getDefault(), LEAP_YEAR_16_BASED);
    }

    public static IslamicChronology getInstance(DateTimeZone zone) {
        return IslamicChronology.getInstance(zone, LEAP_YEAR_16_BASED);
    }

    public static IslamicChronology getInstance(DateTimeZone zone, LeapYearPatternType leapYears) {
        IslamicChronology chrono;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        Map map = cCache;
        synchronized (map) {
            IslamicChronology[] chronos = (IslamicChronology[])cCache.get(zone);
            if (chronos == null) {
                chronos = new IslamicChronology[4];
                cCache.put(zone, chronos);
            }
            if ((chrono = chronos[leapYears.index]) == null) {
                if (zone == DateTimeZone.UTC) {
                    chrono = new IslamicChronology(null, null, leapYears);
                    DateTime lowerLimit = new DateTime(1, 1, 1, 0, 0, 0, 0, chrono);
                    chrono = new IslamicChronology((Chronology)LimitChronology.getInstance(chrono, lowerLimit, null), null, leapYears);
                } else {
                    chrono = IslamicChronology.getInstance(DateTimeZone.UTC, leapYears);
                    chrono = new IslamicChronology((Chronology)ZonedChronology.getInstance(chrono, zone), null, leapYears);
                }
                chronos[leapYears.index] = chrono;
            }
        }
        return chrono;
    }

    IslamicChronology(Chronology base, Object param, LeapYearPatternType leapYears) {
        super(base, param, 4);
        this.iLeapYears = leapYears;
    }

    private Object readResolve() {
        Chronology base = this.getBase();
        return base == null ? IslamicChronology.getInstanceUTC() : IslamicChronology.getInstance(base.getZone());
    }

    public LeapYearPatternType getLeapYearPatternType() {
        return this.iLeapYears;
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return IslamicChronology.getInstance(zone);
    }

    int getYear(long instant) {
        long millisIslamic = instant - -42521587200000L;
        long cycles = millisIslamic / 918518400000L;
        long cycleRemainder = millisIslamic % 918518400000L;
        int year = (int)(cycles * 30L + 1L);
        long yearMillis = this.isLeapYear(year) ? 30672000000L : 30585600000L;
        while (cycleRemainder >= yearMillis) {
            cycleRemainder -= yearMillis;
            long l = yearMillis = this.isLeapYear(++year) ? 30672000000L : 30585600000L;
        }
        return year;
    }

    long setYear(long instant, int year) {
        int thisYear = this.getYear(instant);
        int dayOfYear = this.getDayOfYear(instant, thisYear);
        int millisOfDay = this.getMillisOfDay(instant);
        if (dayOfYear > 354 && !this.isLeapYear(year)) {
            --dayOfYear;
        }
        instant = this.getYearMonthDayMillis(year, 1, dayOfYear);
        return instant += (long)millisOfDay;
    }

    long getYearDifference(long minuendInstant, long subtrahendInstant) {
        int minuendYear = this.getYear(minuendInstant);
        int subtrahendYear = this.getYear(subtrahendInstant);
        long minuendRem = minuendInstant - this.getYearMillis(minuendYear);
        long subtrahendRem = subtrahendInstant - this.getYearMillis(subtrahendYear);
        int difference = minuendYear - subtrahendYear;
        if (minuendRem < subtrahendRem) {
            --difference;
        }
        return difference;
    }

    long getTotalMillisByYearMonth(int year, int month) {
        if (--month % 2 == 1) {
            return (long)(month /= 2) * 5097600000L + 2592000000L;
        }
        return (long)(month /= 2) * 5097600000L;
    }

    int getDayOfMonth(long millis) {
        int doy = this.getDayOfYear(millis) - 1;
        if (doy == 354) {
            return 30;
        }
        return doy % 59 % 30 + 1;
    }

    boolean isLeapYear(int year) {
        return this.iLeapYears.isLeapYear(year);
    }

    int getDaysInYearMax() {
        return 355;
    }

    int getDaysInYear(int year) {
        return this.isLeapYear(year) ? 355 : 354;
    }

    int getDaysInYearMonth(int year, int month) {
        if (month == 12 && this.isLeapYear(year)) {
            return 30;
        }
        return --month % 2 == 0 ? 30 : 29;
    }

    int getDaysInMonthMax() {
        return 30;
    }

    int getDaysInMonthMax(int month) {
        if (month == 12) {
            return 30;
        }
        return --month % 2 == 0 ? 30 : 29;
    }

    int getMonthOfYear(long millis, int year) {
        int doyZeroBased = (int)((millis - this.getYearMillis(year)) / 86400000L);
        if (doyZeroBased == 354) {
            return 12;
        }
        return doyZeroBased * 2 / 59 + 1;
    }

    long getAverageMillisPerYear() {
        return 30617280288L;
    }

    long getAverageMillisPerMonth() {
        return 2551440384L;
    }

    long calculateFirstDayOfYearMillis(int year) {
        if (year > 292271022) {
            throw new ArithmeticException("Year is too large: " + year + " > " + 292271022);
        }
        if (year < -292269337) {
            throw new ArithmeticException("Year is too small: " + year + " < " + -292269337);
        }
        long cycle = --year / 30;
        long millis = -42521587200000L + cycle * 918518400000L;
        int cycleRemainder = year % 30 + 1;
        int i = 1;
        while (i < cycleRemainder) {
            millis += this.isLeapYear(i) ? 30672000000L : 30585600000L;
            ++i;
        }
        return millis;
    }

    int getMinYear() {
        return 1;
    }

    int getMaxYear() {
        return 292271022;
    }

    long getApproxMillisAtEpoch() {
        return 42521587200000L;
    }

    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
            fields.era = ERA_FIELD;
            fields.monthOfYear = new BasicMonthOfYearDateTimeField(this, 12);
            fields.months = fields.monthOfYear.getDurationField();
        }
    }

    public static class LeapYearPatternType
    implements Serializable {
        private static final long serialVersionUID = 26581275372698L;
        final byte index;
        final int pattern;

        LeapYearPatternType(int index, int pattern) {
            this.index = (byte)index;
            this.pattern = pattern;
        }

        boolean isLeapYear(int year) {
            int key = 1 << year % 30;
            return (this.pattern & key) > 0;
        }

        private Object readResolve() {
            switch (this.index) {
                case 0: {
                    return LEAP_YEAR_15_BASED;
                }
                case 1: {
                    return LEAP_YEAR_16_BASED;
                }
                case 2: {
                    return LEAP_YEAR_INDIAN;
                }
                case 3: {
                    return LEAP_YEAR_HABASH_AL_HASIB;
                }
            }
            return this;
        }
    }
}

