/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.joda.time.DateTimeZone;
import org.joda.time.tz.DateTimeZoneBuilder;
import org.joda.time.tz.Provider;

public class ZoneInfoProvider
implements Provider {
    private final File iFileDir;
    private final String iResourcePath;
    private final ClassLoader iLoader;
    private final Map iZoneInfoMap;

    public ZoneInfoProvider(File fileDir) throws IOException {
        if (fileDir == null) {
            throw new IllegalArgumentException("No file directory provided");
        }
        if (!fileDir.exists()) {
            throw new IOException("File directory doesn't exist: " + fileDir);
        }
        if (!fileDir.isDirectory()) {
            throw new IOException("File doesn't refer to a directory: " + fileDir);
        }
        this.iFileDir = fileDir;
        this.iResourcePath = null;
        this.iLoader = null;
        this.iZoneInfoMap = ZoneInfoProvider.loadZoneInfoMap(this.openResource("ZoneInfoMap"));
    }

    public ZoneInfoProvider(String resourcePath) throws IOException {
        this(resourcePath, null, false);
    }

    public ZoneInfoProvider(String resourcePath, ClassLoader loader) throws IOException {
        this(resourcePath, loader, true);
    }

    private ZoneInfoProvider(String resourcePath, ClassLoader loader, boolean favorSystemLoader) throws IOException {
        if (resourcePath == null) {
            throw new IllegalArgumentException("No resource path provided");
        }
        if (!resourcePath.endsWith("/")) {
            resourcePath = resourcePath + '/';
        }
        this.iFileDir = null;
        this.iResourcePath = resourcePath;
        if (loader == null && !favorSystemLoader) {
            loader = this.getClass().getClassLoader();
        }
        this.iLoader = loader;
        this.iZoneInfoMap = ZoneInfoProvider.loadZoneInfoMap(this.openResource("ZoneInfoMap"));
    }

    public synchronized DateTimeZone getZone(String id) {
        if (id == null) {
            return null;
        }
        Object obj = this.iZoneInfoMap.get(id);
        if (obj == null) {
            return null;
        }
        if (id.equals(obj)) {
            return this.loadZoneData(id);
        }
        if (obj instanceof SoftReference) {
            DateTimeZone tz = (DateTimeZone)((SoftReference)obj).get();
            if (tz != null) {
                return tz;
            }
            return this.loadZoneData(id);
        }
        return this.getZone((String)obj);
    }

    public synchronized Set getAvailableIDs() {
        return Collections.unmodifiableSet(this.iZoneInfoMap.keySet());
    }

    protected void uncaughtException(Exception ex) {
        Thread t = Thread.currentThread();
        t.getThreadGroup().uncaughtException(t, ex);
    }

    private InputStream openResource(String name) throws IOException {
        InputStream in;
        if (this.iFileDir != null) {
            in = new FileInputStream(new File(this.iFileDir, name));
        } else {
            String path = this.iResourcePath.concat(name);
            in = this.iLoader != null ? this.iLoader.getResourceAsStream(path) : ClassLoader.getSystemResourceAsStream(path);
            if (in == null) {
                StringBuffer buf = new StringBuffer(40).append("Resource not found: \"").append(path).append("\" ClassLoader: ").append(this.iLoader != null ? this.iLoader.toString() : "system");
                throw new IOException(buf.toString());
            }
        }
        return in;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DateTimeZone loadZoneData(String id) {
        in = null;
        try {
            try {
                in = this.openResource(id);
                tz = DateTimeZoneBuilder.readFrom(in, id);
                this.iZoneInfoMap.put(id, new SoftReference<DateTimeZone>(tz));
                var4_5 = tz;
                var6_7 = null;
            }
            catch (IOException e) {
                this.uncaughtException(e);
                this.iZoneInfoMap.remove(id);
                var4_6 = null;
                var6_8 = null;
                try {
                    if (in == null) return var4_6;
                    in.close();
                    return var4_6;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return var4_6;
            }
        }
        catch (Throwable var5_13) {
            var6_9 = null;
            try {}
            catch (IOException e) {
                throw var5_13;
            }
            if (in == null) throw var5_13;
            in.close();
            throw var5_13;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 78->89)] { 
lbl37:
        // 1 sources

        if (in == null) return var4_5;
        in.close();
        return var4_5;
lbl40:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var4_5;
    }

    private static Map loadZoneInfoMap(InputStream in) throws IOException {
        TreeMap<String, SoftReference<DateTimeZone>> map = new TreeMap<String, SoftReference<DateTimeZone>>(String.CASE_INSENSITIVE_ORDER);
        DataInputStream din = new DataInputStream(in);
        try {
            ZoneInfoProvider.readZoneInfoMap(din, map);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                din.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            din.close();
        }
        catch (IOException e) {}
        map.put("UTC", new SoftReference<DateTimeZone>(DateTimeZone.UTC));
        return map;
    }

    private static void readZoneInfoMap(DataInputStream din, Map zimap) throws IOException {
        int size = din.readUnsignedShort();
        String[] pool = new String[size];
        int i = 0;
        while (i < size) {
            pool[i] = din.readUTF().intern();
            ++i;
        }
        size = din.readUnsignedShort();
        int i2 = 0;
        while (i2 < size) {
            try {
                zimap.put(pool[din.readUnsignedShort()], pool[din.readUnsignedShort()]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Corrupt zone info map");
            }
            ++i2;
        }
    }
}

