/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.media.mediarss;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.media.mediarss.AbstractMediaResource;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="media", nsUri="http://search.yahoo.com/mrss/", localName="content")
public class MediaContent
extends AbstractMediaResource {
    private long fileSize;
    private String type;
    private String medium;
    private boolean isDefault;
    private Expression expression;
    private int bitrate;
    private int framerate;
    private int samplingrate;
    private int channels;
    private int duration;
    private String language;

    public static ExtensionDescription getDefaultDescription(boolean repeat) {
        ExtensionDescription retval = ExtensionDescription.getDefaultDescription(MediaContent.class);
        retval.setRepeatable(repeat);
        return retval;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public int getChannels() {
        return this.channels;
    }

    public void setChannels(int channels) {
        this.channels = channels;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public int getFramerate() {
        return this.framerate;
    }

    public void setFramerate(int framerate) {
        this.framerate = framerate;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean aDefault) {
        this.isDefault = aDefault;
    }

    public String getMedium() {
        return this.medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public int getSamplingrate() {
        return this.samplingrate;
    }

    public void setSamplingrate(int samplingrate) {
        this.samplingrate = samplingrate;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        super.putAttributes(generator);
        if (this.fileSize > 0L) {
            generator.put("fileSize", this.fileSize);
        }
        generator.put((Object)"type", (Object)this.type);
        generator.put((Object)"medium", (Object)this.medium);
        if (this.isDefault) {
            generator.put("isDefault", this.isDefault);
        }
        generator.put("expression", (Enum)this.expression, (AttributeHelper.EnumToAttributeValue)new AttributeHelper.LowerCaseEnumToAttributeValue());
        if (this.bitrate > 0) {
            generator.put("bitrate", (long)this.bitrate);
        }
        if (this.framerate > 0) {
            generator.put("framerate", (long)this.framerate);
        }
        if (this.samplingrate > 0) {
            generator.put("samplingrate", (long)this.samplingrate);
        }
        if (this.channels > 0) {
            generator.put("channels", (long)this.channels);
        }
        if (this.duration > 0) {
            generator.put("duration", (long)this.duration);
        }
        generator.put((Object)"language", (Object)this.language);
    }

    @Override
    protected void consumeAttributes(AttributeHelper attrsHelper) throws ParseException {
        super.consumeAttributes(attrsHelper);
        this.fileSize = attrsHelper.consumeLong("fileSize", false);
        this.type = attrsHelper.consume("type", false);
        this.medium = attrsHelper.consume("medium", false);
        this.isDefault = attrsHelper.consumeBoolean("isDefault", false);
        this.expression = (Expression)attrsHelper.consumeEnum("expression", false, Expression.class);
        this.bitrate = attrsHelper.consumeInteger("bitrate", false);
        this.framerate = attrsHelper.consumeInteger("framerate", false);
        this.samplingrate = attrsHelper.consumeInteger("samplingrate", false);
        this.channels = attrsHelper.consumeInteger("channels", false);
        this.duration = attrsHelper.consumeInteger("duration", false);
        this.language = attrsHelper.consume("language", false);
    }

    public static enum Expression {
        SAMPLE,
        FULL,
        NONSTOP;

    }
}

