/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.cmis.client.CMISConnection;
import org.alfresco.repo.cmis.client.CMISConnectionImpl;
import org.alfresco.repo.cmis.client.CMISConnectionManager;
import org.alfresco.repo.cmis.client.CMISHelper;
import org.alfresco.repo.cmis.client.CMISServer;
import org.alfresco.repo.cmis.client.CMISServerImpl;
import org.alfresco.repo.cmis.client.CMISServersConfigElement;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.springframework.extensions.config.ConfigService;

public abstract class AbstractCMISConnectionManagerImpl
extends CMISHelper
implements CMISConnectionManager {
    public static final String SERVER_NAME = "name";
    public static final String SERVER_DESCRIPTION = "description";
    public static final String DEFAULT_CONNECTION_ID = "default";
    public static final char RESERVED_ID_CHAR = '$';
    protected ConfigService configService;
    protected AuthenticationService authenticationService;
    protected final SessionFactory sessionFactory = SessionFactoryImpl.newInstance();
    protected LinkedHashMap<String, CMISConnection> sharedConnections;
    protected LinkedHashMap<String, CMISConnection> userConnections;
    protected int userConnectionsCapacity = 1000;
    protected int sharedConnectionsCapacity = 100;
    protected Map<String, CMISServer> servers;
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setUserConnectionsCapacity(int userConnectionsCapacity) {
        this.userConnectionsCapacity = userConnectionsCapacity;
    }

    public void setSharedConnectionsCapacity(int sharedConnectionsCapacity) {
        this.sharedConnectionsCapacity = sharedConnectionsCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.lock.writeLock().lock();
        try {
            this.sharedConnections = new LinkedHashMap<String, CMISConnection>(this.sharedConnectionsCapacity, (float)((int)Math.ceil((double)this.sharedConnectionsCapacity / 0.75) + 1), true){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, CMISConnection> eldest) {
                    return this.size() > AbstractCMISConnectionManagerImpl.this.sharedConnectionsCapacity;
                }
            };
            this.userConnections = new LinkedHashMap<String, CMISConnection>(this.userConnectionsCapacity, (float)((int)Math.ceil((double)this.userConnectionsCapacity / 0.75) + 1), true){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, CMISConnection> eldest) {
                    return this.size() > AbstractCMISConnectionManagerImpl.this.userConnectionsCapacity;
                }
            };
            CMISServersConfigElement cmisServersConfig = (CMISServersConfigElement)this.configService.getConfig((Object)"CMIS").getConfigElement("cmis-servers");
            this.servers = cmisServersConfig != null && cmisServersConfig.getServerDefinitions() != null ? cmisServersConfig.getServerDefinitions() : new HashMap<String, CMISServer>();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CMISConnection createUserConnection(CMISServer server, String connectionId) {
        CMISConnection connection;
        if (connectionId == null || connectionId.length() == 0 || connectionId.indexOf(36) > -1) {
            throw new IllegalArgumentException("Invalid connection id!");
        }
        String currentUser = this.authenticationService.getCurrentUserName();
        if (currentUser == null) {
            throw new IllegalStateException("No current user!");
        }
        String userConnectionId = this.createUserConnectionId(currentUser, connectionId);
        this.lock.writeLock().lock();
        try {
            if (this.userConnections.containsKey(userConnectionId)) {
                throw new IllegalStateException("Connection id is already in use!");
            }
            connection = this.createConnection(server, userConnectionId, false);
            this.userConnections.put(userConnectionId, connection);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return connection;
    }

    protected String createUserConnectionId(String username, String connectionId) {
        return connectionId + '$' + username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CMISConnection createSharedConnection(CMISServer server, String connectionId) {
        CMISConnection connection;
        if (connectionId == null || connectionId.length() == 0 || connectionId.indexOf(36) > -1 || DEFAULT_CONNECTION_ID.equals(connectionId)) {
            throw new IllegalArgumentException("Invalid connection id!");
        }
        this.lock.writeLock().lock();
        try {
            if (this.sharedConnections.containsKey(connectionId)) {
                throw new IllegalStateException("Connection id is already in use!");
            }
            connection = this.createConnection(server, connectionId, true);
            this.sharedConnections.put(connection.getInternalId(), connection);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return connection;
    }

    protected CMISConnection createConnection(CMISServer server, String connectionId, boolean isShared) {
        Session session = this.createSession(server.getParameters());
        String username = server.getParameters().get("org.apache.chemistry.opencmis.user");
        return new CMISConnectionImpl(this, connectionId, session, server, username, false, isShared);
    }

    @Override
    public abstract CMISConnection getConnection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CMISConnection getConnection(String connectionId) {
        this.lock.writeLock().lock();
        try {
            CMISConnection connection = this.sharedConnections.get(connectionId);
            if (connection != null) {
                CMISConnection cMISConnection = connection;
                return cMISConnection;
            }
            String currentUser = this.authenticationService.getCurrentUserName();
            if (currentUser == null) {
                CMISConnection cMISConnection = null;
                return cMISConnection;
            }
            String userConnectionId = this.createUserConnectionId(currentUser, connectionId);
            CMISConnection cMISConnection = this.userConnections.get(userConnectionId);
            return cMISConnection;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CMISConnection> getUserConnections() {
        String currentUser = this.authenticationService.getCurrentUserName();
        if (currentUser == null) {
            throw new IllegalStateException("No current user!");
        }
        this.lock.writeLock().lock();
        try {
            ArrayList<CMISConnection> result = new ArrayList<CMISConnection>();
            for (CMISConnection conn : this.userConnections.values()) {
                int idx = conn.getInternalId().indexOf(36);
                if (idx <= -1 || !currentUser.equals(conn.getInternalId().substring(idx + 1))) continue;
                result.add(conn);
            }
            Collections.sort(result);
            List<CMISConnection> list = Collections.unmodifiableList(result);
            return list;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CMISConnection> getSharedConnections() {
        this.lock.writeLock().lock();
        try {
            ArrayList<CMISConnection> result = new ArrayList<CMISConnection>(this.sharedConnections.values());
            Collections.sort(result);
            List<CMISConnection> list = Collections.unmodifiableList(result);
            return list;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(CMISConnection connection) {
        if (connection == null || connection.getInternalId() == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (connection.isShared()) {
                this.sharedConnections.remove(connection.getInternalId());
            } else {
                this.userConnections.remove(connection.getInternalId());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected Session createSession(Map<String, String> parameters) {
        if (parameters.containsKey("org.apache.chemistry.opencmis.session.repository.id")) {
            return this.sessionFactory.createSession(new HashMap<String, String>(parameters));
        }
        return ((Repository)this.sessionFactory.getRepositories(new HashMap<String, String>(parameters)).get(0)).createSession();
    }

    @Override
    public List<CMISServer> getServerDefinitions() {
        return this.servers == null ? null : Collections.unmodifiableList(new ArrayList<CMISServer>(this.servers.values()));
    }

    @Override
    public CMISServer getServerDefinition(String serverName) {
        return this.servers == null ? null : this.servers.get(serverName);
    }

    @Override
    public CMISServer createServerDefinition(String serverName, Map<String, String> parameters) {
        return new CMISServerImpl(serverName, null, parameters);
    }

    @Override
    public CMISServer createServerDefinition(CMISServer server, String username, String password) {
        if (server == null) {
            throw new IllegalArgumentException("Server must be set!");
        }
        HashMap<String, String> parameters = new HashMap<String, String>(server.getParameters());
        parameters.put("org.apache.chemistry.opencmis.user", username);
        parameters.put("org.apache.chemistry.opencmis.password", password);
        return new CMISServerImpl(server.getName(), server.getDescription(), parameters);
    }

    @Override
    public CMISServer createServerDefinition(CMISServer server, String username, String password, String repositoryId) {
        if (server == null) {
            throw new IllegalArgumentException("Server must be set!");
        }
        HashMap<String, String> parameters = new HashMap<String, String>(server.getParameters());
        parameters.put("org.apache.chemistry.opencmis.user", username);
        parameters.put("org.apache.chemistry.opencmis.password", password);
        parameters.put("org.apache.chemistry.opencmis.session.repository.id", repositoryId);
        return new CMISServerImpl(server.getName(), server.getDescription(), parameters);
    }

    protected CMISServer createServerDefinition(Map<String, String> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters must be set!");
        }
        String name = parameters.get(SERVER_NAME);
        parameters.remove(SERVER_NAME);
        String description = parameters.get(SERVER_DESCRIPTION);
        parameters.remove(SERVER_DESCRIPTION);
        if (name != null) {
            return new CMISServerImpl(name, description, parameters);
        }
        return null;
    }

    @Override
    public List<Repository> getRepositories(CMISServer server) {
        if (server == null) {
            throw new IllegalArgumentException("Server must be set!");
        }
        return this.sessionFactory.getRepositories(new HashMap<String, String>(server.getParameters()));
    }
}

