/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.alfresco.repo.cmis.client.CMISConnection;
import org.alfresco.repo.cmis.client.CMISConnectionManager;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.util.FileCopyUtils;

public class CMISContentStreamWebScript
extends AbstractWebScript {
    public static final String DOC_ID = "id";
    public static final String STREAM_ID = "stream";
    public static final String CONNECTION = "conn";
    private CMISConnectionManager connectionManager;

    public void setConnectionManager(CMISConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        long length;
        ContentStream stream;
        CmisObject object;
        CMISConnection conn = null;
        String docId = req.getParameter(DOC_ID);
        String streamId = req.getParameter(STREAM_ID);
        String connectionId = req.getParameter(CONNECTION);
        conn = connectionId != null ? this.connectionManager.getConnection(connectionId) : this.connectionManager.getConnection();
        if (conn == null) {
            throw new WebScriptException(500, "Invalid connection!");
        }
        Session session = conn.getSession();
        try {
            object = session.getObject(docId);
        }
        catch (CmisBaseException e) {
            if (e instanceof CmisObjectNotFoundException) {
                throw new WebScriptException(404, "Object not found!", (Throwable)e);
            }
            throw new WebScriptException(500, e.getMessage(), (Throwable)e);
        }
        if (!(object instanceof Document)) {
            throw new WebScriptException(404, "Object is not a document!");
        }
        Document document = (Document)object;
        ContentStream contentStream = stream = streamId == null ? document.getContentStream() : document.getContentStream(streamId);
        if (stream.getMimeType() != null) {
            res.setContentType(stream.getMimeType());
        }
        if ((length = stream.getLength()) != -1L) {
            res.setHeader("Content-Length", Long.toString(length));
        }
        FileCopyUtils.copy((InputStream)stream.getStream(), (OutputStream)res.getOutputStream());
    }
}

