/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.client;

import java.util.HashMap;
import org.alfresco.cmis.client.impl.AlfrescoObjectFactoryImpl;
import org.alfresco.opencmis.AlfrescoLocalCmisServiceFactory;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.repo.cmis.client.AbstractCMISConnectionManagerImpl;
import org.alfresco.repo.cmis.client.CMISConnection;
import org.alfresco.repo.cmis.client.CMISConnectionImpl;
import org.alfresco.repo.cmis.client.CMISConnectionManager;
import org.alfresco.repo.cmis.client.CMISServer;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.BindingType;

public class CMISLocalConnectionManagerImpl
extends AbstractCMISConnectionManagerImpl
implements CMISConnectionManager {
    public void setCmisConnector(CMISConnector connector) {
        AlfrescoLocalCmisServiceFactory.setCmisConnector((CMISConnector)connector);
    }

    @Override
    public CMISConnection createDefaultConnection(CMISServer server) {
        throw new IllegalStateException("Local connection cannot be changed!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CMISConnection getConnection() {
        this.lock.writeLock().lock();
        try {
            CMISConnection connection = this.getConnection("default");
            if (connection != null) {
                CMISConnection cMISConnection = connection;
                return cMISConnection;
            }
            String currentUser = this.authenticationService.getCurrentUserName();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.LOCAL.value());
            parameters.put("org.apache.chemistry.opencmis.binding.local.classname", AlfrescoLocalCmisServiceFactory.class.getName());
            parameters.put("org.apache.chemistry.opencmis.objectfactory.classname", AlfrescoObjectFactoryImpl.class.getName());
            parameters.put("org.apache.chemistry.opencmis.user", currentUser);
            CMISServer server = this.createServerDefinition("default", parameters);
            Session session = this.createSession(server.getParameters());
            String userConnectionId = this.createUserConnectionId(currentUser, "default");
            connection = new CMISConnectionImpl(this, userConnectionId, session, server, currentUser, true, false);
            this.userConnections.put(userConnectionId, connection);
            CMISConnection cMISConnection = connection;
            return cMISConnection;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

