/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.client;

import java.util.HashMap;
import org.alfresco.repo.cmis.client.AbstractCMISConnectionManagerImpl;
import org.alfresco.repo.cmis.client.CMISConnection;
import org.alfresco.repo.cmis.client.CMISConnectionImpl;
import org.alfresco.repo.cmis.client.CMISConnectionManager;
import org.alfresco.repo.cmis.client.CMISServer;
import org.apache.chemistry.opencmis.client.api.Session;

public class CMISRemoteConnectionManagerImpl
extends AbstractCMISConnectionManagerImpl
implements CMISConnectionManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CMISConnection createDefaultConnection(CMISServer server) {
        this.lock.writeLock().lock();
        try {
            CMISConnection connection = this.getConnection();
            if (connection != null) {
                throw new IllegalStateException("Connection id is already in use!");
            }
            if (server == null) {
                throw new IllegalStateException("Server definition must be set!");
            }
            String currentUser = this.authenticationService.getCurrentUserName();
            if (!server.getParameters().containsKey("org.apache.chemistry.opencmis.user")) {
                HashMap<String, String> parameters = new HashMap<String, String>(server.getParameters());
                parameters.put("org.apache.chemistry.opencmis.user", currentUser);
                server = this.createServerDefinition(server.getName(), parameters);
            }
            String userConnectionId = this.createUserConnectionId(currentUser, "default");
            Session session = this.createSession(server.getParameters());
            connection = new CMISConnectionImpl(this, userConnectionId, session, server, currentUser, true, false);
            this.userConnections.put(userConnectionId, connection);
            CMISConnection cMISConnection = connection;
            return cMISConnection;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public CMISConnection getConnection() {
        return this.getConnection("default");
    }
}

