/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.reference;

import org.alfresco.cmis.CMISRepositoryReference;
import org.alfresco.cmis.CMISServices;
import org.alfresco.repo.cmis.reference.AbstractObjectReference;
import org.alfresco.service.cmr.repository.NodeRef;

public class AVMPathReference
extends AbstractObjectReference {
    protected String path;
    protected String[] reference;

    public AVMPathReference(CMISServices cmisServices, CMISRepositoryReference repo, String path) {
        super(cmisServices, repo);
        String avmStoreName;
        String[] splitPath = path.split("/");
        this.reference = new String[1 + splitPath.length];
        this.reference[0] = avmStoreName = repo.getStoreRef().getIdentifier();
        this.path = avmStoreName + ":/" + path;
        System.arraycopy(splitPath, 0, this.reference, 1, splitPath.length);
    }

    public NodeRef getNodeRef() {
        return this.cmisServices.getNode("avmpath", this.reference);
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "AVMPathReference[avmpath=" + this.path + "]";
    }
}

