/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.rest;

import freemarker.ext.beans.BeanModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.util.List;
import org.alfresco.cmis.CMISRelationshipDirectionEnum;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.cmis.CMISServices;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.web.scripts.RepositoryImageResolver;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.repository.TemplateValueConverter;
import org.springframework.extensions.webscripts.WebScriptException;

public class CMISAssocsMethod
implements TemplateMethodModelEx {
    private CMISServices cmisService;
    private TemplateImageResolver imageResolver;
    private TemplateValueConverter templateValueConverter;

    public CMISAssocsMethod(CMISServices cmisService, RepositoryImageResolver imageResolver, TemplateValueConverter templateValueConverter) {
        this.cmisService = cmisService;
        this.imageResolver = imageResolver.getImageResolver();
        this.templateValueConverter = templateValueConverter;
    }

    public Object exec(List args) throws TemplateModelException {
        NodeRef nodeRef = null;
        CMISRelationshipDirectionEnum direction = CMISRelationshipDirectionEnum.SOURCE;
        try {
            Object wrapped;
            int i = 0;
            Object arg = args.get(i++);
            if (arg instanceof BeanModel && (wrapped = ((BeanModel)arg).getWrappedObject()) != null && wrapped instanceof TemplateNode) {
                nodeRef = ((TemplateNode)wrapped).getNodeRef();
            }
            if ((arg = args.get(i++)) instanceof TemplateScalarModel) {
                String strDirection = ((TemplateScalarModel)arg).getAsString();
                direction = strDirection.equalsIgnoreCase("both") ? CMISRelationshipDirectionEnum.EITHER : (CMISRelationshipDirectionEnum)CMISRelationshipDirectionEnum.FACTORY.fromLabel(strDirection);
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (nodeRef != null) {
            AssociationRef[] assocs;
            try {
                assocs = this.cmisService.getRelationships(nodeRef, null, true, direction);
            }
            catch (CMISServiceException e) {
                throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
            }
            return this.templateValueConverter.convertValue((Object)assocs, this.imageResolver);
        }
        return null;
    }
}

