/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.rest;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.cmis.CMISAccessControlService;
import org.alfresco.cmis.CMISAclCapabilityEnum;
import org.alfresco.cmis.CMISAclPropagationEnum;
import org.alfresco.cmis.CMISAclSupportedPermissionEnum;
import org.alfresco.cmis.CMISBaseObjectTypeIds;
import org.alfresco.cmis.CMISCapabilityChanges;
import org.alfresco.cmis.CMISChangeEvent;
import org.alfresco.cmis.CMISChangeLog;
import org.alfresco.cmis.CMISChangeLogService;
import org.alfresco.cmis.CMISConstraintException;
import org.alfresco.cmis.CMISDictionaryService;
import org.alfresco.cmis.CMISInvalidArgumentException;
import org.alfresco.cmis.CMISJoinEnum;
import org.alfresco.cmis.CMISObjectReference;
import org.alfresco.cmis.CMISPermissionDefinition;
import org.alfresco.cmis.CMISPermissionMapping;
import org.alfresco.cmis.CMISPropertyDefinition;
import org.alfresco.cmis.CMISQueryEnum;
import org.alfresco.cmis.CMISQueryOptions;
import org.alfresco.cmis.CMISQueryService;
import org.alfresco.cmis.CMISRelationshipDirectionEnum;
import org.alfresco.cmis.CMISRelationshipReference;
import org.alfresco.cmis.CMISRepositoryReference;
import org.alfresco.cmis.CMISResultSet;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.cmis.CMISServices;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.CMISTypesFilterEnum;
import org.alfresco.cmis.CMISVersioningStateEnum;
import org.alfresco.cmis.acl.CMISAccessControlEntryImpl;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.cmis.reference.ObjectIdReference;
import org.alfresco.repo.cmis.reference.ReferenceFactory;
import org.alfresco.repo.jscript.Association;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.web.util.paging.Cursor;
import org.alfresco.repo.web.util.paging.Page;
import org.alfresco.repo.web.util.paging.PagedResults;
import org.alfresco.repo.web.util.paging.Paging;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;

public class CMISScript
extends BaseScopableProcessorExtension {
    public static final String ARG_CHILD_TYPES = "childTypes";
    public static final String ARG_CONTINUE_ON_FAILURE = "continueOnFailure";
    public static final String ARG_CHECKIN = "checkin";
    public static final String ARG_CHECKIN_COMMENT = "checkinComment";
    public static final String ARG_DEPTH = "depth";
    public static final String ARG_DIRECTION = "relationshipDirection";
    public static final String ARG_FILTER = "filter";
    public static final String ARG_FOLDER_BY_PATH = "folderByPath";
    public static final String ARG_FOLDER_ID = "folderId";
    public static final String ARG_INCLUDE_ALLOWABLE_ACTIONS = "includeAllowableActions";
    public static final String ARG_INCLUDE_PROPERTY_DEFINITIONS = "includePropertyDefinitions";
    public static final String ARG_INCLUDE_RELATIONSHIPS = "includeRelationships";
    public static final String ARG_INCLUDE_SUB_RELATIONSHIP_TYPES = "includeSubRelationshipTypes";
    public static final String ARG_LENGTH = "length";
    public static final String ARG_MAJOR = "major";
    public static final String ARG_MAJOR_VERSION = "majorVersion";
    public static final String ARG_MAX_ITEMS = "maxItems";
    public static final String ARG_OFFSET = "offset";
    public static final String ARG_QUERY_STATEMENT = "q";
    public static final String ARG_REMOVE_FROM = "removeFrom";
    public static final String ARG_RELATIONSHIP_TYPE = "typeId";
    public static final String ARG_REPOSITORY_ID = "repositoryId";
    public static final String ARG_RETURN_VERSION = "returnVersion";
    public static final String ARG_SKIP_COUNT = "skipCount";
    public static final String ARG_THIS_VERSION = "thisVersion";
    public static final String ARG_TYPE_ID = "typeId";
    public static final String ARG_TYPES = "types";
    public static final String ARG_UNFILE_OBJECTS = "unfileObjects";
    public static final String ARG_VERSIONING_STATE = "versioningState";
    public static final String ARG_SOURCE_FOLDER_ID = "sourceFolderId";
    public static final String ARG_INCLUDE_ACL = "includeACL";
    public static final String ARG_RENDITION_FILTER = "renditionFilter";
    public static final String ARG_CHANGE_LOG_TOKEN = "changeLogToken";
    public static final String ARG_ORDER_BY = "orderBy";
    private ServiceRegistry services;
    private CMISServices cmisService;
    private CMISDictionaryService cmisDictionaryService;
    private CMISQueryService cmisQueryService;
    private CMISAccessControlService cmisAccessControlService;
    private CMISChangeLogService cmisChangeLogService;
    private Paging paging;
    private ReferenceFactory referenceFactory;
    private ValueConverter valueConverter = new ValueConverter();

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
    }

    public void setPaging(Paging paging) {
        this.paging = paging;
    }

    public void setCMISService(CMISServices cmisService) {
        this.cmisService = cmisService;
    }

    public void setCMISDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    public void setCMISQueryService(CMISQueryService cmisQueryService) {
        this.cmisQueryService = cmisQueryService;
    }

    public void setCMISAccessControlService(CMISAccessControlService cmisAccessControlService) {
        this.cmisAccessControlService = cmisAccessControlService;
    }

    public void setCMISChangeLogService(CMISChangeLogService cmisChangeLogService) {
        this.cmisChangeLogService = cmisChangeLogService;
    }

    public void setCMISReferenceFactory(ReferenceFactory referenceFactory) {
        this.referenceFactory = referenceFactory;
    }

    public String getVersion() {
        return this.cmisService.getCMISVersion();
    }

    public String getSpecTitle() {
        return this.cmisService.getCMISSpecTitle();
    }

    public String getDefaultRootFolderPath() {
        return this.cmisService.getDefaultRootPath();
    }

    public ScriptNode getDefaultRootFolder() {
        return new ScriptNode(this.cmisService.getDefaultRootNodeRef(), this.services, this.getScope());
    }

    public String getDefaultTypesFilter() {
        return CMISTypesFilterEnum.FACTORY.getDefaultLabel();
    }

    public boolean isValidTypesFilter(String typesFilter) {
        return CMISTypesFilterEnum.FACTORY.validLabel(typesFilter);
    }

    private CMISTypesFilterEnum resolveTypesFilter(String typesFilter) {
        return (CMISTypesFilterEnum)CMISTypesFilterEnum.FACTORY.toEnum(typesFilter);
    }

    public CMISRepositoryReference createRepoReferenceFromUrl(Map<String, String> args, Map<String, String> templateArgs) {
        return this.referenceFactory.createRepoReferenceFromUrl(args, templateArgs);
    }

    public CMISObjectReference createObjectReferenceFromUrl(Map<String, String> args, Map<String, String> templateArgs) {
        return this.referenceFactory.createObjectReferenceFromUrl(args, templateArgs);
    }

    public CMISRelationshipReference createRelationshipReferenceFromUrl(Map<String, String> args, Map<String, String> templateArgs) {
        return this.referenceFactory.createRelationshipReferenceFromUrl(args, templateArgs);
    }

    public CMISObjectReference createObjectIdReference(String objectId) {
        return new ObjectIdReference(this.cmisService, objectId);
    }

    public ScriptNode getNode(CMISObjectReference ref) {
        NodeRef nodeRef = ref.getNodeRef();
        if (nodeRef == null) {
            return null;
        }
        return new ScriptNode(nodeRef, this.services, this.getScope());
    }

    public Association getAssociation(CMISRelationshipReference ref) {
        AssociationRef assocRef = ref.getAssocRef();
        if (assocRef == null) {
            return null;
        }
        return new Association(this.services, assocRef);
    }

    public PagedResults queryChildren(ScriptNode parent, String typesFilter, String orderBy, Page page) {
        try {
            CMISTypesFilterEnum filter = this.resolveTypesFilter(typesFilter);
            int maxItems = page.getSize();
            int skipCount = (page.getNumber() - (page.isZeroBasedIdx() ? 0 : 1)) * maxItems;
            PagingResults pageOfNodeInfos = this.cmisService.getChildren(parent.getNodeRef(), filter, BigInteger.valueOf(maxItems), BigInteger.valueOf(skipCount), orderBy);
            int pageCnt = pageOfNodeInfos.getPage().size();
            NodeRef[] children = new NodeRef[pageCnt];
            int idx = 0;
            for (FileInfo child : pageOfNodeInfos.getPage()) {
                children[idx] = child.getNodeRef();
                ++idx;
            }
            int totalCount = pageCnt;
            Pair totalCounts = pageOfNodeInfos.getTotalResultCount();
            if (totalCounts != null) {
                Integer totalCountLower = (Integer)totalCounts.getFirst();
                Integer totalCountUpper = (Integer)totalCounts.getSecond();
                if (totalCountLower != null && totalCountLower.equals(totalCountUpper)) {
                    totalCount = totalCountLower;
                }
            }
            Cursor cursor = this.paging.createCursor(totalCount, page);
            Object[] nodes = new ScriptNode[pageCnt];
            for (int i = 0; i < pageCnt; ++i) {
                nodes[i] = new ScriptNode(children[i], this.services, this.getScope());
            }
            PagedResults results = this.paging.createPagedResults(nodes, cursor);
            return results;
        }
        catch (CMISInvalidArgumentException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public PagedResults queryRelationships(ScriptNode node, CMISTypeDefinition relDef, boolean includeSubTypes, CMISRelationshipDirectionEnum direction, Page page) {
        AssociationRef[] relationships;
        try {
            relationships = this.cmisService.getRelationships(node.getNodeRef(), relDef, includeSubTypes, direction);
        }
        catch (CMISInvalidArgumentException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
        Cursor cursor = this.paging.createCursor(relationships.length, page);
        Object[] assocs = new Association[cursor.getRowCount()];
        for (int i = cursor.getStartRow(); i <= cursor.getEndRow(); ++i) {
            assocs[i - cursor.getStartRow()] = new Association(this.services, relationships[i], this.getScope());
        }
        PagedResults results = this.paging.createPagedResults(assocs, cursor);
        return results;
    }

    public PagedResults queryCheckedOut(String username, ScriptNode folder, boolean includeDescendants, Page page) {
        NodeRef[] checkedout;
        try {
            checkedout = this.cmisService.getCheckedOut(username, folder == null ? null : folder.getNodeRef(), includeDescendants, null);
        }
        catch (CMISInvalidArgumentException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
        Cursor cursor = this.paging.createCursor(checkedout.length, page);
        Object[] nodes = new ScriptNode[cursor.getRowCount()];
        for (int i = cursor.getStartRow(); i <= cursor.getEndRow(); ++i) {
            nodes[i - cursor.getStartRow()] = new ScriptNode(checkedout[i], this.services, this.getScope());
        }
        PagedResults results = this.paging.createPagedResults(nodes, cursor);
        return results;
    }

    public PagedResults queryTypeChildren(CMISTypeDefinition typeDef, Page page) {
        Collection children = typeDef == null ? this.cmisService.getBaseTypes() : typeDef.getSubTypes(false);
        Cursor cursor = this.paging.createCursor(children.size(), page);
        Iterator iterTypeDefs = children.iterator();
        for (int i = 0; i < cursor.getStartRow(); ++i) {
            iterTypeDefs.next();
        }
        Object[] types = new CMISTypeDefinition[cursor.getRowCount()];
        for (int i = cursor.getStartRow(); i <= cursor.getEndRow(); ++i) {
            types[i - cursor.getStartRow()] = (CMISTypeDefinition)iterTypeDefs.next();
        }
        PagedResults results = this.paging.createPagedResults(types, cursor);
        return results;
    }

    public CMISTypeDefinition queryType(String typeId) {
        try {
            return this.cmisService.getTypeDefinition(typeId);
        }
        catch (CMISInvalidArgumentException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public CMISTypeDefinition queryType(ScriptNode node) {
        try {
            return this.cmisService.getTypeDefinition(node.getNodeRef());
        }
        catch (CMISInvalidArgumentException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public CMISPropertyDefinition queryProperty(String propertyName) {
        return this.cmisDictionaryService.findProperty(propertyName, null);
    }

    public void setAspects(ScriptNode node, Iterable<String> aspectsToRemove, Iterable<String> aspectsToAdd) {
        try {
            this.cmisService.setAspects(node.getNodeRef(), aspectsToRemove, aspectsToAdd);
        }
        catch (CMISInvalidArgumentException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public boolean getPwcSearchable() {
        return this.cmisQueryService.getPwcSearchable();
    }

    public boolean getAllVersionsSearchable() {
        return this.cmisQueryService.getAllVersionsSearchable();
    }

    public CMISQueryEnum getQuerySupport() {
        return this.cmisQueryService.getQuerySupport();
    }

    public CMISJoinEnum getJoinSupport() {
        return this.cmisQueryService.getJoinSupport();
    }

    public PagedResults query(String statement, Page page) {
        Cursor unknownRows = this.paging.createCursor(Integer.MAX_VALUE, page);
        CMISQueryOptions options = new CMISQueryOptions(statement, this.cmisService.getDefaultRootStoreRef());
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        options.setSkipCount(unknownRows.getStartRow());
        CMISResultSet resultSet = this.cmisQueryService.query(options);
        Cursor cursor = this.paging.createCursor(unknownRows.getStartRow() + resultSet.getLength(), page);
        return this.paging.createPagedResult(resultSet, cursor);
    }

    public CMISAclCapabilityEnum getAclCapability() {
        return this.cmisAccessControlService.getAclCapability();
    }

    public CMISAclSupportedPermissionEnum getAclSupportedPermissions() {
        return this.cmisAccessControlService.getSupportedPermissions();
    }

    public CMISAclPropagationEnum getAclPropagation() {
        return this.cmisAccessControlService.getAclPropagation();
    }

    public List<CMISPermissionDefinition> getRepositoryPermissions() {
        return this.cmisAccessControlService.getRepositoryPermissions();
    }

    public List<? extends CMISPermissionMapping> getPermissionMappings() {
        return this.cmisAccessControlService.getPermissionMappings();
    }

    public String getPrincipalAnonymous() {
        return this.cmisAccessControlService.getPrincipalAnonymous();
    }

    public String getPrincipalAnyone() {
        return this.cmisAccessControlService.getPrincipalAnyone();
    }

    public void applyACL(ScriptNode node, Serializable principalIds, Serializable permissions) {
        List principalList = (List)((Object)this.valueConverter.convertValueForRepo(principalIds));
        List permissionList = (List)((Object)this.valueConverter.convertValueForRepo(permissions));
        ArrayList<CMISAccessControlEntryImpl> acesToApply = new ArrayList<CMISAccessControlEntryImpl>(principalList.size());
        for (int i = 0; i < principalList.size(); ++i) {
            acesToApply.add(new CMISAccessControlEntryImpl((String)principalList.get(i), (String)permissionList.get(i)));
        }
        try {
            this.cmisAccessControlService.applyAcl(node.getNodeRef(), acesToApply);
        }
        catch (CMISConstraintException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public CMISCapabilityChanges getChangeLogCapability() {
        return this.cmisChangeLogService.getCapability();
    }

    public String getLastChangeLogToken() {
        return this.cmisChangeLogService.getLastChangeLogToken();
    }

    public String[] getChangesOnType() {
        List typeList = this.cmisChangeLogService.getChangesOnTypeCapability();
        String[] changesOnType = new String[typeList.size()];
        int i = 0;
        for (CMISBaseObjectTypeIds type : typeList) {
            changesOnType[i++] = type.getLabel();
        }
        return changesOnType;
    }

    public boolean getChangesIncomplete() {
        return this.cmisChangeLogService.getChangesIncomplete();
    }

    public Scriptable getChangeLog(String changeLogToken, Integer maxItems) {
        Scriptable scope = this.getScope();
        Context cx = Context.enter();
        try {
            String lastPageChangeLogToken;
            String previousPageChangeLogToken;
            Scriptable changeLogMap = cx.newObject(scope);
            CMISChangeLog changeLog = this.cmisChangeLogService.getChangeLogEvents(changeLogToken, maxItems);
            List changeEvents = changeLog.getChangeEvents();
            int size = changeEvents.size();
            Scriptable changeEventArr = cx.newArray(scope, size);
            for (int i = 0; i < size; ++i) {
                ScriptableObject.putProperty((Scriptable)changeEventArr, (int)i, (Object)Context.javaToJS(changeEvents.get(i), (Scriptable)scope));
            }
            ScriptableObject.putProperty((Scriptable)changeLogMap, (String)"changeEvents", (Object)changeEventArr);
            Scriptable changeNodes = cx.newArray(scope, size);
            for (int i = 0; i < size; ++i) {
                ScriptableObject.putProperty((Scriptable)changeNodes, (int)i, (Object)new ScriptNode(((CMISChangeEvent)changeEvents.get(i)).getChangedNode(), this.services, scope));
            }
            ScriptableObject.putProperty((Scriptable)changeLogMap, (String)"changeNodes", (Object)changeNodes);
            ScriptableObject.putProperty((Scriptable)changeLogMap, (String)"hasMoreItems", (Object)Context.javaToJS((Object)changeLog.hasMoreItems(), (Scriptable)scope));
            ScriptableObject.putProperty((Scriptable)changeLogMap, (String)"eventCount", (Object)Context.javaToJS((Object)changeLog.getEventCount(), (Scriptable)scope));
            String nextChangeToken = changeLog.getNextChangeToken();
            if (nextChangeToken != null) {
                ScriptableObject.putProperty((Scriptable)changeLogMap, (String)"nextChangeToken", (Object)Context.javaToJS((Object)nextChangeToken, (Scriptable)scope));
            }
            if ((previousPageChangeLogToken = this.cmisChangeLogService.getPreviousPageChangeLogToken(changeLogToken, maxItems)) != null) {
                ScriptableObject.putProperty((Scriptable)changeLogMap, (String)"previousPageToken", (Object)Context.javaToJS((Object)previousPageChangeLogToken, (Scriptable)scope));
            }
            if ((lastPageChangeLogToken = this.cmisChangeLogService.getLastPageChangeLogToken(changeLogToken, maxItems)) != null) {
                ScriptableObject.putProperty((Scriptable)changeLogMap, (String)"lastPageToken", (Object)Context.javaToJS((Object)lastPageChangeLogToken, (Scriptable)scope));
            }
            Scriptable scriptable = changeLogMap;
            return scriptable;
        }
        catch (CMISInvalidArgumentException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
        finally {
            Context.exit();
        }
    }

    public ScriptNode applyVersioningState(ScriptNode source, String versioningState) {
        CMISVersioningStateEnum versioningStateEnum = (CMISVersioningStateEnum)CMISVersioningStateEnum.FACTORY.fromLabel(versioningState);
        try {
            return new ScriptNode(this.cmisService.applyVersioningState(source.getNodeRef(), versioningStateEnum), this.services, this.getScope());
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public ScriptNode checkOut(String objectId) {
        try {
            return new ScriptNode(this.cmisService.checkOut(objectId), this.services, this.getScope());
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public ScriptNode checkIn(ScriptNode source, String checkinComment, boolean isMajor) {
        try {
            return new ScriptNode(this.cmisService.checkIn((String)((Object)this.cmisService.getProperty(source.getNodeRef(), "cmis:objectId")), checkinComment, isMajor), this.services, this.getScope());
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void cancelCheckOut(ScriptNode source) {
        try {
            this.cmisService.cancelCheckOut((String)((Object)this.cmisService.getProperty(source.getNodeRef(), "cmis:objectId")));
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public Scriptable getAllVersions(ScriptNode source) {
        Scriptable scope = this.getScope();
        Context cx = Context.enter();
        try {
            List allVersions = this.cmisService.getAllVersions((String)((Object)this.cmisService.getProperty(source.getNodeRef(), "cmis:objectId")));
            int size = allVersions.size();
            Scriptable allVersionsArr = cx.newArray(scope, size);
            for (int i = 0; i < size; ++i) {
                ScriptableObject.putProperty((Scriptable)allVersionsArr, (int)i, (Object)new ScriptNode((NodeRef)allVersions.get(i), this.services, scope));
            }
            Scriptable scriptable = allVersionsArr;
            return scriptable;
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
        finally {
            Context.exit();
        }
    }

    public ScriptNode getReturnVersion(ScriptNode source, String returnVersion) {
        if (returnVersion == null || returnVersion.equals("this")) {
            return source;
        }
        try {
            return new ScriptNode(this.cmisService.getLatestVersion((String)((Object)this.cmisService.getProperty(source.getNodeRef(), "cmis:objectId")), returnVersion.equals("latestmajor")), this.services, this.getScope());
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void deleteTree(ScriptNode source, Status status, boolean continueOnFailure, boolean unfile, boolean deleteAllVersions) {
        try {
            this.cmisService.deleteTreeReportLastError((String)((Object)this.cmisService.getProperty(source.getNodeRef(), "cmis:objectId")), continueOnFailure, unfile, deleteAllVersions);
            status.setCode(204);
            status.setRedirect(true);
        }
        catch (CMISServiceException e) {
            status.setCode(e.getStatusCode());
            status.setMessage(e.getMessage());
            status.setRedirect(true);
        }
    }

    public void deleteContentStream(ScriptNode source) {
        try {
            this.cmisService.deleteContentStream((String)((Object)this.cmisService.getProperty(source.getNodeRef(), "cmis:objectId")));
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void deleteObject(ScriptNode source, boolean allVersions) {
        try {
            this.cmisService.deleteObject((String)((Object)this.cmisService.getProperty(source.getNodeRef(), "cmis:objectId")), allVersions);
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void deleteObject(Association assoc) {
        try {
            this.cmisService.deleteObject((String)((Object)this.cmisService.getProperty(assoc.getAssociationRef(), "cmis:objectId")), true);
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void addObjectToFolder(ScriptNode child, ScriptNode parent) {
        try {
            this.cmisService.addObjectToFolder((String)((Object)this.cmisService.getProperty(child.getNodeRef(), "cmis:objectId")), (String)((Object)this.cmisService.getProperty(parent.getNodeRef(), "cmis:objectId")));
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void moveObject(ScriptNode child, ScriptNode targetFolder, String sourceFolderId) {
        try {
            this.cmisService.moveObject((String)((Object)this.cmisService.getProperty(child.getNodeRef(), "cmis:objectId")), (String)((Object)this.cmisService.getProperty(targetFolder.getNodeRef(), "cmis:objectId")), sourceFolderId);
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public ScriptNode createPolicy(String typeId, ScriptNode parent) {
        try {
            this.cmisService.createPolicy(Collections.singletonMap("cmis:objectTypeId", typeId), (String)((Object)this.cmisService.getProperty(parent.getNodeRef(), "cmis:objectId")), Collections.emptyList());
            return null;
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void applyPolicy(String policyId, ScriptNode target) {
        try {
            this.cmisService.applyPolicy(policyId, (String)((Object)this.cmisService.getProperty(target.getNodeRef(), "cmis:objectId")));
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public PagedResults getAppliedPolicies(ScriptNode source, String filter, Page page) {
        List policies;
        try {
            policies = this.cmisService.getAppliedPolicies((String)((Object)this.cmisService.getProperty(source.getNodeRef(), "cmis:objectId")), filter);
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
        Cursor cursor = this.paging.createCursor(policies.size(), page);
        Object[] policyArr = new Object[cursor.getRowCount()];
        for (int i = cursor.getStartRow(); i <= cursor.getEndRow(); ++i) {
            policyArr[i - cursor.getStartRow()] = Context.javaToJS(policies.get(i), (Scriptable)this.getScope());
        }
        PagedResults results = this.paging.createPagedResults(policyArr, cursor);
        return results;
    }

    public void removePolicy(String policyId, String objectId) {
        try {
            this.cmisService.removePolicy(policyId, objectId);
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }
}

