/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.rest;

import freemarker.core.Environment;
import freemarker.template.SimpleCollection;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModelException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.alfresco.cmis.CMISPropertyDefinition;
import org.alfresco.cmis.CMISResultSet;
import org.alfresco.cmis.CMISResultSetColumn;
import org.alfresco.cmis.CMISResultSetMetaData;
import org.alfresco.cmis.CMISResultSetRow;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.web.util.paging.Cursor;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateImageResolver;

public class CMISTemplateResultSet
implements Serializable {
    private static final long serialVersionUID = 2245418238171563934L;
    private CMISResultSet resultSet;
    private Cursor cursor;
    private ServiceRegistry serviceRegistry;
    private TemplateImageResolver imageResolver;

    public CMISTemplateResultSet(CMISResultSet resultSet, Cursor cursor, ServiceRegistry serviceRegistry, TemplateImageResolver imageResolver) {
        this.resultSet = resultSet;
        this.cursor = cursor;
        this.serviceRegistry = serviceRegistry;
        this.imageResolver = imageResolver;
    }

    public CMISResultSetMetaData getMetaData() {
        return this.resultSet.getMetaData();
    }

    public int getLength() {
        return this.resultSet.getLength();
    }

    public int getStart() {
        return this.resultSet.getStart();
    }

    public String[] getSelectors() {
        return this.resultSet.getMetaData().getSelectorNames();
    }

    public TemplateCollectionModel getRows() throws TemplateModelException {
        return new SimpleCollection((Iterator)new TemplateIterator(this.resultSet.iterator()), Environment.getCurrentEnvironment().getObjectWrapper());
    }

    public class TemplateIterator
    implements Iterator<TemplateRow> {
        private Iterator<CMISResultSetRow> iter;
        private int idx = 0;

        public TemplateIterator(Iterator<CMISResultSetRow> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return (CMISTemplateResultSet.this.cursor == null || this.idx < CMISTemplateResultSet.this.cursor.getRowCount()) && this.iter.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TemplateRow next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                TemplateRow templateRow = new TemplateRow(this.iter.next());
                return templateRow;
            }
            finally {
                ++this.idx;
            }
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        public class TemplateRow {
            private CMISResultSetRow row;
            private Map<String, TemplateNode> nodes = null;

            public TemplateRow(CMISResultSetRow row) {
                this.row = row;
            }

            public Map<String, Serializable> getValues() {
                return this.row.getValues();
            }

            public Collection<TemplateNode> getNodes() {
                Map<String, TemplateNode> nodes = this.buildNodes();
                return nodes.size() == 0 ? null : nodes.values();
            }

            public TemplateNode getNode() {
                try {
                    NodeRef nodeRef = this.row.getNodeRef();
                    return new TemplateNode(nodeRef, CMISTemplateResultSet.this.serviceRegistry, CMISTemplateResultSet.this.imageResolver);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    return null;
                }
            }

            private Map<String, TemplateNode> buildNodes() {
                if (this.nodes == null) {
                    Map nodeRefs = this.row.getNodeRefs();
                    if (nodeRefs == null || nodeRefs.size() == 0) {
                        this.nodes = Collections.emptyMap();
                    } else {
                        HashMap<String, TemplateNode> templateNodes = new HashMap<String, TemplateNode>();
                        for (Map.Entry entry : nodeRefs.entrySet()) {
                            templateNodes.put((String)entry.getKey(), new TemplateNode((NodeRef)entry.getValue(), CMISTemplateResultSet.this.serviceRegistry, CMISTemplateResultSet.this.imageResolver));
                        }
                        this.nodes = templateNodes;
                    }
                }
                return this.nodes;
            }

            public String getColumnType(String colName) {
                CMISResultSetColumn col = CMISTemplateResultSet.this.resultSet.getMetaData().getColumn(colName);
                return col == null ? null : col.getCMISDataType().getLabel();
            }

            public CMISPropertyDefinition getPropertyDefinition(String colName) {
                CMISResultSetColumn col = CMISTemplateResultSet.this.resultSet.getMetaData().getColumn(colName);
                return col == null ? null : col.getCMISPropertyDefinition();
            }

            public TemplateNode getSelectorNode(String selector) {
                return this.nodes.get(selector);
            }

            public float getScore() {
                return this.row.getScore();
            }

            public Float getSelectorScore(String selector) {
                return Float.valueOf(this.row.getScore(selector));
            }

            public int getIndex() {
                return this.row.getIndex();
            }
        }
    }
}

