/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.rest.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.ExtensionFactory;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.protocol.Response;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISExtensionFactory;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.abdera.ext.CMISProperties;
import org.apache.chemistry.abdera.ext.CMISProperty;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;

public class BulkCreateSystemTest {
    private static Abdera abdera;

    public static void main(String[] args) throws Exception {
        abdera = new Abdera();
        abdera.getFactory().registerExtension((ExtensionFactory)new CMISExtensionFactory());
        AbderaClient client = new AbderaClient(abdera);
        client.usePreemptiveAuthentication(true);
        client.addCredentials("http://localhost:8080", null, "basic", (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        String root = BulkCreateSystemTest.createFolder(client, "http://localhost:8080/alfresco/service/api/path/workspace/SpacesStore/Company%20Home/children", "testfolder14");
        for (int i = 0; i < 100; ++i) {
            String folder = BulkCreateSystemTest.createFolder(client, root, "folder_" + i);
            BulkCreateSystemTest.createDocument(client, folder, "doc");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createFolder(AbderaClient client, String parent, String name) throws Exception {
        Entry entry = abdera.newEntry();
        entry.setTitle(name);
        entry.setSummary("Summarize summarize...");
        CMISObject cmisObject = (CMISObject)entry.addExtension(CMISConstants.OBJECT);
        CMISProperties properties = (CMISProperties)cmisObject.addExtension(CMISConstants.PROPERTIES);
        CMISProperty property = (CMISProperty)properties.addExtension(CMISConstants.ID_PROPERTY);
        property.setAttributeValue(CMISConstants.PROPERTY_ID, "cmis:objectTypeId");
        Element value = property.addExtension(CMISConstants.PROPERTY_VALUE);
        value.setText("cmis:Folder");
        ClientResponse resp = client.post(parent, (Base)entry);
        try {
            if (resp.getType() != Response.ResponseType.SUCCESS) {
                BulkCreateSystemTest.printError(resp);
                throw new RuntimeException(resp.getStatusText());
            }
            System.out.println("Created folder " + name);
            Document entryDoc = resp.getDocument();
            Entry root = (Entry)entryDoc.getRoot();
            String string = root.getLink("children").getHref().toString();
            return string;
        }
        finally {
            resp.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createDocument(AbderaClient client, String parent, String name) {
        Entry entry = abdera.newEntry();
        entry.setTitle(name);
        entry.setSummary("Summarize summarize...");
        CMISObject cmisObject = (CMISObject)entry.addExtension(CMISConstants.OBJECT);
        CMISProperties properties = (CMISProperties)cmisObject.addExtension(CMISConstants.PROPERTIES);
        CMISProperty property = (CMISProperty)properties.addExtension(CMISConstants.ID_PROPERTY);
        property.setAttributeValue(CMISConstants.PROPERTY_ID, "cmis:objectTypeId");
        Element value = property.addExtension(CMISConstants.PROPERTY_VALUE);
        value.setText("document");
        ClientResponse resp = client.post(parent, (Base)entry);
        try {
            if (resp.getType() != Response.ResponseType.SUCCESS) {
                BulkCreateSystemTest.printError(resp);
                throw new RuntimeException(resp.getStatusText());
            }
        }
        finally {
            resp.release();
        }
    }

    private static void printError(ClientResponse resp) {
        try {
            InputStream inputStream = resp.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = reader.readLine();
            while (line != null) {
                System.out.println(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

