/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.rest.test;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.chemistry.tck.atompub.TCKMessageWriter;
import org.apache.chemistry.tck.atompub.tools.TCKRunner;
import org.apache.chemistry.tck.atompub.tools.TCKRunnerOptions;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class CMISTestRunnerWebScript
extends AbstractWebScript {
    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String[] names;
        Properties properties = new Properties();
        properties.put("chemistry.tck.validate", "false");
        properties.put("chemistry.tck.failOnValidationError", "false");
        properties.put("chemistry.tck.traceRequests", "false");
        TCKRunnerOptions options = new TCKRunnerOptions(properties);
        for (String name : names = req.getParameterNames()) {
            properties.setProperty(name, req.getParameter(name));
        }
        TCKRunner runner = new TCKRunner(options, (TCKMessageWriter)new ResponseMessageWriter(res));
        runner.execute(properties);
    }

    private static class ResponseMessageWriter
    implements TCKMessageWriter {
        private PrintStream printStream;

        public ResponseMessageWriter(WebScriptResponse res) throws IOException {
            this.printStream = new PrintStream(res.getOutputStream(), true, "UTF-8");
        }

        public void info(String message) {
            this.printStream.println("INFO  " + message);
        }

        public void trace(String message) {
            this.printStream.println("TRACE " + message);
        }

        public void warn(String message) {
            this.printStream.println("WARN  " + message);
        }
    }
}

