/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.rest.test;

import java.util.HashMap;
import java.util.Iterator;
import org.alfresco.cmis.client.impl.AlfrescoObjectFactoryImpl;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.safehaus.uuid.UUIDGenerator;

public class CmisRelationshipSystemTest {
    static Session session;
    static Document doc1;

    @BeforeClass
    public static void classSetup() throws Exception {
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        HashMap<String, String> sessionParameters = new HashMap<String, String>();
        sessionParameters.put("org.apache.chemistry.opencmis.binding.atompub.url", "http://localhost:8080/alfresco/s/cmis");
        sessionParameters.put("org.apache.chemistry.opencmis.user", "admin");
        sessionParameters.put("org.apache.chemistry.opencmis.password", "admin");
        sessionParameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        sessionParameters.put("org.apache.chemistry.opencmis.objectfactory.classname", AlfrescoObjectFactoryImpl.class.getName());
        session = ((Repository)factory.getRepositories(sessionParameters).get(0)).createSession();
        HashMap<String, String> prop1 = new HashMap<String, String>();
        prop1.put("cmis:name", CmisRelationshipSystemTest.GUID());
        prop1.put("cmis:objectTypeId", "D:ws:article");
        HashMap<String, String> prop2 = new HashMap<String, String>();
        prop2.put("cmis:name", CmisRelationshipSystemTest.GUID());
        prop2.put("cmis:objectTypeId", "D:ws:article");
        Folder folder = (Folder)session.getObjectByPath("/");
        doc1 = folder.createDocument(prop1, null, null, null, null, null, session.getDefaultContext());
        Document doc2 = folder.createDocument(prop2, null, null, null, null, null, session.getDefaultContext());
        HashMap<String, String> relProps = new HashMap<String, String>();
        relProps.put("cmis:sourceId", doc1.getId());
        relProps.put("cmis:targetId", doc2.getId());
        relProps.put("cmis:objectTypeId", "R:ws:relatedArticles");
        session.createRelationship(relProps, null, null, null);
    }

    private static String GUID() {
        return UUIDGenerator.getInstance().generateRandomBasedUUID().toString();
    }

    @Test
    public void testObjectRelationships() throws Exception {
        Assert.assertEquals((long)0L, (long)doc1.getRelationships().size());
    }

    private void testGetRelationshipsViaSession(RelationshipDirection direction) throws Exception {
        ObjectType typeDefinition = session.getTypeDefinition("R:ws:relatedArticles");
        OperationContext operationContext = session.createOperationContext();
        ItemIterable relationships = session.getRelationships((ObjectId)doc1, true, direction, typeDefinition, operationContext);
        int relationshipCount = 0;
        Iterator iterator = relationships.iterator();
        while (iterator.hasNext()) {
            ++relationshipCount;
            iterator.next();
        }
        Assert.assertEquals((long)1L, (long)relationshipCount);
    }

    @Test
    public void testRelationshipDirectionEither() throws Exception {
        this.testGetRelationshipsViaSession(RelationshipDirection.EITHER);
    }

    @Test
    public void testRelationshipDirectionSource() throws Exception {
        this.testGetRelationshipsViaSession(RelationshipDirection.SOURCE);
    }
}

