/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;
import org.alfresco.cmis.CMISChangeEvent;
import org.alfresco.cmis.CMISChangeLog;
import org.alfresco.cmis.CMISChangeType;
import org.alfresco.cmis.CMISDataTypeEnum;
import org.alfresco.cmis.CMISObjectNotFoundException;
import org.alfresco.cmis.CMISQueryOptions;
import org.alfresco.cmis.CMISRelationshipDirectionEnum;
import org.alfresco.cmis.CMISResultSet;
import org.alfresco.cmis.CMISResultSetColumn;
import org.alfresco.cmis.CMISResultSetRow;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.repo.cmis.ws.CmisChangeEventType;
import org.alfresco.repo.cmis.ws.CmisException;
import org.alfresco.repo.cmis.ws.CmisExtensionType;
import org.alfresco.repo.cmis.ws.CmisObjectListType;
import org.alfresco.repo.cmis.ws.CmisObjectType;
import org.alfresco.repo.cmis.ws.CmisPropertiesType;
import org.alfresco.repo.cmis.ws.CmisProperty;
import org.alfresco.repo.cmis.ws.CmisRenditionType;
import org.alfresco.repo.cmis.ws.DMAbstractServicePort;
import org.alfresco.repo.cmis.ws.DiscoveryServicePort;
import org.alfresco.repo.cmis.ws.EnumIncludeRelationships;
import org.alfresco.repo.cmis.ws.EnumTypeOfChanges;
import org.alfresco.repo.cmis.ws.Query;
import org.alfresco.repo.cmis.ws.QueryResponse;
import org.alfresco.repo.cmis.ws.utils.ExceptionUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.NodeRef;

@WebService(name="DiscoveryServicePort", serviceName="DiscoveryService", portName="DiscoveryServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", endpointInterface="org.alfresco.repo.cmis.ws.DiscoveryServicePort")
public class DMDiscoveryServicePort
extends DMAbstractServicePort
implements DiscoveryServicePort {
    private static Map<CMISChangeType, EnumTypeOfChanges> changesTypeMapping = new HashMap<CMISChangeType, EnumTypeOfChanges>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResponse query(Query parameters) throws CmisException {
        this.checkRepositoryId(parameters.getRepositoryId());
        CMISQueryOptions options = new CMISQueryOptions(parameters.getStatement(), this.cmisService.getDefaultRootStoreRef());
        int skipCount = 0;
        if (parameters.getSkipCount() != null && parameters.getSkipCount().getValue() != null) {
            skipCount = ((BigInteger)parameters.getSkipCount().getValue()).intValue();
            options.setSkipCount(skipCount);
        }
        boolean includeAllowableActions = null != parameters.getIncludeAllowableActions() && null != parameters.getIncludeAllowableActions().getValue() ? (Boolean)parameters.getIncludeAllowableActions().getValue() : false;
        String renditionFilter = null != parameters.getRenditionFilter() ? (String)parameters.getRenditionFilter().getValue() : null;
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        QueryResponse response = new QueryResponse();
        CMISResultSet resultSet = null;
        try {
            resultSet = this.cmisQueryService.query(options);
            CMISResultSetColumn[] columns = resultSet.getMetaData().getColumns();
            response.setObjects(new CmisObjectListType());
            EnumIncludeRelationships cmisDirection = null != parameters.getIncludeRelationships() ? (EnumIncludeRelationships)((Object)parameters.getIncludeRelationships().getValue()) : null;
            CMISRelationshipDirectionEnum includeRelationships = (CMISRelationshipDirectionEnum)INCLUDE_RELATIONSHIPS_ENUM_MAPPING.get((Object)cmisDirection);
            int maxItems = -1;
            if (parameters.getMaxItems() != null && parameters.getMaxItems().getValue() != null) {
                maxItems = ((BigInteger)parameters.getMaxItems().getValue()).intValue();
            }
            int numItems = resultSet.getLength();
            int idx = 0;
            for (CMISResultSetRow row : resultSet) {
                List<CmisRenditionType> renditions;
                Object identifier;
                NodeRef nodeRef;
                if (maxItems != -1 && idx == maxItems) break;
                try {
                    nodeRef = row.getNodeRef();
                    identifier = this.cmisService.getReadableObject(nodeRef.toString(), Object.class);
                }
                catch (CMISObjectNotFoundException e) {
                    --numItems;
                    continue;
                }
                catch (CMISServiceException e) {
                    throw ExceptionUtil.createCmisException(e);
                }
                CmisPropertiesType properties = new CmisPropertiesType();
                Map values = row.getValues();
                for (CMISResultSetColumn column : columns) {
                    CmisProperty property = this.propertiesUtil.createProperty(column.getName(), column.getCMISDataType(), (Serializable)values.get(column.getName()));
                    if (property == null) continue;
                    property.setQueryName(column.getName());
                    properties.getProperty().add(property);
                }
                CmisObjectType object = new CmisObjectType();
                object.setProperties(properties);
                if (includeAllowableActions) {
                    object.setAllowableActions(this.determineObjectAllowableActions(identifier));
                }
                if (null != includeRelationships) {
                    this.appendWithRelationships(nodeRef, this.createPropertyFilter((String)null), includeRelationships, includeAllowableActions, renditionFilter, object);
                }
                if (renditionFilter != null && (renditions = this.getRenditions(identifier, renditionFilter)) != null && !renditions.isEmpty()) {
                    object.getRendition().addAll(renditions);
                }
                response.getObjects().getObjects().add(object);
                ++idx;
            }
            response.getObjects().setNumItems(BigInteger.valueOf(numItems));
            boolean hasMoreItems = maxItems != -1 && numItems - (skipCount + maxItems) > 0 || resultSet.hasMore();
            response.getObjects().setHasMoreItems(hasMoreItems);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return response;
    }

    @Override
    public void getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeACL, BigInteger maxItems, CmisExtensionType extension, Holder<CmisObjectListType> objects) throws CmisException {
        boolean propertiesRequsted;
        if (!this.authorityService.hasAdminAuthority()) {
            throw ExceptionUtil.createCmisException("Cannot retrieve content changes", (Throwable)new AccessDeniedException("Requires admin authority"));
        }
        this.checkRepositoryId(repositoryId);
        String changeToken = null != changeLogToken ? (String)changeLogToken.value : null;
        Integer maxAmount = null != maxItems ? Integer.valueOf(maxItems.intValue()) : null;
        boolean bl = propertiesRequsted = null != includeProperties ? includeProperties : false;
        if (propertiesRequsted) {
            if (!(null == filter || "".equals(filter) || "*".equals(filter) || filter.contains("cmis:objectId"))) {
                filter = "cmis:objectId," + filter;
            }
        } else {
            filter = "cmis:objectId";
        }
        CMISChangeLog changeLog = null;
        try {
            changeLog = this.cmisChangeLogService.getChangeLogEvents(changeToken, maxAmount);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        if (null == objects.value) {
            objects.value = new CmisObjectListType();
        }
        if (null == changeLog || null == changeLog.getChangeEvents() || changeLog.getChangeEvents().isEmpty()) {
            ((CmisObjectListType)objects.value).setHasMoreItems(false);
            ((CmisObjectListType)objects.value).setNumItems(BigInteger.valueOf(0L));
        } else {
            this.formatObjectsResponse(filter, propertiesRequsted, includeACL, changeLog, ((CmisObjectListType)objects.value).getObjects());
            ((CmisObjectListType)objects.value).setHasMoreItems(changeLog.hasMoreItems());
            ((CmisObjectListType)objects.value).setNumItems(BigInteger.valueOf(changeLog.getChangeEvents().size()));
            changeLogToken.value = changeLog.getNextChangeToken();
        }
    }

    private void formatObjectsResponse(String filter, boolean propertiesRequsted, boolean includeAce, CMISChangeLog changeLog, List<CmisObjectType> result) throws CmisException {
        for (CMISChangeEvent event : changeLog.getChangeEvents()) {
            CmisObjectType object = new CmisObjectType();
            CmisPropertiesType propertiesType = new CmisPropertiesType();
            object.setProperties(propertiesType);
            propertiesType.getProperty().add(this.propertiesUtil.createProperty("cmis:objectId", CMISDataTypeEnum.ID, (Serializable)((Object)event.getObjectId())));
            if (this.nodeService.exists(event.getChangedNode()) && includeAce) {
                this.appendWithAce(event.getChangedNode(), object);
            }
            CmisChangeEventType changeInfo = new CmisChangeEventType();
            XMLGregorianCalendar modificationDate = this.propertiesUtil.convert(event.getChangeTime());
            changeInfo.setChangeType(changesTypeMapping.get(event.getChangeType()));
            changeInfo.setChangeTime(modificationDate);
            object.setChangeEventInfo(changeInfo);
            result.add(object);
        }
    }

    static {
        changesTypeMapping.put(CMISChangeType.CREATED, EnumTypeOfChanges.CREATED);
        changesTypeMapping.put(CMISChangeType.UPDATED, EnumTypeOfChanges.UPDATED);
        changesTypeMapping.put(CMISChangeType.SECURITY, EnumTypeOfChanges.SECURITY);
        changesTypeMapping.put(CMISChangeType.DELETED, EnumTypeOfChanges.DELETED);
    }
}

