/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws;

import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.alfresco.cmis.CMISDictionaryModel;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.repo.cmis.ws.CmisException;
import org.alfresco.repo.cmis.ws.CmisExtensionType;
import org.alfresco.repo.cmis.ws.DMAbstractServicePort;
import org.alfresco.repo.cmis.ws.EnumServiceException;
import org.alfresco.repo.cmis.ws.MultiFilingServicePort;
import org.alfresco.repo.cmis.ws.utils.ExceptionUtil;
import org.alfresco.service.cmr.repository.NodeRef;

@WebService(name="MultiFilingServicePort", serviceName="MultiFilingService", portName="MultiFilingServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", endpointInterface="org.alfresco.repo.cmis.ws.MultiFilingServicePort")
public class DMMultiFilingServicePort
extends DMAbstractServicePort
implements MultiFilingServicePort {
    @Override
    public void addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, Holder<CmisExtensionType> extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        this.checkConstraints(objectId, folderId, false);
        try {
            this.cmisService.addObjectToFolder(objectId, folderId);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public void removeObjectFromFolder(String repositoryId, String objectId, String folderId, Holder<CmisExtensionType> extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        this.checkConstraints(objectId, folderId, true);
        try {
            this.cmisService.removeObjectFromFolder(objectId, folderId);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    private void checkConstraints(String objectId, String folderId, boolean checkIsObjectInFolder) throws CmisException {
        NodeRef objectNodeRef = null;
        NodeRef folderNodeRef = null;
        CMISTypeDefinition objectTypeDef = null;
        try {
            objectNodeRef = (NodeRef)this.cmisService.getObject(objectId, NodeRef.class, true, false, false);
            folderNodeRef = this.cmisService.getFolder(folderId);
            objectTypeDef = this.cmisService.getTypeDefinition(objectNodeRef);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e.getMessage(), EnumServiceException.INVALID_ARGUMENT);
        }
        if (!objectTypeDef.getTypeId().getBaseTypeId().equals((Object)CMISDictionaryModel.DOCUMENT_TYPE_ID)) {
            throw ExceptionUtil.createCmisException("Object " + objectId + " is not a document", EnumServiceException.INVALID_ARGUMENT);
        }
        if (checkIsObjectInFolder && !this.isObjectInFolder(objectNodeRef, folderNodeRef)) {
            throw ExceptionUtil.createCmisException("Folder doesn't contain specified object", EnumServiceException.OBJECT_NOT_FOUND);
        }
    }
}

