/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.alfresco.cmis.CMISConstraintException;
import org.alfresco.cmis.CMISContentStreamAllowedEnum;
import org.alfresco.cmis.CMISInvalidArgumentException;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.CMISVersioningStateEnum;
import org.alfresco.cmis.PropertyFilter;
import org.alfresco.repo.cmis.ws.CmisAccessControlListType;
import org.alfresco.repo.cmis.ws.CmisAllowableActionsType;
import org.alfresco.repo.cmis.ws.CmisContentStreamType;
import org.alfresco.repo.cmis.ws.CmisException;
import org.alfresco.repo.cmis.ws.CmisExtensionType;
import org.alfresco.repo.cmis.ws.CmisObjectType;
import org.alfresco.repo.cmis.ws.CmisPropertiesType;
import org.alfresco.repo.cmis.ws.CmisRenditionType;
import org.alfresco.repo.cmis.ws.ContentReaderDataSource;
import org.alfresco.repo.cmis.ws.DMAbstractServicePort;
import org.alfresco.repo.cmis.ws.DeleteTreeResponse;
import org.alfresco.repo.cmis.ws.EnumACLPropagation;
import org.alfresco.repo.cmis.ws.EnumIncludeRelationships;
import org.alfresco.repo.cmis.ws.EnumServiceException;
import org.alfresco.repo.cmis.ws.EnumUnfileObject;
import org.alfresco.repo.cmis.ws.EnumVersioningState;
import org.alfresco.repo.cmis.ws.FileTypeIconRetriever;
import org.alfresco.repo.cmis.ws.ObjectServicePort;
import org.alfresco.repo.cmis.ws.utils.ExceptionUtil;
import org.alfresco.repo.web.util.paging.Cursor;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.FileTypeImageSize;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

@WebService(name="ObjectServicePort", serviceName="ObjectService", portName="ObjectServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", endpointInterface="org.alfresco.repo.cmis.ws.ObjectServicePort")
public class DMObjectServicePort
extends DMAbstractServicePort
implements ObjectServicePort {
    private static final Map<EnumVersioningState, CMISVersioningStateEnum> VERSIONING_STATE_ENUM_MAPPING = new HashMap<EnumVersioningState, CMISVersioningStateEnum>(7);
    private DictionaryService dictionaryService;
    private FileTypeIconRetriever iconRetriever;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public void createDocument(String repositoryId, CmisPropertiesType properties, String folderId, CmisContentStreamType contentStream, EnumVersioningState versioningState, List<String> policies, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            NodeRef parentNodeRef = this.cmisService.getFolder(folderId);
            Map<String, Serializable> propertiesMap = this.propertiesUtil.getPropertiesMap(properties);
            String typeId = this.extractAndAssertTypeId(propertiesMap);
            CMISTypeDefinition typeDef = this.cmisService.getTypeDefinition(typeId);
            String documentName = this.checkConstraintsAndGetName(typeId, typeDef, parentNodeRef, contentStream, propertiesMap, versioningState);
            NodeRef newDocumentNodeRef = this.fileFolderService.create(parentNodeRef, documentName, typeDef.getTypeId().getQName()).getNodeRef();
            if (null != contentStream) {
                ContentWriter writer = this.fileFolderService.getWriter(newDocumentNodeRef);
                String mimeType = (String)((Object)propertiesMap.get("cmis:contentStreamMimeType"));
                String string = mimeType = null == mimeType ? contentStream.getMimeType() : mimeType;
                if (null != mimeType) {
                    writer.setMimetype(mimeType);
                }
                InputStream inputstream = null;
                try {
                    inputstream = contentStream.getStream().getInputStream();
                }
                catch (IOException e) {
                    throw ExceptionUtil.createCmisException(e.getMessage(), EnumServiceException.RUNTIME, e);
                }
                writer.putContent(inputstream);
            }
            PropertyFilter propertyFilter = this.createPropertyFilter(this.createIgnoringFilter(new String[]{"cmis:name", "cmis:objectTypeId"}));
            this.appendDataToDocument(newDocumentNodeRef, properties, versioningState, policies, addACEs, removeACEs, objectId, propertyFilter);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        if (null == properties) {
            throw ExceptionUtil.createCmisException("Properties input parameter is Mandatory", EnumServiceException.INVALID_ARGUMENT);
        }
    }

    @Override
    public void createDocumentFromSource(String repositoryId, String sourceId, CmisPropertiesType properties, String folderId, EnumVersioningState versioningState, List<String> policies, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            NodeRef newDocumentNodeRef;
            NodeRef folderNodeRef = this.cmisService.getFolder(folderId);
            NodeRef sourceNodeRef = (NodeRef)this.cmisService.getReadableObject(sourceId, NodeRef.class);
            String name = this.propertiesUtil.getCmisPropertyValue(properties, "cmis:name", null);
            if (name == null) {
                name = this.propertiesUtil.getProperty(sourceNodeRef, "cmis:name", null);
            }
            try {
                newDocumentNodeRef = this.fileFolderService.copy(sourceNodeRef, folderNodeRef, name).getNodeRef();
            }
            catch (FileExistsException e) {
                throw ExceptionUtil.createCmisException("Document already exists", EnumServiceException.NAME_CONSTRAINT_VIOLATION);
            }
            catch (FileNotFoundException e) {
                throw ExceptionUtil.createCmisException("Source document not found", EnumServiceException.INVALID_ARGUMENT);
            }
            PropertyFilter propertyFilter = this.createPropertyFilter(this.createIgnoringFilter(new String[]{"cmis:objectTypeId"}));
            this.appendDataToDocument(newDocumentNodeRef, properties, versioningState, policies, addACEs, removeACEs, objectId, propertyFilter);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public void createFolder(String repositoryId, CmisPropertiesType properties, String folderId, List<String> policies, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            NodeRef folderNodeRef = this.cmisService.getFolder(folderId);
            Map<String, Serializable> propertiesMap = this.propertiesUtil.getPropertiesMap(properties);
            String typeId = this.extractAndAssertTypeId(propertiesMap);
            CMISTypeDefinition type = this.cmisService.getTypeDefinition(typeId);
            if (type == null || type.getTypeId() == null || type.getTypeId().getScope() != CMISScope.FOLDER) {
                throw ExceptionUtil.createCmisException("The typeID is not an Object-Type whose baseType is 'Folder': " + typeId, EnumServiceException.CONSTRAINT);
            }
            String name = this.propertiesUtil.getCmisPropertyValue(properties, "cmis:name", null);
            if (null == name) {
                throw ExceptionUtil.createCmisException("Name property not found", EnumServiceException.INVALID_ARGUMENT);
            }
            NodeRef newFolderNodeRef = this.fileFolderService.create(folderNodeRef, name, type.getTypeId().getQName()).getNodeRef();
            this.propertiesUtil.setProperties(newFolderNodeRef, properties, this.createPropertyFilter(this.createIgnoringFilter(new String[]{"cmis:name", "cmis:objectTypeId"})));
            this.applyAclCarefully(newFolderNodeRef, addACEs, removeACEs, EnumACLPropagation.PROPAGATE, policies);
            objectId.value = this.propertiesUtil.getProperty(newFolderNodeRef, "cmis:objectId", null);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public void createPolicy(String repositoryId, CmisPropertiesType properties, String folderId, List<String> policies, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            objectId.value = this.cmisService.createPolicy(this.propertiesUtil.getPropertiesMap(properties), folderId, policies);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public void createRelationship(String repositoryId, CmisPropertiesType properties, List<String> policies, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        Map<String, Serializable> propertiesMap = this.propertiesUtil.getPropertiesMap(properties);
        String sourceObjectId = (String)((Object)propertiesMap.get("cmis:sourceId"));
        String targetObjectId = (String)((Object)propertiesMap.get("cmis:targetId"));
        this.checkRepositoryId(repositoryId);
        try {
            NodeRef sourceNodeRef = (NodeRef)this.cmisService.getObject(sourceObjectId, NodeRef.class, true, false, false);
            NodeRef targetNodeRef = (NodeRef)this.cmisService.getObject(targetObjectId, NodeRef.class, true, false, false);
            String typeId = (String)((Object)propertiesMap.get("cmis:objectTypeId"));
            CMISTypeDefinition relationshipType = this.cmisService.getTypeDefinition(typeId);
            if (relationshipType == null || relationshipType.getTypeId() == null || relationshipType.getTypeId().getScope() != CMISScope.RELATIONSHIP) {
                throw ExceptionUtil.createCmisException(typeId, EnumServiceException.INVALID_ARGUMENT);
            }
            CMISTypeDefinition sourceType = this.cmisService.getTypeDefinition(sourceNodeRef);
            CMISTypeDefinition targetType = this.cmisService.getTypeDefinition(targetNodeRef);
            QName relationshipTypeQName = relationshipType.getTypeId().getQName();
            AssociationDefinition associationDef = this.dictionaryService.getAssociation(relationshipTypeQName);
            if (associationDef != null) {
                if (!this.dictionaryService.isSubClass(this.nodeService.getType(sourceNodeRef), associationDef.getSourceClass().getName())) {
                    throw ExceptionUtil.createCmisException("Source object type isn't allowed as source type", EnumServiceException.CONSTRAINT);
                }
                if (!this.dictionaryService.isSubClass(this.nodeService.getType(targetNodeRef), associationDef.getTargetClass().getName())) {
                    throw ExceptionUtil.createCmisException("Target object type isn't allowed as target type", EnumServiceException.CONSTRAINT);
                }
                if (addACEs != null && !addACEs.getPermission().isEmpty() || removeACEs != null && !removeACEs.getPermission().isEmpty()) {
                    throw ExceptionUtil.createCmisException("ACLs are not supported for type: " + relationshipType.getDisplayName(), EnumServiceException.CONSTRAINT);
                }
            } else {
                throw ExceptionUtil.createCmisException(relationshipType.getTypeId().getQName() + " Relationship type not found", EnumServiceException.INVALID_ARGUMENT);
            }
            AssociationRef assocRef = this.nodeService.createAssociation(sourceNodeRef, targetNodeRef, relationshipTypeQName);
            String createdId = (String)((Object)this.cmisService.getProperty(assocRef, "cmis:objectId"));
            this.applyPolicies(createdId, policies);
            objectId.value = createdId;
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Holder<CmisExtensionType> extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            this.cmisService.deleteContentStream((String)objectId.value);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, Holder<CmisExtensionType> extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            this.cmisService.deleteObject(objectId, allVersions == null || allVersions != false);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public DeleteTreeResponse.FailedToDelete deleteTree(String repositoryId, String folderId, Boolean allVersions, EnumUnfileObject unfileObject, Boolean continueOnFailure, CmisExtensionType extension) throws CmisException {
        List failedToDelete;
        this.checkRepositoryId(repositoryId);
        this.checkUnfilingIsNotRequested(unfileObject);
        try {
            failedToDelete = this.cmisService.deleteTree(folderId, continueOnFailure == null ? false : continueOnFailure, unfileObject != EnumUnfileObject.DELETE, allVersions == null || allVersions != false);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        DeleteTreeResponse.FailedToDelete response = new DeleteTreeResponse.FailedToDelete();
        response.getObjectIds().addAll(failedToDelete);
        return response;
    }

    @Override
    public CmisObjectType getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, CmisExtensionType extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            boolean includeAcl;
            Object object = this.cmisService.getReadableObject(objectId, Object.class);
            PropertyFilter propertyFilter = this.createPropertyFilter(filter);
            CmisObjectType cmisObject = this.createCmisObject(object, propertyFilter, includeRelationships, includeAllowableActions, renditionFilter);
            Object versionSeries = this.cmisService.getVersionSeries(objectId, Object.class, false);
            boolean bl = includeAcl = null != includeACL ? includeACL : false;
            if (includeAcl && versionSeries instanceof NodeRef) {
                this.appendWithAce((NodeRef)versionSeries, cmisObject);
            }
            return cmisObject;
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public CmisObjectType getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, CmisExtensionType extension) throws CmisException {
        boolean includeAcl;
        this.checkRepositoryId(repositoryId);
        NodeRef objectNodeRef = this.resolvePathInfo(path);
        if (null == objectNodeRef) {
            throw ExceptionUtil.createCmisException("Path to Folder was not specified or Folder Path is invalid", EnumServiceException.OBJECT_NOT_FOUND);
        }
        PropertyFilter propertyFilter = this.createPropertyFilter(filter);
        CmisObjectType object = this.createCmisObject((Object)objectNodeRef, propertyFilter, includeRelationships, includeAllowableActions, renditionFilter);
        boolean bl = includeAcl = null != includeACL ? includeACL : false;
        if (includeAcl) {
            this.appendWithAce(objectNodeRef, object);
        }
        return object;
    }

    @Override
    public CmisAllowableActionsType getAllowableActions(String repositoryId, String objectId, CmisExtensionType extension) throws CmisException {
        Object object;
        this.checkRepositoryId(repositoryId);
        try {
            object = this.cmisService.getReadableObject(objectId, Object.class);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        return this.determineObjectAllowableActions(object);
    }

    @Override
    public CmisContentStreamType getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, CmisExtensionType extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            NodeRef nodeRef = (NodeRef)this.cmisService.getReadableObject(objectId, NodeRef.class);
            CMISTypeDefinition typeDefinition = this.cmisService.getTypeDefinition(nodeRef);
            if (CMISContentStreamAllowedEnum.NOT_ALLOWED == typeDefinition.getContentStreamAllowed()) {
                throw ExceptionUtil.createCmisException("Content stream not allowed", EnumServiceException.STREAM_NOT_SUPPORTED);
            }
            String filename = this.propertiesUtil.getProperty(nodeRef, "cmis:name", null);
            ContentReaderDataSource dataSource = null;
            if (streamId != null && streamId.length() > 0) {
                FileTypeImageSize streamIcon = null;
                if (streamId.equals("alf:icon16")) {
                    streamIcon = FileTypeImageSize.Small;
                } else if (streamId.equals("alf:icon32")) {
                    streamIcon = FileTypeImageSize.Medium;
                }
                if (streamIcon != null) {
                    InputStream iconInputStream = this.iconRetriever.getIconContent(filename, streamIcon);
                    String iconMimetype = this.iconRetriever.getIconMimetype(filename, streamIcon);
                    if (iconInputStream != null && iconMimetype != null) {
                        dataSource = new ContentReaderDataSource(iconInputStream, iconMimetype, filename, offset, length);
                    }
                } else {
                    NodeRef renditionNodeRef = new NodeRef(streamId);
                    ContentReader reader = this.safeGetContentReader(renditionNodeRef);
                    dataSource = new ContentReaderDataSource(reader, filename, offset, length, reader.getSize());
                }
            } else {
                ContentReader reader = this.safeGetContentReader(nodeRef);
                dataSource = new ContentReaderDataSource(reader, filename, offset, length, reader.getSize());
            }
            CmisContentStreamType response = new CmisContentStreamType();
            response.setFilename(filename);
            if (dataSource != null) {
                response.setMimeType(dataSource.getContentType());
                response.setStream(new DataHandler((DataSource)dataSource));
                response.setLength(BigInteger.valueOf(dataSource.getSizeToRead()));
            }
            return response;
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, Holder<CmisExtensionType> extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            this.cmisService.moveObject((String)objectId.value, targetFolderId, sourceFolderId);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, CmisContentStreamType contentStream, Holder<CmisExtensionType> extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            this.cmisService.setContentStream((String)objectId.value, null, overwriteFlag == null || overwriteFlag != false, contentStream.getStream().getInputStream(), contentStream.getMimeType());
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        catch (Exception e) {
            throw ExceptionUtil.createCmisException(e.getMessage(), EnumServiceException.RUNTIME, e);
        }
    }

    @Override
    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, CmisPropertiesType properties, Holder<CmisExtensionType> extension) throws CmisException {
        NodeRef objectNodeRef;
        this.checkRepositoryId(repositoryId);
        try {
            objectNodeRef = (NodeRef)this.cmisService.getObject((String)objectId.value, NodeRef.class, true, false, false);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        this.propertiesUtil.setProperties(objectNodeRef, properties, null);
    }

    @Override
    public CmisPropertiesType getProperties(String repositoryId, String objectId, String filter, CmisExtensionType extension) throws CmisException {
        Object identifierInstance;
        this.checkRepositoryId(repositoryId);
        PropertyFilter propertyFilter = this.createPropertyFilter(filter);
        try {
            identifierInstance = this.cmisService.getReadableObject(objectId, Object.class);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        CmisPropertiesType result = this.propertiesUtil.getProperties(identifierInstance, propertyFilter);
        return result;
    }

    @Override
    public List<CmisRenditionType> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        NodeRef objectNodeRef;
        this.checkRepositoryId(repositoryId);
        try {
            objectNodeRef = (NodeRef)this.cmisService.getReadableObject(objectId, NodeRef.class);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        ArrayList<CmisRenditionType> result = new ArrayList<CmisRenditionType>();
        List<CmisRenditionType> renditions = this.getRenditions(objectNodeRef, renditionFilter);
        if (renditions != null) {
            Cursor cursor = this.createCursor(renditions.size(), skipCount, maxItems);
            for (int index = cursor.getStartRow(); index <= cursor.getEndRow(); ++index) {
                result.add(renditions.get(index));
            }
        }
        return renditions;
    }

    private void appendDataToDocument(NodeRef targetDocumentNodeRef, CmisPropertiesType properties, EnumVersioningState versioningState, List<String> policies, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, Holder<String> objectId, PropertyFilter propertyFilter) throws CMISConstraintException, CmisException, CMISInvalidArgumentException {
        this.propertiesUtil.setProperties(targetDocumentNodeRef, properties, propertyFilter);
        this.applyAclCarefully(targetDocumentNodeRef, addACEs, removeACEs, EnumACLPropagation.PROPAGATE, policies);
        if (versioningState == null) {
            versioningState = EnumVersioningState.MAJOR;
        }
        targetDocumentNodeRef = this.cmisService.applyVersioningState(targetDocumentNodeRef, VERSIONING_STATE_ENUM_MAPPING.get((Object)versioningState));
        objectId.value = targetDocumentNodeRef.toString();
    }

    private String createIgnoringFilter(String[] propertyNames) {
        StringBuilder filter = new StringBuilder("");
        for (String propertyName : propertyNames) {
            if (null == propertyName || propertyName.equals("")) continue;
            filter.append(propertyName);
            filter.append(",");
        }
        if (filter.length() > 0) {
            filter.deleteCharAt(filter.length() - 1);
        }
        return filter.toString();
    }

    private String extractAndAssertTypeId(Map<String, Serializable> propertiesMap) throws CmisException {
        String typeId = (String)((Object)propertiesMap.get("cmis:objectTypeId"));
        if (null == typeId || "".equals(typeId)) {
            throw ExceptionUtil.createCmisException("Type Id property required", EnumServiceException.INVALID_ARGUMENT);
        }
        return typeId;
    }

    private String checkConstraintsAndGetName(String documentTypeId, CMISTypeDefinition typeDef, NodeRef parentNodeRef, CmisContentStreamType contentStream, Map<String, Serializable> propertiesMap, EnumVersioningState versioningState) throws CmisException {
        CMISTypeDefinition folderTypeDefinition;
        if (null == typeDef || null == typeDef.getTypeId()) {
            throw ExceptionUtil.createCmisException("Type with " + documentTypeId + "typeId was not found", EnumServiceException.RUNTIME);
        }
        if (CMISScope.DOCUMENT != typeDef.getTypeId().getScope() || !typeDef.isCreatable()) {
            throw ExceptionUtil.createCmisException("Invalid document type \"" + documentTypeId + "\". This type is not a Creatable Document type", EnumServiceException.CONSTRAINT);
        }
        if (null != contentStream && CMISContentStreamAllowedEnum.NOT_ALLOWED == typeDef.getContentStreamAllowed()) {
            throw ExceptionUtil.createCmisException("Content stream not allowed for \"" + documentTypeId + "\" document object type", EnumServiceException.STREAM_NOT_SUPPORTED);
        }
        if (CMISContentStreamAllowedEnum.REQUIRED == typeDef.getContentStreamAllowed() && null == contentStream) {
            throw ExceptionUtil.createCmisException("Content stream for document object of " + documentTypeId + " type is required", EnumServiceException.CONSTRAINT);
        }
        if (!typeDef.isVersionable() && null != versioningState) {
            throw ExceptionUtil.createCmisException("Verioning for \"" + documentTypeId + "\" document type is not allowed", EnumServiceException.CONSTRAINT);
        }
        try {
            folderTypeDefinition = this.cmisService.getTypeDefinition(parentNodeRef);
        }
        catch (CMISInvalidArgumentException e) {
            throw ExceptionUtil.createCmisException(e.getMessage(), EnumServiceException.INVALID_ARGUMENT, e);
        }
        if (null != folderTypeDefinition.getAllowedTargetTypes() && !folderTypeDefinition.getAllowedTargetTypes().isEmpty() && !folderTypeDefinition.getAllowedTargetTypes().contains(typeDef)) {
            throw ExceptionUtil.createCmisException("Children of \"" + documentTypeId + "\" type are not allowed for specified folder", EnumServiceException.CONSTRAINT);
        }
        String result = (String)((Object)propertiesMap.get("cmis:name"));
        if (null == result) {
            throw ExceptionUtil.createCmisException("Name property not found", EnumServiceException.INVALID_ARGUMENT);
        }
        return result;
    }

    private NodeRef resolvePathInfo(String folderPath) throws CmisException {
        NodeRef result = null;
        if (null != folderPath) {
            if ("".equals(folderPath = folderPath.substring(1))) {
                result = this.cmisService.getDefaultRootNodeRef();
            } else {
                FileInfo fileInfo = null;
                try {
                    List<String> splitedPath = Arrays.asList(folderPath.split("/"));
                    fileInfo = this.fileFolderService.resolveNamePath(this.cmisService.getDefaultRootNodeRef(), splitedPath);
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
                result = null != fileInfo ? fileInfo.getNodeRef() : null;
            }
        }
        return result;
    }

    private ContentReader safeGetContentReader(NodeRef objectNodeReference) throws CmisException {
        ContentReader reader = this.fileFolderService.getReader(objectNodeReference);
        if (reader == null) {
            throw ExceptionUtil.createCmisException("The specified Document has no Content Stream", EnumServiceException.CONSTRAINT);
        }
        return reader;
    }

    private void checkUnfilingIsNotRequested(EnumUnfileObject unfileNonfolderObjects) throws CmisException {
        if (unfileNonfolderObjects == EnumUnfileObject.UNFILE) {
            throw ExceptionUtil.createCmisException("Unfiling is not supported", EnumServiceException.NOT_SUPPORTED);
        }
    }

    public void setFileTypeIconRetriever(FileTypeIconRetriever iconRetriever) {
        this.iconRetriever = iconRetriever;
    }

    static {
        VERSIONING_STATE_ENUM_MAPPING.put(EnumVersioningState.NONE, CMISVersioningStateEnum.NONE);
        VERSIONING_STATE_ENUM_MAPPING.put(EnumVersioningState.CHECKEDOUT, CMISVersioningStateEnum.CHECKED_OUT);
        VERSIONING_STATE_ENUM_MAPPING.put(EnumVersioningState.MAJOR, CMISVersioningStateEnum.MAJOR);
        VERSIONING_STATE_ENUM_MAPPING.put(EnumVersioningState.MINOR, CMISVersioningStateEnum.MINOR);
    }
}

