/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import org.alfresco.cmis.CMISAclCapabilityEnum;
import org.alfresco.cmis.CMISAclPropagationEnum;
import org.alfresco.cmis.CMISAclSupportedPermissionEnum;
import org.alfresco.cmis.CMISBaseObjectTypeIds;
import org.alfresco.cmis.CMISCapabilityChanges;
import org.alfresco.cmis.CMISCardinalityEnum;
import org.alfresco.cmis.CMISChoice;
import org.alfresco.cmis.CMISContentStreamAllowedEnum;
import org.alfresco.cmis.CMISDataTypeEnum;
import org.alfresco.cmis.CMISInvalidArgumentException;
import org.alfresco.cmis.CMISJoinEnum;
import org.alfresco.cmis.CMISPermissionDefinition;
import org.alfresco.cmis.CMISPermissionMapping;
import org.alfresco.cmis.CMISPropertyDefinition;
import org.alfresco.cmis.CMISQueryEnum;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.CMISUpdatabilityEnum;
import org.alfresco.repo.cmis.ws.CmisACLCapabilityType;
import org.alfresco.repo.cmis.ws.CmisChoice;
import org.alfresco.repo.cmis.ws.CmisChoiceBoolean;
import org.alfresco.repo.cmis.ws.CmisChoiceDateTime;
import org.alfresco.repo.cmis.ws.CmisChoiceDecimal;
import org.alfresco.repo.cmis.ws.CmisChoiceId;
import org.alfresco.repo.cmis.ws.CmisChoiceInteger;
import org.alfresco.repo.cmis.ws.CmisChoiceString;
import org.alfresco.repo.cmis.ws.CmisException;
import org.alfresco.repo.cmis.ws.CmisExtensionType;
import org.alfresco.repo.cmis.ws.CmisPermissionDefinition;
import org.alfresco.repo.cmis.ws.CmisPermissionMapping;
import org.alfresco.repo.cmis.ws.CmisPropertyBooleanDefinitionType;
import org.alfresco.repo.cmis.ws.CmisPropertyDateTimeDefinitionType;
import org.alfresco.repo.cmis.ws.CmisPropertyDecimalDefinitionType;
import org.alfresco.repo.cmis.ws.CmisPropertyDefinitionType;
import org.alfresco.repo.cmis.ws.CmisPropertyHtmlDefinitionType;
import org.alfresco.repo.cmis.ws.CmisPropertyIdDefinitionType;
import org.alfresco.repo.cmis.ws.CmisPropertyIntegerDefinitionType;
import org.alfresco.repo.cmis.ws.CmisPropertyStringDefinitionType;
import org.alfresco.repo.cmis.ws.CmisPropertyUriDefinitionType;
import org.alfresco.repo.cmis.ws.CmisRepositoryCapabilitiesType;
import org.alfresco.repo.cmis.ws.CmisRepositoryEntryType;
import org.alfresco.repo.cmis.ws.CmisRepositoryInfoType;
import org.alfresco.repo.cmis.ws.CmisTypeContainer;
import org.alfresco.repo.cmis.ws.CmisTypeDefinitionListType;
import org.alfresco.repo.cmis.ws.CmisTypeDefinitionType;
import org.alfresco.repo.cmis.ws.CmisTypeDocumentDefinitionType;
import org.alfresco.repo.cmis.ws.CmisTypeFolderDefinitionType;
import org.alfresco.repo.cmis.ws.CmisTypePolicyDefinitionType;
import org.alfresco.repo.cmis.ws.CmisTypeRelationshipDefinitionType;
import org.alfresco.repo.cmis.ws.DMAbstractServicePort;
import org.alfresco.repo.cmis.ws.EnumACLPropagation;
import org.alfresco.repo.cmis.ws.EnumAllowableActionsKey;
import org.alfresco.repo.cmis.ws.EnumBaseObjectTypeIds;
import org.alfresco.repo.cmis.ws.EnumCapabilityACL;
import org.alfresco.repo.cmis.ws.EnumCapabilityChanges;
import org.alfresco.repo.cmis.ws.EnumCapabilityContentStreamUpdates;
import org.alfresco.repo.cmis.ws.EnumCapabilityJoin;
import org.alfresco.repo.cmis.ws.EnumCapabilityQuery;
import org.alfresco.repo.cmis.ws.EnumCapabilityRendition;
import org.alfresco.repo.cmis.ws.EnumCardinality;
import org.alfresco.repo.cmis.ws.EnumContentStreamAllowed;
import org.alfresco.repo.cmis.ws.EnumPropertyType;
import org.alfresco.repo.cmis.ws.EnumServiceException;
import org.alfresco.repo.cmis.ws.EnumSupportedPermissions;
import org.alfresco.repo.cmis.ws.EnumUpdatability;
import org.alfresco.repo.cmis.ws.RepositoryServicePort;
import org.alfresco.repo.cmis.ws.utils.ExceptionUtil;
import org.alfresco.repo.web.util.paging.Cursor;
import org.alfresco.service.descriptor.Descriptor;

@WebService(name="RepositoryServicePort", serviceName="RepositoryService", portName="RepositoryServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", endpointInterface="org.alfresco.repo.cmis.ws.RepositoryServicePort")
public class DMRepositoryServicePort
extends DMAbstractServicePort
implements RepositoryServicePort {
    private static final Map<CMISJoinEnum, EnumCapabilityJoin> JOIN_ENUM_MAPPING = new HashMap<CMISJoinEnum, EnumCapabilityJoin>();
    private static final Map<CMISContentStreamAllowedEnum, EnumContentStreamAllowed> CONTENT_STREAM_ALLOWED_ENUM_MAPPING;
    private static final Map<CMISUpdatabilityEnum, EnumUpdatability> UPDATABILITY_ENUM_MAPPING;
    private static final Map<CMISCardinalityEnum, EnumCardinality> CARDINALITY_ENUM_MAPPING;
    private static final Map<CMISDataTypeEnum, EnumPropertyType> PROPERTY_TYPE_ENUM_MAPPING;
    private static final Map<CMISQueryEnum, EnumCapabilityQuery> QUERY_TYPE_ENUM_MAPPING;
    private static final Map<CMISCapabilityChanges, EnumCapabilityChanges> CHANGES_TYPE_ENUM_MAPPING;
    private static final Map<CMISBaseObjectTypeIds, EnumBaseObjectTypeIds> BASE_IDS_TYPE_ENUM_MAPPING;
    private static final Map<CMISAclCapabilityEnum, EnumCapabilityACL> ACL_CAPABILITY_ENUM_MAPPING;
    private static final Map<CMISAclSupportedPermissionEnum, EnumSupportedPermissions> ACL_SUPPORTED_PERMISSION_ENUM_MAPPING;
    private static final Map<CMISAclPropagationEnum, EnumACLPropagation> ACL_PROPAGATION_ENUM_MAPPGIN;
    private List<CmisPermissionDefinition> permissionDefinitions;
    private List<CmisPermissionMapping> permissionMapping;

    private void addPropertyDefs(CMISTypeDefinition typeDefinition, CMISPropertyDefinition propertyDefinition, List<CmisPropertyDefinitionType> wsPropertyDefs) throws CmisException {
        CmisPropertyDefinitionType wsPropertyDef = this.createPropertyDefinitionType(propertyDefinition.getDataType());
        wsPropertyDef.setLocalName(propertyDefinition.getPropertyId().getLocalName());
        wsPropertyDef.setLocalNamespace(propertyDefinition.getPropertyId().getLocalNamespace());
        wsPropertyDef.setId(propertyDefinition.getPropertyId().getId());
        wsPropertyDef.setQueryName(propertyDefinition.getQueryName());
        wsPropertyDef.setDisplayName(propertyDefinition.getDisplayName());
        wsPropertyDef.setDescription(propertyDefinition.getDescription());
        wsPropertyDef.setPropertyType(PROPERTY_TYPE_ENUM_MAPPING.get(propertyDefinition.getDataType()));
        wsPropertyDef.setCardinality(CARDINALITY_ENUM_MAPPING.get(propertyDefinition.getCardinality()));
        wsPropertyDef.setUpdatability(UPDATABILITY_ENUM_MAPPING.get(propertyDefinition.getUpdatability()));
        wsPropertyDef.setInherited(!typeDefinition.getOwnedPropertyDefinitions().containsKey(propertyDefinition.getPropertyId().getId()));
        wsPropertyDef.setRequired(propertyDefinition.isRequired());
        wsPropertyDef.setQueryable(propertyDefinition.isQueryable());
        wsPropertyDef.setOrderable(propertyDefinition.isOrderable());
        this.addChoices(propertyDefinition.getDataType(), propertyDefinition.getChoices(), this.getChoices(wsPropertyDef));
        wsPropertyDef.setOpenChoice(propertyDefinition.isOpenChoice());
        wsPropertyDefs.add(wsPropertyDef);
    }

    private void addChoices(CMISDataTypeEnum propertyType, Collection<CMISChoice> choices, List<CmisChoice> cmisChoices) {
        for (CMISChoice choice : choices) {
            CmisChoice cmisChoiceType = this.getCmisChoiceType(choice, propertyType);
            cmisChoices.add(cmisChoiceType);
            if (choice.getChildren().isEmpty()) continue;
            this.addChoiceChildrens(propertyType, choice.getChildren(), cmisChoices);
        }
    }

    private List<CmisChoice> getChoices(CmisPropertyDefinitionType propertyDef) {
        List result = null;
        if (propertyDef != null) {
            try {
                result = (List)propertyDef.getClass().getMethod("getChoice", new Class[0]).invoke((Object)propertyDef, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private CmisChoice getCmisChoiceType(CMISChoice choice, CMISDataTypeEnum propertyType) {
        CmisChoice result = null;
        switch (propertyType) {
            case BOOLEAN: {
                CmisChoiceBoolean choiceBooleanType = new CmisChoiceBoolean();
                choiceBooleanType.setDisplayName(choice.getName());
                choiceBooleanType.getValue().add(Boolean.parseBoolean(choice.getValue().toString()));
                result = choiceBooleanType;
                break;
            }
            case DATETIME: {
                CmisChoiceDateTime choiceDateTimeType = new CmisChoiceDateTime();
                choiceDateTimeType.setDisplayName(choice.getName());
                choiceDateTimeType.getValue().add(this.propertiesUtil.convert((Date)choice.getValue()));
                result = choiceDateTimeType;
                break;
            }
            case DECIMAL: {
                CmisChoiceDecimal choiceDecimalType = new CmisChoiceDecimal();
                choiceDecimalType.setDisplayName(choice.getName());
                choiceDecimalType.getValue().add(BigDecimal.valueOf(Double.parseDouble(choice.getValue().toString())));
                result = choiceDecimalType;
                break;
            }
            case HTML: {
                break;
            }
            case ID: {
                CmisChoiceId choiceIdType = new CmisChoiceId();
                choiceIdType.setDisplayName(choice.getName());
                choiceIdType.getValue().add(choice.getValue().toString());
                result = choiceIdType;
                break;
            }
            case INTEGER: {
                CmisChoiceInteger choiceIntegerType = new CmisChoiceInteger();
                choiceIntegerType.setDisplayName(choice.getName());
                choiceIntegerType.getValue().add(BigInteger.valueOf(Integer.parseInt(choice.getValue().toString())));
                result = choiceIntegerType;
                break;
            }
            case STRING: {
                CmisChoiceString choiceStringType = new CmisChoiceString();
                choiceStringType.setDisplayName(choice.getName());
                choiceStringType.getValue().add(choice.getValue().toString());
                result = choiceStringType;
                break;
            }
        }
        return result;
    }

    private void addChoiceChildrens(CMISDataTypeEnum propertyType, Collection<CMISChoice> choices, List<CmisChoice> cmisChoices) {
        for (CMISChoice choice : choices) {
            CmisChoice cmisChoiceType = this.getCmisChoiceType(choice, propertyType);
            cmisChoices.add(cmisChoiceType);
            if (choice.getChildren().isEmpty()) continue;
            this.addChoiceChildrens(propertyType, choice.getChildren(), cmisChoices);
        }
    }

    private CmisPropertyDefinitionType createPropertyDefinitionType(CMISDataTypeEnum type) throws CmisException {
        switch (type) {
            case BOOLEAN: {
                return new CmisPropertyBooleanDefinitionType();
            }
            case DATETIME: {
                return new CmisPropertyDateTimeDefinitionType();
            }
            case DECIMAL: {
                return new CmisPropertyDecimalDefinitionType();
            }
            case HTML: {
                return new CmisPropertyHtmlDefinitionType();
            }
            case ID: {
                return new CmisPropertyIdDefinitionType();
            }
            case INTEGER: {
                return new CmisPropertyIntegerDefinitionType();
            }
            case STRING: {
                return new CmisPropertyStringDefinitionType();
            }
            case URI: {
                return new CmisPropertyUriDefinitionType();
            }
        }
        throw ExceptionUtil.createCmisException(type.getLabel(), EnumServiceException.OBJECT_NOT_FOUND);
    }

    private void setCmisTypeDefinitionProperties(CmisTypeDefinitionType cmisTypeDefinition, CMISTypeDefinition typeDefinition, boolean includeProperties) throws CmisException {
        cmisTypeDefinition.setId(typeDefinition.getTypeId().getId());
        cmisTypeDefinition.setQueryName(typeDefinition.getQueryName());
        cmisTypeDefinition.setDisplayName(typeDefinition.getDisplayName());
        cmisTypeDefinition.setBaseId(EnumBaseObjectTypeIds.fromValue(typeDefinition.getBaseType().getTypeId().getId()));
        cmisTypeDefinition.setLocalNamespace(typeDefinition.getTypeId().getLocalNamespace());
        cmisTypeDefinition.setLocalName(typeDefinition.getTypeId().getLocalName());
        if (null != typeDefinition.getParentType() && null != typeDefinition.getParentType().getTypeId()) {
            cmisTypeDefinition.setParentId(typeDefinition.getParentType().getTypeId().getId());
        }
        cmisTypeDefinition.setDescription(typeDefinition.getDescription());
        cmisTypeDefinition.setCreatable(typeDefinition.isCreatable());
        cmisTypeDefinition.setFileable(typeDefinition.isFileable());
        cmisTypeDefinition.setQueryable(typeDefinition.isQueryable());
        cmisTypeDefinition.setControllableACL(typeDefinition.isControllableACL());
        cmisTypeDefinition.setControllablePolicy(typeDefinition.isControllablePolicy());
        cmisTypeDefinition.setIncludedInSupertypeQuery(typeDefinition.isIncludedInSuperTypeQuery());
        if (includeProperties) {
            List<CmisPropertyDefinitionType> propertyDefs = cmisTypeDefinition.getPropertyDefinition();
            for (CMISPropertyDefinition cmisPropDef : typeDefinition.getPropertyDefinitions().values()) {
                this.addPropertyDefs(typeDefinition, cmisPropDef, propertyDefs);
            }
        }
    }

    private CmisTypeDefinitionType getCmisTypeDefinition(CMISTypeDefinition typeDef, boolean includeProperties) throws CmisException {
        if (typeDef == null) {
            throw ExceptionUtil.createCmisException("Type not found", EnumServiceException.OBJECT_NOT_FOUND);
        }
        CmisTypeDefinitionType result = null;
        switch (typeDef.getTypeId().getScope()) {
            case DOCUMENT: {
                CmisTypeDocumentDefinitionType documentDefinitionType = new CmisTypeDocumentDefinitionType();
                documentDefinitionType.setVersionable(typeDef.isVersionable());
                documentDefinitionType.setContentStreamAllowed(CONTENT_STREAM_ALLOWED_ENUM_MAPPING.get(typeDef.getContentStreamAllowed()));
                result = documentDefinitionType;
                break;
            }
            case FOLDER: {
                result = new CmisTypeFolderDefinitionType();
                break;
            }
            case POLICY: {
                result = new CmisTypePolicyDefinitionType();
                break;
            }
            case RELATIONSHIP: {
                CmisTypeRelationshipDefinitionType relationshipDefinitionType = new CmisTypeRelationshipDefinitionType();
                if (typeDef.getAllowedSourceTypes() != null) {
                    for (CMISTypeDefinition definition : typeDef.getAllowedSourceTypes()) {
                        relationshipDefinitionType.getAllowedSourceTypes().add(definition.getTypeId().getId());
                    }
                }
                if (typeDef.getAllowedTargetTypes() != null) {
                    for (CMISTypeDefinition definition : typeDef.getAllowedTargetTypes()) {
                        relationshipDefinitionType.getAllowedTargetTypes().add(definition.getTypeId().getId());
                    }
                }
                result = relationshipDefinitionType;
                break;
            }
            case UNKNOWN: {
                throw ExceptionUtil.createCmisException("Unknown CMIS Type", EnumServiceException.INVALID_ARGUMENT);
            }
        }
        if (null != typeDef.getParentType() && null != typeDef.getParentType().getTypeId()) {
            result.setParentId(typeDef.getParentType().getTypeId().getId());
        }
        this.setCmisTypeDefinitionProperties(result, typeDef, includeProperties);
        return result;
    }

    @Override
    public List<CmisRepositoryEntryType> getRepositories(CmisExtensionType extension) throws CmisException {
        CmisRepositoryEntryType repositoryEntryType = new CmisRepositoryEntryType();
        Descriptor serverDescriptor = this.descriptorService.getCurrentRepositoryDescriptor();
        repositoryEntryType.setRepositoryId(serverDescriptor.getId());
        repositoryEntryType.setRepositoryName(serverDescriptor.getName());
        LinkedList<CmisRepositoryEntryType> result = new LinkedList<CmisRepositoryEntryType>();
        result.add(repositoryEntryType);
        return result;
    }

    @Override
    public CmisRepositoryInfoType getRepositoryInfo(String repositoryId, CmisExtensionType extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        Descriptor currentDescriptor = this.descriptorService.getCurrentRepositoryDescriptor();
        Descriptor serverDescriptor = this.descriptorService.getServerDescriptor();
        CmisRepositoryInfoType repositoryInfoType = new CmisRepositoryInfoType();
        repositoryInfoType.setRepositoryId(currentDescriptor.getId());
        repositoryInfoType.setRepositoryName(currentDescriptor.getName());
        repositoryInfoType.setRepositoryDescription("");
        repositoryInfoType.setVendorName("Alfresco");
        repositoryInfoType.setProductName("Alfresco Repository (" + serverDescriptor.getEdition() + ")");
        repositoryInfoType.setProductVersion(currentDescriptor.getVersion());
        try {
            repositoryInfoType.setRootFolderId(this.propertiesUtil.getProperty(this.cmisService.getDefaultRootNodeRef(), "cmis:objectId", null));
        }
        catch (CMISInvalidArgumentException e) {
            throw ExceptionUtil.createCmisException((CMISServiceException)((Object)e));
        }
        repositoryInfoType.setLatestChangeLogToken(this.cmisChangeLogService.getLastChangeLogToken());
        repositoryInfoType.setCmisVersionSupported("1.0");
        repositoryInfoType.setChangesIncomplete(this.cmisChangeLogService.getChangesIncomplete());
        List changesOnTypeCapability = this.cmisChangeLogService.getChangesOnTypeCapability();
        for (CMISBaseObjectTypeIds baseId : changesOnTypeCapability) {
            repositoryInfoType.getChangesOnType().add(BASE_IDS_TYPE_ENUM_MAPPING.get(baseId));
        }
        repositoryInfoType.setPrincipalAnonymous(this.cmisAclService.getPrincipalAnonymous());
        repositoryInfoType.setPrincipalAnyone(this.cmisAclService.getPrincipalAnyone());
        CmisACLCapabilityType aclCapability = new CmisACLCapabilityType();
        aclCapability.setSupportedPermissions(ACL_SUPPORTED_PERMISSION_ENUM_MAPPING.get(this.cmisAclService.getSupportedPermissions()));
        aclCapability.setPropagation(ACL_PROPAGATION_ENUM_MAPPGIN.get(this.cmisAclService.getAclPropagation()));
        aclCapability.getMapping().addAll(this.getPermissionMapping());
        aclCapability.getPermissions().addAll(this.getPermissionDefinitions());
        repositoryInfoType.setAclCapability(aclCapability);
        CmisRepositoryCapabilitiesType capabilities = new CmisRepositoryCapabilitiesType();
        capabilities.setCapabilityGetDescendants(true);
        capabilities.setCapabilityGetFolderTree(true);
        capabilities.setCapabilityContentStreamUpdatability(EnumCapabilityContentStreamUpdates.ANYTIME);
        capabilities.setCapabilityChanges(CHANGES_TYPE_ENUM_MAPPING.get(this.cmisChangeLogService.getCapability()));
        capabilities.setCapabilityRenditions(EnumCapabilityRendition.READ);
        capabilities.setCapabilityMultifiling(true);
        capabilities.setCapabilityUnfiling(false);
        capabilities.setCapabilityVersionSpecificFiling(false);
        capabilities.setCapabilityPWCUpdatable(true);
        capabilities.setCapabilityPWCSearchable(this.cmisQueryService.getPwcSearchable());
        capabilities.setCapabilityAllVersionsSearchable(this.cmisQueryService.getAllVersionsSearchable());
        capabilities.setCapabilityQuery(QUERY_TYPE_ENUM_MAPPING.get(this.cmisQueryService.getQuerySupport()));
        capabilities.setCapabilityJoin(JOIN_ENUM_MAPPING.get(this.cmisQueryService.getJoinSupport()));
        capabilities.setCapabilityACL(ACL_CAPABILITY_ENUM_MAPPING.get(this.cmisAclService.getAclCapability()));
        repositoryInfoType.setCapabilities(capabilities);
        return repositoryInfoType;
    }

    private List<CmisPermissionDefinition> getPermissionDefinitions() {
        if (null == this.permissionDefinitions) {
            this.permissionDefinitions = new LinkedList<CmisPermissionDefinition>();
            for (CMISPermissionDefinition definition : this.cmisAclService.getRepositoryPermissions()) {
                CmisPermissionDefinition cmisDefinition = new CmisPermissionDefinition();
                cmisDefinition.setDescription(definition.getDescription());
                cmisDefinition.setPermission(definition.getPermission());
                this.permissionDefinitions.add(cmisDefinition);
            }
        }
        return this.permissionDefinitions;
    }

    private List<CmisPermissionMapping> getPermissionMapping() {
        if (null == this.permissionMapping) {
            this.permissionMapping = new LinkedList<CmisPermissionMapping>();
            for (CMISPermissionMapping mapping : this.cmisAclService.getPermissionMappings()) {
                CmisPermissionMapping cmisMapping = new CmisPermissionMapping();
                cmisMapping.getPermission().addAll(mapping.getPermissions());
                cmisMapping.setKey(EnumAllowableActionsKey.fromValue(mapping.getKey()));
                this.permissionMapping.add(cmisMapping);
            }
        }
        return this.permissionMapping;
    }

    @Override
    public CmisTypeDefinitionListType getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        Collection typeDefs;
        this.checkRepositoryId(repositoryId);
        try {
            typeDefs = typeId == null ? this.cmisService.getBaseTypes() : this.cmisService.getTypeDefinition(typeId).getSubTypes(false);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        Cursor cursor = this.createCursor(typeDefs.size(), skipCount, maxItems);
        Iterator iterTypeDefs = typeDefs.iterator();
        for (int i = 0; i < cursor.getStartRow(); ++i) {
            iterTypeDefs.next();
        }
        boolean includePropertyDefinitionsVal = includePropertyDefinitions == null ? false : includePropertyDefinitions;
        CmisTypeDefinitionListType result = new CmisTypeDefinitionListType();
        for (int i = cursor.getStartRow(); i <= cursor.getEndRow(); ++i) {
            CmisTypeDefinitionType element = this.getCmisTypeDefinition((CMISTypeDefinition)iterTypeDefs.next(), includePropertyDefinitionsVal);
            if (null == element) {
                throw ExceptionUtil.createCmisException("Subtypes collection is corrupted. Type id: " + typeId, EnumServiceException.STORAGE);
            }
            result.getTypes().add(element);
        }
        result.setHasMoreItems(maxItems == null || 0 == maxItems.intValue() ? false : cursor.getEndRow() < typeDefs.size() - 1);
        result.setNumItems(BigInteger.valueOf(result.getTypes().size()));
        return result;
    }

    @Override
    public CmisTypeDefinitionType getTypeDefinition(String repositoryId, String typeId, CmisExtensionType extension) throws CmisException {
        CMISTypeDefinition typeDef;
        this.checkRepositoryId(repositoryId);
        try {
            typeDef = this.cmisService.getTypeDefinition(typeId);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        return this.getCmisTypeDefinition(typeDef, true);
    }

    @Override
    public List<CmisTypeContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, CmisExtensionType extension) throws CmisException {
        CMISTypeDefinition typeDef;
        long depthLong;
        this.checkRepositoryId(repositoryId);
        long l = depthLong = null == depth || null == typeId ? -1L : depth.longValue();
        if (0L == depthLong) {
            throw ExceptionUtil.createCmisException("Invalid depth '0'", EnumServiceException.INVALID_ARGUMENT);
        }
        try {
            typeDef = typeId == null ? null : this.cmisService.getTypeDefinition(typeId);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        LinkedList<CmisTypeContainer> result = new LinkedList<CmisTypeContainer>();
        this.getTypeDescendants(typeDef, result, includePropertyDefinitions != null && includePropertyDefinitions != false, 1L, depthLong);
        return result;
    }

    private void getTypeDescendants(CMISTypeDefinition parent, List<CmisTypeContainer> result, boolean includePropertyDefs, long depth, long maxDepth) throws CmisException {
        Collection subtypes = parent == null ? this.cmisService.getBaseTypes() : parent.getSubTypes(false);
        for (CMISTypeDefinition subtype : subtypes) {
            CmisTypeContainer type = this.createTypeContainer(subtype, includePropertyDefs);
            result.add(type);
            if (maxDepth != -1L && depth >= maxDepth) continue;
            List<CmisTypeContainer> children = type.getChildren();
            this.getTypeDescendants(subtype, children, includePropertyDefs, depth + 1L, maxDepth);
        }
    }

    private CmisTypeContainer createTypeContainer(CMISTypeDefinition parentType, boolean includeProperties) throws CmisException {
        CmisTypeContainer result = new CmisTypeContainer();
        result.setType(this.getCmisTypeDefinition(parentType, includeProperties));
        return result;
    }

    static {
        JOIN_ENUM_MAPPING.put(CMISJoinEnum.INNER_AND_OUTER_JOIN_SUPPORT, EnumCapabilityJoin.INNERANDOUTER);
        JOIN_ENUM_MAPPING.put(CMISJoinEnum.INNER_JOIN_SUPPORT, EnumCapabilityJoin.INNERONLY);
        JOIN_ENUM_MAPPING.put(CMISJoinEnum.NO_JOIN_SUPPORT, EnumCapabilityJoin.NONE);
        CONTENT_STREAM_ALLOWED_ENUM_MAPPING = new HashMap<CMISContentStreamAllowedEnum, EnumContentStreamAllowed>();
        CONTENT_STREAM_ALLOWED_ENUM_MAPPING.put(CMISContentStreamAllowedEnum.ALLOWED, EnumContentStreamAllowed.ALLOWED);
        CONTENT_STREAM_ALLOWED_ENUM_MAPPING.put(CMISContentStreamAllowedEnum.NOT_ALLOWED, EnumContentStreamAllowed.NOTALLOWED);
        CONTENT_STREAM_ALLOWED_ENUM_MAPPING.put(CMISContentStreamAllowedEnum.REQUIRED, EnumContentStreamAllowed.REQUIRED);
        UPDATABILITY_ENUM_MAPPING = new HashMap<CMISUpdatabilityEnum, EnumUpdatability>();
        UPDATABILITY_ENUM_MAPPING.put(CMISUpdatabilityEnum.READ_AND_WRITE, EnumUpdatability.READWRITE);
        UPDATABILITY_ENUM_MAPPING.put(CMISUpdatabilityEnum.READ_AND_WRITE_WHEN_CHECKED_OUT, EnumUpdatability.WHENCHECKEDOUT);
        UPDATABILITY_ENUM_MAPPING.put(CMISUpdatabilityEnum.READ_ONLY, EnumUpdatability.READONLY);
        UPDATABILITY_ENUM_MAPPING.put(CMISUpdatabilityEnum.ON_CREATE, EnumUpdatability.ONCREATE);
        CARDINALITY_ENUM_MAPPING = new HashMap<CMISCardinalityEnum, EnumCardinality>();
        CARDINALITY_ENUM_MAPPING.put(CMISCardinalityEnum.MULTI_VALUED, EnumCardinality.MULTI);
        CARDINALITY_ENUM_MAPPING.put(CMISCardinalityEnum.SINGLE_VALUED, EnumCardinality.SINGLE);
        PROPERTY_TYPE_ENUM_MAPPING = new HashMap<CMISDataTypeEnum, EnumPropertyType>();
        PROPERTY_TYPE_ENUM_MAPPING.put(CMISDataTypeEnum.BOOLEAN, EnumPropertyType.BOOLEAN);
        PROPERTY_TYPE_ENUM_MAPPING.put(CMISDataTypeEnum.DATETIME, EnumPropertyType.DATETIME);
        PROPERTY_TYPE_ENUM_MAPPING.put(CMISDataTypeEnum.DECIMAL, EnumPropertyType.DECIMAL);
        PROPERTY_TYPE_ENUM_MAPPING.put(CMISDataTypeEnum.HTML, EnumPropertyType.HTML);
        PROPERTY_TYPE_ENUM_MAPPING.put(CMISDataTypeEnum.ID, EnumPropertyType.ID);
        PROPERTY_TYPE_ENUM_MAPPING.put(CMISDataTypeEnum.INTEGER, EnumPropertyType.INTEGER);
        PROPERTY_TYPE_ENUM_MAPPING.put(CMISDataTypeEnum.STRING, EnumPropertyType.STRING);
        PROPERTY_TYPE_ENUM_MAPPING.put(CMISDataTypeEnum.URI, EnumPropertyType.URI);
        QUERY_TYPE_ENUM_MAPPING = new HashMap<CMISQueryEnum, EnumCapabilityQuery>();
        QUERY_TYPE_ENUM_MAPPING.put(CMISQueryEnum.BOTH_COMBINED, EnumCapabilityQuery.BOTHCOMBINED);
        QUERY_TYPE_ENUM_MAPPING.put(CMISQueryEnum.BOTH_SEPERATE, EnumCapabilityQuery.BOTHSEPARATE);
        QUERY_TYPE_ENUM_MAPPING.put(CMISQueryEnum.FULLTEXT_ONLY, EnumCapabilityQuery.FULLTEXTONLY);
        QUERY_TYPE_ENUM_MAPPING.put(CMISQueryEnum.METADATA_ONLY, EnumCapabilityQuery.METADATAONLY);
        QUERY_TYPE_ENUM_MAPPING.put(CMISQueryEnum.NONE, EnumCapabilityQuery.NONE);
        CHANGES_TYPE_ENUM_MAPPING = new HashMap<CMISCapabilityChanges, EnumCapabilityChanges>();
        CHANGES_TYPE_ENUM_MAPPING.put(CMISCapabilityChanges.NONE, EnumCapabilityChanges.NONE);
        CHANGES_TYPE_ENUM_MAPPING.put(CMISCapabilityChanges.OBJECTIDSONLY, EnumCapabilityChanges.OBJECTIDSONLY);
        BASE_IDS_TYPE_ENUM_MAPPING = new HashMap<CMISBaseObjectTypeIds, EnumBaseObjectTypeIds>();
        BASE_IDS_TYPE_ENUM_MAPPING.put(CMISBaseObjectTypeIds.DOCUMENT, EnumBaseObjectTypeIds.CMIS_DOCUMENT);
        BASE_IDS_TYPE_ENUM_MAPPING.put(CMISBaseObjectTypeIds.FOLDER, EnumBaseObjectTypeIds.CMIS_FOLDER);
        BASE_IDS_TYPE_ENUM_MAPPING.put(CMISBaseObjectTypeIds.RELATIONSHIP, EnumBaseObjectTypeIds.CMIS_RELATIONSHIP);
        BASE_IDS_TYPE_ENUM_MAPPING.put(CMISBaseObjectTypeIds.POLICY, EnumBaseObjectTypeIds.CMIS_POLICY);
        ACL_CAPABILITY_ENUM_MAPPING = new HashMap<CMISAclCapabilityEnum, EnumCapabilityACL>();
        ACL_CAPABILITY_ENUM_MAPPING.put(CMISAclCapabilityEnum.DISCOVER, EnumCapabilityACL.DISCOVER);
        ACL_CAPABILITY_ENUM_MAPPING.put(CMISAclCapabilityEnum.MANAGE, EnumCapabilityACL.MANAGE);
        ACL_CAPABILITY_ENUM_MAPPING.put(CMISAclCapabilityEnum.NONE, EnumCapabilityACL.NONE);
        ACL_PROPAGATION_ENUM_MAPPGIN = new HashMap<CMISAclPropagationEnum, EnumACLPropagation>();
        ACL_PROPAGATION_ENUM_MAPPGIN.put(CMISAclPropagationEnum.OBJECT_ONLY, EnumACLPropagation.OBJECTONLY);
        ACL_PROPAGATION_ENUM_MAPPGIN.put(CMISAclPropagationEnum.PROPAGATE, EnumACLPropagation.PROPAGATE);
        ACL_PROPAGATION_ENUM_MAPPGIN.put(CMISAclPropagationEnum.REPOSITORY_DETERMINED, EnumACLPropagation.REPOSITORYDETERMINED);
        ACL_SUPPORTED_PERMISSION_ENUM_MAPPING = new HashMap<CMISAclSupportedPermissionEnum, EnumSupportedPermissions>();
        ACL_SUPPORTED_PERMISSION_ENUM_MAPPING.put(CMISAclSupportedPermissionEnum.BASIC, EnumSupportedPermissions.BASIC);
        ACL_SUPPORTED_PERMISSION_ENUM_MAPPING.put(CMISAclSupportedPermissionEnum.REPOSITORY, EnumSupportedPermissions.REPOSITORY);
        ACL_SUPPORTED_PERMISSION_ENUM_MAPPING.put(CMISAclSupportedPermissionEnum.BOTH, EnumSupportedPermissions.BOTH);
    }
}

