/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws;

import org.alfresco.repo.cmis.ws.CmisException;
import org.alfresco.repo.cmis.ws.utils.ExceptionUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.ThrowsAdvice;

public class DMServicePortThrowsAdvice
implements ThrowsAdvice {
    private static final Log LOGGER = LogFactory.getLog((String)"org.alfresco.repo.cmis.ws");

    public void afterThrowing(AccessDeniedException e) throws CmisException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.error((Object)e.toString(), (Throwable)e);
        }
        throw ExceptionUtil.createCmisException("Access denied. Message: " + e.toString(), (Throwable)e);
    }

    public void afterThrowing(RuntimeException e) throws CmisException {
        Throwable result = e;
        if (null != e.getCause()) {
            result = e.getCause();
        }
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error((Object)result.toString(), result);
        }
        throw result instanceof CmisException ? (CmisException)result : ExceptionUtil.createCmisException("Runtime error. Message: " + result.toString(), result);
    }

    public void afterThrowing(Exception e) throws CmisException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.error((Object)e.toString(), (Throwable)e);
        }
        if (!(e instanceof CmisException)) {
            throw ExceptionUtil.createCmisException("Some error occured during last service invokation. Message: " + e.toString(), e);
        }
        throw (CmisException)e;
    }
}

