/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws.test;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.ws.Holder;
import junit.framework.TestCase;
import org.alfresco.repo.cmis.ws.CmisException;
import org.alfresco.repo.cmis.ws.CmisExtensionType;
import org.alfresco.repo.cmis.ws.CmisPropertiesType;
import org.alfresco.repo.cmis.ws.CmisPropertyId;
import org.alfresco.repo.cmis.ws.CmisPropertyString;
import org.alfresco.repo.cmis.ws.ObjectServicePort;
import org.alfresco.repo.cmis.ws.PolicyServicePort;
import org.alfresco.repo.cmis.ws.RepositoryServicePort;
import org.alfresco.repo.cmis.ws.VersioningServicePort;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.Assert;
import org.springframework.context.ApplicationContext;

public abstract class BaseCMISTest
extends TestCase {
    protected RepositoryServicePort repositoryServicePort;
    protected ObjectServicePort objectServicePort;
    protected VersioningServicePort versioningServicePort;
    protected PolicyServicePort policyServicePort;
    protected String defaultRunAs = "admin";
    protected String repositoryId;
    protected String testFolderId;
    protected ApplicationContext ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{ApplicationContextHelper.CONFIG_LOCATIONS[0], "classpath:alfresco/web-services-application-context.xml"});

    public BaseCMISTest() {
        this.repositoryServicePort = (RepositoryServicePort)this.ctx.getBean("dmRepositoryService");
        this.objectServicePort = (ObjectServicePort)this.ctx.getBean("dmObjectService");
        this.versioningServicePort = (VersioningServicePort)this.ctx.getBean("dmVersioningService");
        this.policyServicePort = (PolicyServicePort)this.ctx.getBean("dmPolicyService");
        try {
            this.repositoryId = this.repositoryServicePort.getRepositories(null).get(0).getRepositoryId();
        }
        catch (CmisException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDefaultRunAs(String defaultRunAs) {
        this.defaultRunAs = defaultRunAs;
    }

    protected void setUp() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.defaultRunAs);
        String rootFolderId = this.repositoryServicePort.getRepositoryInfo(this.repositoryId, null).getRootFolderId();
        Holder objectId = new Holder();
        String folderName = ((Object)((Object)this)).getClass().getSimpleName() + System.currentTimeMillis() + " - " + this.getName();
        this.objectServicePort.createFolder(this.repositoryId, this.createObjectProperties(folderName, "cmis:folder"), rootFolderId, null, null, null, (Holder<CmisExtensionType>)new Holder(), (Holder<String>)objectId);
        this.testFolderId = (String)objectId.value;
    }

    protected void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    protected CmisPropertiesType createObjectProperties(String name, String type) {
        CmisPropertiesType properties = new CmisPropertiesType();
        CmisPropertyString stringProperty = new CmisPropertyString();
        stringProperty.setPropertyDefinitionId("cmis:name");
        stringProperty.getValue().add(name);
        properties.getProperty().add(stringProperty);
        CmisPropertyId idProperty = new CmisPropertyId();
        idProperty.setPropertyDefinitionId("cmis:objectTypeId");
        idProperty.getValue().add(type);
        properties.getProperty().add(idProperty);
        return properties;
    }

    protected void setStringProperty(CmisPropertiesType properties, String id, String value) {
        CmisPropertyString stringProperty = new CmisPropertyString();
        properties.getProperty().add(stringProperty);
        stringProperty.setPropertyDefinitionId(id);
        stringProperty.getValue().add(value);
    }

    protected void assertContains(Set<String> actual, String ... expected) {
        Assert.assertTrue((boolean)actual.containsAll(Arrays.asList(expected)));
    }

    protected void assertDoesNotContain(Set<String> actual, String ... unexpected) {
        HashSet<String> copy = new HashSet<String>(actual);
        copy.retainAll(Arrays.asList(unexpected));
        Assert.assertTrue((boolean)copy.isEmpty());
    }
}

