/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws.test;

import java.math.BigInteger;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.ws.Holder;
import org.alfresco.cmis.CMISDictionaryModel;
import org.alfresco.repo.cmis.ws.CmisContentStreamType;
import org.alfresco.repo.cmis.ws.CmisException;
import org.alfresco.repo.cmis.ws.CmisExtensionType;
import org.alfresco.repo.cmis.ws.CmisObjectInFolderListType;
import org.alfresco.repo.cmis.ws.CmisObjectInFolderType;
import org.alfresco.repo.cmis.ws.CmisObjectType;
import org.alfresco.repo.cmis.ws.CmisPropertiesType;
import org.alfresco.repo.cmis.ws.CmisProperty;
import org.alfresco.repo.cmis.ws.CmisPropertyId;
import org.alfresco.repo.cmis.ws.CmisPropertyString;
import org.alfresco.repo.cmis.ws.DiscoveryServicePort;
import org.alfresco.repo.cmis.ws.EnumVersioningState;
import org.alfresco.repo.cmis.ws.NavigationServicePort;
import org.alfresco.repo.cmis.ws.ObjectFactory;
import org.alfresco.repo.cmis.ws.Query;
import org.alfresco.repo.cmis.ws.QueryResponse;
import org.alfresco.repo.cmis.ws.test.BaseCMISTest;

public class QueryPagingTest
extends BaseCMISTest {
    private static final int NUMBER_OF_DOCUMENTS = 50;
    private static final String QUERY_DOCUMENTS_TEMPLATE = "select * from cmis:document d where in_folder('%1$s')";
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private String queryDocuments;
    protected DiscoveryServicePort discoveryServicePort;
    protected NavigationServicePort navigationServicePort;

    public QueryPagingTest() {
        this.discoveryServicePort = (DiscoveryServicePort)this.ctx.getBean("dmDiscoveryService");
        this.navigationServicePort = (NavigationServicePort)this.ctx.getBean("dmNavigationService");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.queryDocuments = String.format(QUERY_DOCUMENTS_TEMPLATE, this.testFolderId);
    }

    public void testPagingSupport() throws Exception {
        this.clearDocumentsInFolder(this.testFolderId);
        this.createDocumentsInFolder(this.testFolderId, 50);
        int skipCount = 0;
        int maxItems = 10;
        QueryResponse response = this.discoveryServicePort.query(this.createQuery(maxItems, skipCount));
        QueryPagingTest.assertEquals((int)(50 - skipCount), (int)response.getObjects().getNumItems().intValue());
        QueryPagingTest.assertEquals((int)maxItems, (int)response.getObjects().getObjects().size());
        QueryPagingTest.assertTrue((boolean)response.getObjects().isHasMoreItems());
        skipCount = 10;
        maxItems = 10;
        response = this.discoveryServicePort.query(this.createQuery(maxItems, skipCount));
        QueryPagingTest.assertEquals((int)(50 - skipCount), (int)response.getObjects().getNumItems().intValue());
        QueryPagingTest.assertEquals((int)maxItems, (int)response.getObjects().getObjects().size());
        QueryPagingTest.assertTrue((boolean)response.getObjects().isHasMoreItems());
        skipCount = 40;
        maxItems = 10;
        response = this.discoveryServicePort.query(this.createQuery(maxItems, skipCount));
        QueryPagingTest.assertEquals((int)(50 - skipCount), (int)response.getObjects().getNumItems().intValue());
        QueryPagingTest.assertEquals((int)maxItems, (int)response.getObjects().getObjects().size());
        QueryPagingTest.assertFalse((boolean)response.getObjects().isHasMoreItems());
        skipCount = 0;
        maxItems = 50;
        response = this.discoveryServicePort.query(this.createQuery(maxItems, skipCount));
        QueryPagingTest.assertEquals((int)(50 - skipCount), (int)response.getObjects().getNumItems().intValue());
        QueryPagingTest.assertEquals((int)maxItems, (int)response.getObjects().getObjects().size());
        QueryPagingTest.assertFalse((boolean)response.getObjects().isHasMoreItems());
        this.clearDocumentsInFolder(this.testFolderId);
    }

    protected void createDocumentsInFolder(String folderId, int docsCount) throws Exception {
        for (int i = 0; i < 50; ++i) {
            String docName = "Test Document " + i + ".txt";
            this.createDocument(docName, folderId);
        }
    }

    protected void clearDocumentsInFolder(String folderId) throws CmisException {
        CmisObjectInFolderListType result = this.navigationServicePort.getChildren(this.repositoryId, this.testFolderId, "*", null, false, null, null, false, BigInteger.valueOf(-1L), BigInteger.ZERO, null);
        if (!result.getObjects().isEmpty()) {
            for (CmisObjectInFolderType obj : result.getObjects()) {
                String documentId = this.getObjectId(obj.getObject());
                this.objectServicePort.deleteObject(this.repositoryId, documentId, true, (Holder<CmisExtensionType>)new Holder());
            }
        }
    }

    protected String getObjectId(CmisObjectType object) {
        CmisPropertiesType propertiesType = object.getProperties();
        for (CmisProperty property : propertiesType.getProperty()) {
            if (!(property instanceof CmisPropertyId) || !"cmis:objectId".equals(property.getPropertyDefinitionId())) continue;
            return ((CmisPropertyId)property).getValue().iterator().next();
        }
        return null;
    }

    protected String createDocument(String name, String parentFolderId) throws Exception {
        String content = "This is a test content";
        CmisPropertiesType properties = new CmisPropertiesType();
        List<CmisProperty> propertiesList = properties.getProperty();
        CmisPropertyString cmisProperty = new CmisPropertyString();
        cmisProperty.setPropertyDefinitionId("cmis:name");
        cmisProperty.getValue().add(name);
        CmisPropertyId idProperty = new CmisPropertyId();
        idProperty.setPropertyDefinitionId("cmis:objectTypeId");
        idProperty.getValue().add(CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        propertiesList.add(cmisProperty);
        propertiesList.add(idProperty);
        CmisContentStreamType cmisStream = new CmisContentStreamType();
        cmisStream.setFilename(name);
        cmisStream.setMimeType("text/plain");
        DataHandler dataHandler = new DataHandler((Object)content, "text/plain");
        cmisStream.setStream(dataHandler);
        Holder extensions = new Holder();
        Holder idHolder = new Holder();
        this.objectServicePort.createDocument(this.repositoryId, properties, parentFolderId, cmisStream, EnumVersioningState.MAJOR, null, null, null, (Holder<CmisExtensionType>)extensions, (Holder<String>)idHolder);
        return (String)idHolder.value;
    }

    private Query createQuery(int maxItems, int skipCount) {
        Query parameters = new Query();
        parameters.setRepositoryId(this.repositoryId);
        parameters.setStatement(this.queryDocuments);
        parameters.setSkipCount(OBJECT_FACTORY.createQuerySkipCount(BigInteger.valueOf(skipCount)));
        parameters.setMaxItems(OBJECT_FACTORY.createQueryMaxItems(BigInteger.valueOf(maxItems)));
        parameters.setIncludeAllowableActions(OBJECT_FACTORY.createQueryIncludeAllowableActions(Boolean.FALSE));
        parameters.setSearchAllVersions(OBJECT_FACTORY.createQuerySearchAllVersions(Boolean.FALSE));
        return parameters;
    }
}

