/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws.utils;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.cmis.CMISQueryException;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.repo.cmis.ws.CmisException;
import org.alfresco.repo.cmis.ws.CmisFaultType;
import org.alfresco.repo.cmis.ws.EnumServiceException;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;

public abstract class ExceptionUtil {
    private static final Map<String, EnumServiceException> CLASS_TO_ENUM_EXCEPTION_MAPPING = new HashMap<String, EnumServiceException>();

    public static CmisException createCmisException(String message, EnumServiceException exceptionType) {
        return ExceptionUtil.createCmisException(message, exceptionType, null, 0);
    }

    public static CmisException createCmisException(String message, Throwable cause) {
        EnumServiceException exceptionType = null;
        if (cause instanceof CMISServiceException) {
            return ExceptionUtil.createCmisException((CMISServiceException)cause);
        }
        if (CLASS_TO_ENUM_EXCEPTION_MAPPING.containsKey(cause.getClass().getName())) {
            exceptionType = CLASS_TO_ENUM_EXCEPTION_MAPPING.get(cause.getClass().getName());
        }
        exceptionType = exceptionType == null ? EnumServiceException.RUNTIME : exceptionType;
        return ExceptionUtil.createCmisException(message, exceptionType, cause, 0);
    }

    public static CmisException createCmisException(String message, EnumServiceException exceptionType, Throwable cause) {
        return ExceptionUtil.createCmisException(message, exceptionType, cause, 0);
    }

    public static CmisException createCmisException(CMISServiceException exception) {
        return ExceptionUtil.createCmisException(exception.getMessage(), EnumServiceException.fromValue(exception.getFaultName()), exception, exception.getStatusCode());
    }

    public static CmisException createCmisException(String message, EnumServiceException exceptionType, Throwable cause, int errorCode) {
        CmisFaultType fault = new CmisFaultType();
        fault.setMessage(message);
        fault.setType(exceptionType);
        fault.setCode(BigInteger.valueOf(errorCode));
        return new CmisException(message, fault, cause);
    }

    static {
        CLASS_TO_ENUM_EXCEPTION_MAPPING.put(AccessDeniedException.class.getName(), EnumServiceException.PERMISSION_DENIED);
        CLASS_TO_ENUM_EXCEPTION_MAPPING.put(RuntimeException.class.getName(), EnumServiceException.RUNTIME);
        CLASS_TO_ENUM_EXCEPTION_MAPPING.put(UnsupportedOperationException.class.getName(), EnumServiceException.NOT_SUPPORTED);
        CLASS_TO_ENUM_EXCEPTION_MAPPING.put(InvalidNodeRefException.class.getName(), EnumServiceException.INVALID_ARGUMENT);
        CLASS_TO_ENUM_EXCEPTION_MAPPING.put(ContentIOException.class.getName(), EnumServiceException.NOT_SUPPORTED);
        CLASS_TO_ENUM_EXCEPTION_MAPPING.put(CMISQueryException.class.getName(), EnumServiceException.INVALID_ARGUMENT);
        CLASS_TO_ENUM_EXCEPTION_MAPPING.put(FileExistsException.class.getName(), EnumServiceException.NAME_CONSTRAINT_VIOLATION);
    }
}

