/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remoteticket;

import java.util.Map;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.remoteconnector.LocalWebScriptConnectorServiceImpl;
import org.alfresco.repo.remotecredentials.PasswordCredentialsInfoImpl;
import org.alfresco.repo.remoteticket.RemoteAlfrescoTicketServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorService;
import org.alfresco.service.cmr.remotecredentials.BaseCredentialsInfo;
import org.alfresco.service.cmr.remotecredentials.RemoteCredentialsService;
import org.alfresco.service.cmr.remoteticket.NoCredentialsFoundException;
import org.alfresco.service.cmr.remoteticket.NoSuchSystemException;
import org.alfresco.service.cmr.remoteticket.RemoteAlfrescoTicketInfo;
import org.alfresco.service.cmr.remoteticket.RemoteAlfrescoTicketService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;

public class RemoteAlfrescoTicketServiceTest
extends BaseWebScriptTest {
    private static final String TEST_REMOTE_SYSTEM_ID = "testingRemoteSystem";
    private static final String INVALID_REMOTE_SYSTEM_ID = "testingInvalidRemoteSystem";
    private MutableAuthenticationService authenticationService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private PersonService personService;
    private RemoteAlfrescoTicketService remoteAlfrescoTicketService;
    private RemoteCredentialsService remoteCredentialsService;
    private SimpleCache<String, String> ticketsCache;
    private static final String USER_ONE = "UserOneSecondToo";
    private static final String USER_TWO = "UserTwoSecondToo";
    private static final String PASSWORD = "passwordTEST";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.retryingTransactionHelper = (RetryingTransactionHelper)this.getServer().getApplicationContext().getBean("retryingTransactionHelper");
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.remoteAlfrescoTicketService = (RemoteAlfrescoTicketService)this.getServer().getApplicationContext().getBean("remoteAlfrescoTicketService");
        this.remoteCredentialsService = (RemoteCredentialsService)this.getServer().getApplicationContext().getBean("RemoteCredentialsService");
        this.ticketsCache = (SimpleCache)this.getServer().getApplicationContext().getBean("remoteAlfrescoTicketService.ticketsCache");
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.remoteAlfrescoTicketService.registerRemoteSystem(TEST_REMOTE_SYSTEM_ID, "http://localhost:8080/alfresco/service/", null);
        ((RemoteAlfrescoTicketServiceImpl)this.remoteAlfrescoTicketService).setRemoteConnectorService((RemoteConnectorService)new LocalWebScriptConnectorServiceImpl(this));
        this.remoteAlfrescoTicketService.registerRemoteSystem(INVALID_REMOTE_SYSTEM_ID, null, null);
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        if (this.personService.personExists(USER_ONE)) {
            this.personService.deletePerson(USER_ONE);
        }
        if (this.authenticationService.authenticationExists(USER_ONE)) {
            this.authenticationService.deleteAuthentication(USER_ONE);
        }
        if (this.personService.personExists(USER_TWO)) {
            this.personService.deletePerson(USER_TWO);
        }
        if (this.authenticationService.authenticationExists(USER_TWO)) {
            this.authenticationService.deleteAuthentication(USER_TWO);
        }
        this.remoteAlfrescoTicketService.registerRemoteSystem(TEST_REMOTE_SYSTEM_ID, null, null);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, PASSWORD.toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"First");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"Last");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
            this.personService.createPerson((Map)personProps);
        }
    }

    public void testGetStoreGetCredentials() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        try {
            this.remoteAlfrescoTicketService.getRemoteCredentials(INVALID_REMOTE_SYSTEM_ID);
            RemoteAlfrescoTicketServiceTest.fail((String)"Shouldn't work for an invalid system");
        }
        catch (NoSuchSystemException e) {
            // empty catch block
        }
        try {
            this.remoteAlfrescoTicketService.storeRemoteCredentials(INVALID_REMOTE_SYSTEM_ID, null, null);
            RemoteAlfrescoTicketServiceTest.fail((String)"Shouldn't work for an invalid system");
        }
        catch (NoSuchSystemException e) {
            // empty catch block
        }
        BaseCredentialsInfo credentials = this.remoteAlfrescoTicketService.getRemoteCredentials(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertEquals(null, (Object)credentials);
        try {
            this.remoteAlfrescoTicketService.storeRemoteCredentials(TEST_REMOTE_SYSTEM_ID, USER_ONE, "invalid");
            RemoteAlfrescoTicketServiceTest.fail((String)"Credentials invalid, shouldn't be allowed");
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        try {
            this.remoteAlfrescoTicketService.storeRemoteCredentials(TEST_REMOTE_SYSTEM_ID, "thisUSERdoesNOTexist", "invalid");
            RemoteAlfrescoTicketServiceTest.fail((String)"Credentials invalid, shouldn't be allowed");
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        credentials = this.remoteAlfrescoTicketService.getRemoteCredentials(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertEquals(null, (Object)credentials);
        credentials = this.remoteAlfrescoTicketService.storeRemoteCredentials(TEST_REMOTE_SYSTEM_ID, USER_ONE, PASSWORD);
        RemoteAlfrescoTicketServiceTest.assertNotNull((Object)credentials);
        RemoteAlfrescoTicketServiceTest.assertEquals((String)TEST_REMOTE_SYSTEM_ID, (String)credentials.getRemoteSystemName());
        RemoteAlfrescoTicketServiceTest.assertEquals((String)USER_ONE, (String)credentials.getRemoteUsername());
        credentials = this.remoteAlfrescoTicketService.getRemoteCredentials(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertNotNull((Object)credentials);
        RemoteAlfrescoTicketServiceTest.assertEquals((String)TEST_REMOTE_SYSTEM_ID, (String)credentials.getRemoteSystemName());
        RemoteAlfrescoTicketServiceTest.assertEquals((String)USER_ONE, (String)credentials.getRemoteUsername());
        credentials = this.remoteAlfrescoTicketService.storeRemoteCredentials(TEST_REMOTE_SYSTEM_ID, USER_TWO, PASSWORD);
        RemoteAlfrescoTicketServiceTest.assertNotNull((Object)credentials);
        RemoteAlfrescoTicketServiceTest.assertEquals((String)TEST_REMOTE_SYSTEM_ID, (String)credentials.getRemoteSystemName());
        RemoteAlfrescoTicketServiceTest.assertEquals((String)USER_TWO, (String)credentials.getRemoteUsername());
        credentials = this.remoteAlfrescoTicketService.getRemoteCredentials(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertNotNull((Object)credentials);
        RemoteAlfrescoTicketServiceTest.assertEquals((String)TEST_REMOTE_SYSTEM_ID, (String)credentials.getRemoteSystemName());
        RemoteAlfrescoTicketServiceTest.assertEquals((String)USER_TWO, (String)credentials.getRemoteUsername());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        credentials = this.remoteAlfrescoTicketService.getRemoteCredentials(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertEquals(null, (Object)credentials);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        credentials = this.remoteAlfrescoTicketService.getRemoteCredentials(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertNotNull((Object)credentials);
        boolean deleted = this.remoteAlfrescoTicketService.deleteRemoteCredentials(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertEquals((boolean)true, (boolean)deleted);
        credentials = this.remoteAlfrescoTicketService.getRemoteCredentials(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertEquals(null, (Object)credentials);
        deleted = this.remoteAlfrescoTicketService.deleteRemoteCredentials(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertEquals((boolean)false, (boolean)deleted);
    }

    public void testGetTicket() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        try {
            this.remoteAlfrescoTicketService.getAlfrescoTicket(INVALID_REMOTE_SYSTEM_ID);
            RemoteAlfrescoTicketServiceTest.fail((String)"Shouldn't work for an invalid system");
        }
        catch (NoSuchSystemException e) {
            // empty catch block
        }
        try {
            this.remoteAlfrescoTicketService.refetchAlfrescoTicket(INVALID_REMOTE_SYSTEM_ID);
            RemoteAlfrescoTicketServiceTest.fail((String)"Shouldn't work for an invalid system");
        }
        catch (NoSuchSystemException e) {
            // empty catch block
        }
        try {
            this.remoteAlfrescoTicketService.getAlfrescoTicket(TEST_REMOTE_SYSTEM_ID);
            RemoteAlfrescoTicketServiceTest.fail((String)"Shouldn't work when no credentials");
        }
        catch (NoCredentialsFoundException e) {
            // empty catch block
        }
        try {
            this.remoteAlfrescoTicketService.refetchAlfrescoTicket(TEST_REMOTE_SYSTEM_ID);
            RemoteAlfrescoTicketServiceTest.fail((String)"Shouldn't work when no credentials");
        }
        catch (NoCredentialsFoundException e) {
            // empty catch block
        }
        this.remoteAlfrescoTicketService.storeRemoteCredentials(TEST_REMOTE_SYSTEM_ID, USER_ONE, PASSWORD);
        RemoteAlfrescoTicketInfo ticket = this.remoteAlfrescoTicketService.getAlfrescoTicket(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertNotNull((Object)ticket);
        RemoteAlfrescoTicketServiceTest.assertNotNull((Object)ticket.getAsUrlParameters());
        RemoteAlfrescoTicketInfo ticket2 = this.remoteAlfrescoTicketService.getAlfrescoTicket(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertNotNull((Object)ticket2);
        RemoteAlfrescoTicketServiceTest.assertEquals((String)ticket.getAsUrlParameters(), (String)ticket2.getAsUrlParameters());
        RemoteAlfrescoTicketInfo ticket3 = this.remoteAlfrescoTicketService.refetchAlfrescoTicket(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertNotNull((Object)ticket3);
        RemoteAlfrescoTicketServiceTest.assertNotSame((Object)ticket.getAsUrlParameters(), (Object)ticket3.getAsUrlParameters());
        RemoteAlfrescoTicketInfo ticket4 = this.remoteAlfrescoTicketService.getAlfrescoTicket(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertNotNull((Object)ticket4);
        RemoteAlfrescoTicketServiceTest.assertEquals((String)ticket3.getAsUrlParameters(), (String)ticket4.getAsUrlParameters());
        this.ticketsCache.clear();
        RemoteAlfrescoTicketInfo ticket5 = this.remoteAlfrescoTicketService.getAlfrescoTicket(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertNotNull((Object)ticket5);
        RemoteAlfrescoTicketServiceTest.assertNotSame((Object)ticket.getAsUrlParameters(), (Object)ticket5.getAsUrlParameters());
        RemoteAlfrescoTicketServiceTest.assertNotSame((Object)ticket3.getAsUrlParameters(), (Object)ticket5.getAsUrlParameters());
        PasswordCredentialsInfoImpl creds = (PasswordCredentialsInfoImpl)this.remoteCredentialsService.getPersonCredentials(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertNotNull((Object)creds);
        creds.setRemotePassword("INVALID");
        this.remoteCredentialsService.updateCredentials((BaseCredentialsInfo)creds);
        RemoteAlfrescoTicketServiceTest.assertEquals((boolean)true, (boolean)creds.getLastAuthenticationSucceeded());
        RemoteAlfrescoTicketInfo ticket6 = this.remoteAlfrescoTicketService.getAlfrescoTicket(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertNotNull((Object)ticket6);
        RemoteAlfrescoTicketServiceTest.assertEquals((String)ticket5.getAsUrlParameters(), (String)ticket6.getAsUrlParameters());
        try {
            this.remoteAlfrescoTicketService.refetchAlfrescoTicket(TEST_REMOTE_SYSTEM_ID);
            RemoteAlfrescoTicketServiceTest.fail((String)"Shouldn't be able to refetch with wrong details");
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        try {
            this.remoteAlfrescoTicketService.getAlfrescoTicket(TEST_REMOTE_SYSTEM_ID);
            RemoteAlfrescoTicketServiceTest.fail((String)"Shouldn't be able to get after refresh with wrong details");
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        creds = (PasswordCredentialsInfoImpl)this.remoteCredentialsService.getPersonCredentials(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertEquals((boolean)false, (boolean)creds.getLastAuthenticationSucceeded());
        creds.setRemotePassword(PASSWORD);
        this.remoteCredentialsService.updateCredentials((BaseCredentialsInfo)creds);
        RemoteAlfrescoTicketInfo ticket7 = this.remoteAlfrescoTicketService.getAlfrescoTicket(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertNotNull((Object)ticket7);
        RemoteAlfrescoTicketServiceTest.assertNotSame((Object)ticket.getAsUrlParameters(), (Object)ticket7.getAsUrlParameters());
        RemoteAlfrescoTicketServiceTest.assertNotSame((Object)ticket3.getAsUrlParameters(), (Object)ticket7.getAsUrlParameters());
        RemoteAlfrescoTicketServiceTest.assertNotSame((Object)ticket5.getAsUrlParameters(), (Object)ticket7.getAsUrlParameters());
        creds = (PasswordCredentialsInfoImpl)this.remoteCredentialsService.getPersonCredentials(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertEquals((boolean)true, (boolean)creds.getLastAuthenticationSucceeded());
        creds.setRemotePassword("INVALID");
        this.remoteCredentialsService.updateCredentials((BaseCredentialsInfo)creds);
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                try {
                    RemoteAlfrescoTicketServiceTest.this.remoteAlfrescoTicketService.refetchAlfrescoTicket(RemoteAlfrescoTicketServiceTest.TEST_REMOTE_SYSTEM_ID);
                    Assert.fail((String)"Shouldn't be able to refetch with wrong details");
                }
                catch (AuthenticationException authenticationException) {
                    // empty catch block
                }
                return null;
            }
        }, true, true);
        creds = (PasswordCredentialsInfoImpl)this.remoteCredentialsService.getPersonCredentials(TEST_REMOTE_SYSTEM_ID);
        RemoteAlfrescoTicketServiceTest.assertEquals((boolean)false, (boolean)creds.getLastAuthenticationSucceeded());
    }
}

