/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVStrategy;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public abstract class DeclarativeSpreadsheetWebScript
extends DeclarativeWebScript {
    public static final String MODEL_CSV = "csv";
    public static final String MODEL_EXCEL = "excel";
    protected DictionaryService dictionaryService;
    protected String filenameBase;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    protected abstract Object identifyResource(String var1, WebScriptRequest var2);

    protected abstract boolean allowHtmlFallback();

    protected abstract List<Pair<QName, Boolean>> buildPropertiesForHeader(Object var1, String var2, WebScriptRequest var3);

    protected abstract void populateBody(Object var1, Workbook var2, Sheet var3, List<QName> var4) throws IOException;

    protected abstract void populateBody(Object var1, CSVPrinter var2, List<QName> var3) throws IOException;

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("success", Boolean.TRUE);
        String format = req.getFormat();
        if (MODEL_CSV.equals(format) || "xls".equals(format) || "xlsx".equals(format) || MODEL_EXCEL.equals(format)) {
            Object resource = this.identifyResource(format, req);
            try {
                this.generateSpreadsheet(resource, format, req, status, model);
                return model;
            }
            catch (IOException e) {
                throw new WebScriptException(400, "Unable to generate template file", (Throwable)e);
            }
        }
        if (this.allowHtmlFallback()) {
            return model;
        }
        throw new WebScriptException("Web Script format '" + format + "' is not supported");
    }

    public void generateSpreadsheet(Object resource, String format, WebScriptRequest req, Status status, Map<String, Object> model) throws IOException {
        Pattern qnameMunger = Pattern.compile("([A-Z][a-z]+)([A-Z].*)");
        List<Pair<QName, Boolean>> propertyDetails = this.buildPropertiesForHeader(resource, format, req);
        String[] headings = new String[propertyDetails.size()];
        String[] descriptions = new String[propertyDetails.size()];
        boolean[] required = new boolean[propertyDetails.size()];
        for (int i = 0; i < headings.length; ++i) {
            Pair<QName, Boolean> property = propertyDetails.get(i);
            if (property == null || property.getFirst() == null) {
                headings[i] = "";
                required[i] = false;
                continue;
            }
            QName column = (QName)property.getFirst();
            required[i] = (Boolean)property.getSecond();
            PropertyDefinition pd = this.dictionaryService.getProperty(column);
            if (pd != null && pd.getTitle() != null) {
                headings[i] = pd.getTitle();
                descriptions[i] = pd.getDescription();
                continue;
            }
            String raw = column.getLocalName();
            Matcher m = qnameMunger.matcher(raw = raw.substring(0, 1).toUpperCase() + raw.substring(1));
            headings[i] = m.matches() ? m.group(1) + " " + m.group(2) : raw;
        }
        ArrayList<QName> properties = new ArrayList<QName>(propertyDetails.size());
        for (Pair<QName, Boolean> p : propertyDetails) {
            QName qn = null;
            if (p != null) {
                qn = (QName)p.getFirst();
            }
            properties.add(qn);
        }
        if (MODEL_CSV.equals(format)) {
            StringWriter sw = new StringWriter();
            CSVPrinter csv = new CSVPrinter((Writer)sw, CSVStrategy.EXCEL_STRATEGY);
            csv.println(headings);
            this.populateBody(resource, csv, properties);
            model.put(MODEL_CSV, sw.toString());
        } else {
            Object wb = "xlsx".equals(format) ? new XSSFWorkbook() : new HSSFWorkbook();
            Sheet sheet = wb.createSheet("Export");
            Row hr = sheet.createRow(0);
            sheet.createFreezePane(0, 1);
            Font fb = wb.createFont();
            fb.setBoldweight((short)700);
            Font fi = wb.createFont();
            fi.setBoldweight((short)700);
            fi.setItalic(true);
            CellStyle csReq = wb.createCellStyle();
            csReq.setFont(fb);
            CellStyle csOpt = wb.createCellStyle();
            csOpt.setFont(fi);
            Drawing draw = null;
            for (int i = 0; i < headings.length; ++i) {
                Cell c = hr.createCell(i);
                c.setCellValue(headings[i]);
                if (required[i]) {
                    c.setCellStyle(csReq);
                } else {
                    c.setCellStyle(csOpt);
                }
                if (headings[i].length() == 0) {
                    sheet.setColumnWidth(i, 750);
                } else {
                    sheet.setColumnWidth(i, 4500);
                }
                if (descriptions[i] == null || descriptions[i].length() <= 0) continue;
                if (draw == null) {
                    draw = sheet.createDrawingPatriarch();
                }
                ClientAnchor ca = wb.getCreationHelper().createClientAnchor();
                ca.setCol1(c.getColumnIndex());
                ca.setCol2(c.getColumnIndex() + 1);
                ca.setRow1(hr.getRowNum());
                ca.setRow2(hr.getRowNum() + 2);
                Comment cmt = draw.createCellComment(ca);
                cmt.setAuthor("");
                cmt.setString(wb.getCreationHelper().createRichTextString(descriptions[i]));
                cmt.setVisible(false);
                c.setCellComment(cmt);
            }
            this.populateBody(resource, (Workbook)wb, sheet, properties);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            wb.write((OutputStream)baos);
            model.put(MODEL_EXCEL, baos.toByteArray());
        }
    }

    protected Map<String, Object> createTemplateParameters(WebScriptRequest req, WebScriptResponse res, Map<String, Object> customParams) {
        Map model = super.createTemplateParameters(req, res, customParams);
        model.put("req", req);
        model.put("res", res);
        model.put("writeExcel", new WriteExcel(res, model, req.getFormat(), this.filenameBase));
        return model;
    }

    public static class WriteExcel {
        private String format;
        private String filenameBase;
        private WebScriptResponse res;
        private Map<String, Object> model;

        private WriteExcel(WebScriptResponse res, Map<String, Object> model, String format, String filenameBase) {
            this.res = res;
            this.model = model;
            this.format = format;
            this.filenameBase = filenameBase;
        }

        public void write() throws IOException {
            String filename = this.filenameBase + "." + this.format;
            if (!DeclarativeSpreadsheetWebScript.MODEL_CSV.equals(this.format)) {
                this.res.reset();
            }
            this.res.addHeader("Content-Disposition", "attachment; filename=" + filename);
            if (DeclarativeSpreadsheetWebScript.MODEL_CSV.equals(this.format)) {
                this.res.getWriter().append((String)this.model.get(DeclarativeSpreadsheetWebScript.MODEL_CSV));
            } else {
                if ("xlsx".equals(this.format)) {
                    this.res.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                } else {
                    this.res.setContentType("application/vnd.ms-excel");
                }
                byte[] excel = (byte[])this.model.get(DeclarativeSpreadsheetWebScript.MODEL_EXCEL);
                this.res.getOutputStream().write(excel);
            }
        }
    }
}

