/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.text.MessageFormat;
import java.util.List;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class ReadOnlyTransactionInGetRestApiTest
extends BaseWebScriptTest {
    private static final String TEST_SITE_NAME = "readOnlyTestSite";
    private static final String URL_GET_SITE_BLOG = "/api/blog/site/readOnlyTestSite/blog";
    private static final String URL_GET_SITE_FORUM_POSTS = "/api/forum/site/readOnlyTestSite/discussions/posts";
    private static final String URL_GET_SITE_LINKS = "/api/links/site/readOnlyTestSite/links?page=1&pageSize=10";
    private static final String URL_GET_SITE_LINK = "/api/links/link/site/readOnlyTestSite/links/123456789";
    private static final String URL_GET_SITE_TAGS = "/api/tagscopes/site/readOnlyTestSite/tags";
    private static final String URL_GET_SITE_DATALISTS = "/slingshot/datalists/lists/site/readOnlyTestSite/dataLists";
    private static final String URL_GET_SITE_WIKI = "/slingshot/wiki/pages/readOnlyTestSite";
    private static final String URL_GET_SITE_WIKI_PAGE = "/slingshot/wiki/page/readOnlyTestSite/AWikiPage";
    private static final String URL_GET_SITE_WIKI_PAGE_VERSION = "/slingshot/wiki/version/readOnlyTestSite/AWikiPage/123456789";
    private static final String URL_GET_DOCLIB_CATEGORYNODE = "/slingshot/doclib/categorynode/node/{0}";
    private static final String URL_GET_DOCLIB_TREENODE = "/slingshot/doclib/treenode/site/readOnlyTestSite/documentLibrary";
    private static final String URL_GET_DOCLIB_NODE = "/slingshot/doclib/node/{0}";
    private static final String URL_GET_DOCLIB2_NODE = "/slingshot/doclib2/node/{0}";
    private static final String URL_GET_DOCLIB_LOCATION = "/slingshot/doclib/node/{0}/location";
    private static final String URL_GET_DOCLIB_DOCLIST = "/slingshot/doclib/doclist/documents/site/readOnlyTestSite/documentLibrary";
    private static final String URL_GET_DOCLIB2_DOCLIST = "/slingshot/doclib2/doclist/documents/site/readOnlyTestSite/documentLibrary";
    private static final String URL_GET_DOCLIB_IMAGES = "/slingshot/doclib/images/site/readOnlyTestSite/documentLibrary";
    private SiteService siteService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private NodeRef testSiteNodeRef;
    private String testSiteNodeRefString;
    private boolean logEnabled = false;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ApplicationContext appContext = this.getServer().getApplicationContext();
        this.siteService = (SiteService)appContext.getBean("SiteService");
        this.nodeService = (NodeService)appContext.getBean("NodeService");
        this.transactionService = (TransactionService)appContext.getBean("TransactionService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        if (this.siteService.getSite(TEST_SITE_NAME) != null) {
            this.siteService.deleteSite(TEST_SITE_NAME);
        }
        SiteInfo siteInfo = this.siteService.createSite("collaboration", TEST_SITE_NAME, "Read Only Test Site", "Test site for ReadOnlyTransactionRestApiTest", SiteVisibility.PUBLIC);
        this.testSiteNodeRef = siteInfo.getNodeRef();
        this.testSiteNodeRefString = this.testSiteNodeRef.toString().replace("://", "/");
        List children = this.nodeService.getChildAssocs(this.testSiteNodeRef);
        ReadOnlyTransactionInGetRestApiTest.assertTrue((String)"The test site should not have any containers", (boolean)children.isEmpty());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ReadOnlyTransactionInGetRestApiTest.this.siteService.deleteSite(ReadOnlyTransactionInGetRestApiTest.TEST_SITE_NAME);
                return null;
            }
        });
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testGetSiteBlog() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_GET_SITE_BLOG), 200);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetSiteForumPosts() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_GET_SITE_FORUM_POSTS), 200);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetSiteLinks() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_GET_SITE_LINKS), 200);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetSiteLink() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_GET_SITE_LINK), 404);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)404, (int)response.getStatus());
    }

    public void testGetSiteTags() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_GET_SITE_TAGS), 200);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetSiteDataLists() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_GET_SITE_DATALISTS), 200);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetSiteWiki() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_GET_SITE_WIKI), 200);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetSiteWikiPage() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_GET_SITE_WIKI_PAGE), 404);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)404, (int)response.getStatus());
    }

    public void testGetSiteWikiPageVersion() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_GET_SITE_WIKI_PAGE_VERSION), 404);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)404, (int)response.getStatus());
    }

    public void testGetDoclibTreeNode() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_GET_DOCLIB_TREENODE), 200);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetDoclibDoclist() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_GET_DOCLIB_DOCLIST), 200);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetDoclib2Doclist() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_GET_DOCLIB2_DOCLIST), 200);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetDoclibImages() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_GET_DOCLIB_IMAGES), 200);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetDoclibCategoryNode() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_GET_DOCLIB_CATEGORYNODE, this.testSiteNodeRefString)), 200);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetDoclibNode() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_GET_DOCLIB_NODE, this.testSiteNodeRefString)), 200);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetDoclib2Node() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_GET_DOCLIB2_NODE, this.testSiteNodeRefString)), 200);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetDoclibNodeLocation() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_GET_DOCLIB_LOCATION, this.testSiteNodeRefString)), 200);
        this.logResponse(response);
        ReadOnlyTransactionInGetRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    private void logResponse(TestWebScriptServer.Response response) {
        if (this.logEnabled) {
            try {
                System.out.println(response.getContentAsString());
            }
            catch (Exception e) {
                System.err.println("Unable to log response: " + e.toString());
            }
        }
    }
}

