/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TooBusyException;
import org.alfresco.repo.web.scripts.RepositoryImageResolver;
import org.alfresco.repo.web.scripts.RepositoryServerModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.AbstractRuntimeContainer;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Registry;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.ServerModel;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WrappingWebScriptRequest;
import org.springframework.extensions.webscripts.WrappingWebScriptResponse;
import org.springframework.util.FileCopyUtils;

public class RepositoryContainer
extends AbstractRuntimeContainer
implements TenantDeployer {
    protected static final Log logger = LogFactory.getLog(RepositoryContainer.class);
    private Repository repository;
    private RepositoryImageResolver imageResolver;
    private RetryingTransactionHelper retryingTransactionHelper;
    private RetryingTransactionHelper fallbackTransactionHelper;
    private AuthorityService authorityService;
    private DescriptorService descriptorService;
    private TenantAdminService tenantAdminService;
    private ObjectFactory registryFactory;
    private SimpleCache<String, Registry> webScriptsRegistryCache;
    private ReadWriteLock webScriptsRegistryLock = new ReentrantReadWriteLock();
    private boolean initialized;

    public void setWebScriptsRegistryCache(SimpleCache<String, Registry> webScriptsRegistryCache) {
        this.webScriptsRegistryCache = webScriptsRegistryCache;
    }

    public void setRegistryFactory(ObjectFactory registryFactory) {
        this.registryFactory = registryFactory;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setRepositoryImageResolver(RepositoryImageResolver imageResolver) {
        this.imageResolver = imageResolver;
    }

    public void setTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setFallbackTransactionHelper(RetryingTransactionHelper fallbackTransactionHelper) {
        this.fallbackTransactionHelper = fallbackTransactionHelper;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public ServerModel getDescription() {
        return new RepositoryServerModel(this.descriptorService.getCurrentRepositoryDescriptor(), this.descriptorService.getServerDescriptor());
    }

    public Map<String, Object> getScriptParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(super.getScriptParameters());
        this.addRepoParameters(params);
        return params;
    }

    public Map<String, Object> getTemplateParameters() {
        return (Map)this.fallbackTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Object>>(){

            public Map<String, Object> execute() throws Throwable {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.putAll(RepositoryContainer.super.getTemplateParameters());
                params.put("imageresolver", RepositoryContainer.this.imageResolver.getImageResolver());
                RepositoryContainer.this.addRepoParameters(params);
                return params;
            }
        }, true);
    }

    private void addRepoParameters(Map<String, Object> params) {
        if (AlfrescoTransactionSupport.getTransactionId() != null && AuthenticationUtil.getFullAuthentication() != null) {
            NodeRef person;
            NodeRef companyHome;
            NodeRef rootHome = this.repository.getRootHome();
            if (rootHome != null) {
                params.put("roothome", rootHome);
            }
            if ((companyHome = this.repository.getCompanyHome()) != null) {
                params.put("companyhome", companyHome);
            }
            if ((person = this.repository.getFullyAuthenticatedPerson()) != null) {
                params.put("person", person);
                NodeRef userHome = this.repository.getUserHome(person);
                if (userHome != null) {
                    params.put("userhome", userHome);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeScript(WebScriptRequest scriptReq, WebScriptResponse scriptRes, final Authenticator auth) throws IOException {
        String currentUser;
        boolean debug;
        block5: {
            debug = logger.isDebugEnabled();
            WebScript script = scriptReq.getServiceMatch().getWebScript();
            final Description desc = script.getDescription();
            Description.RequiredAuthentication containerRequiredAuthentication = this.getRequiredAuthentication();
            final Description.RequiredAuthentication required = desc.getRequiredAuthentication().compareTo((Enum)containerRequiredAuthentication) < 0 && !auth.emptyCredentials() ? containerRequiredAuthentication : desc.getRequiredAuthentication();
            final boolean isGuest = scriptReq.isGuest();
            if (required == Description.RequiredAuthentication.none) {
                AuthenticationUtil.clearCurrentSecurityContext();
                this.transactionedExecuteAs(script, scriptReq, scriptRes);
                return;
            }
            if ((required == Description.RequiredAuthentication.user || required == Description.RequiredAuthentication.admin) && isGuest) {
                throw new WebScriptException(401, "Web Script " + desc.getId() + " requires user authentication; however, a guest has attempted access.");
            }
            try {
                RetryingTransactionHelper.RetryingTransactionCallback<Boolean> authWork;
                AuthenticationUtil.pushAuthentication();
                if (debug) {
                    currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
                    logger.debug((Object)("Current authentication: " + (currentUser == null ? "unauthenticated" : "authenticated as " + currentUser)));
                    logger.debug((Object)("Authentication required: " + required));
                    logger.debug((Object)("Guest login requested: " + isGuest));
                }
                if (!((Boolean)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)(authWork = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                    public Boolean execute() throws Exception {
                        if (auth == null || auth.authenticate(required, isGuest)) {
                            if (required == Description.RequiredAuthentication.user || required == Description.RequiredAuthentication.admin) {
                                String authenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
                                String runAsUser = AuthenticationUtil.getRunAsUser();
                                if (authenticatedUser == null || authenticatedUser.equals(runAsUser) && RepositoryContainer.this.authorityService.hasGuestAuthority() || !authenticatedUser.equals(runAsUser) && RepositoryContainer.this.authorityService.isGuestAuthority(authenticatedUser)) {
                                    throw new WebScriptException(401, "Web Script " + desc.getId() + " requires user authentication; however, a guest has attempted access.");
                                }
                            }
                            if (required == Description.RequiredAuthentication.admin && !RepositoryContainer.this.authorityService.hasAdminAuthority() && !AuthenticationUtil.getFullyAuthenticatedUser().equals(AuthenticationUtil.getSystemUserName())) {
                                throw new WebScriptException(401, "Web Script " + desc.getId() + " requires admin authentication; however, a non-admin has attempted access.");
                            }
                            if (debug) {
                                String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
                                logger.debug((Object)("Authentication: " + (currentUser == null ? "unauthenticated" : "authenticated as " + currentUser)));
                            }
                            return true;
                        }
                        return false;
                    }
                }), true)).booleanValue()) break block5;
                this.transactionedExecuteAs(script, scriptReq, scriptRes);
            }
            catch (Throwable throwable) {
                AuthenticationUtil.popAuthentication();
                if (!debug) throw throwable;
                String currentUser2 = AuthenticationUtil.getFullyAuthenticatedUser();
                logger.debug((Object)("Authentication reset: " + (currentUser2 == null ? "unauthenticated" : "authenticated as " + currentUser2)));
                throw throwable;
            }
        }
        AuthenticationUtil.popAuthentication();
        if (!debug) return;
        currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        logger.debug((Object)("Authentication reset: " + (currentUser == null ? "unauthenticated" : "authenticated as " + currentUser)));
    }

    protected void transactionedExecute(final WebScript script, final WebScriptRequest scriptReq, final WebScriptResponse scriptRes) throws IOException {
        final Description description = script.getDescription();
        if (description.getRequiredTransaction() == Description.RequiredTransaction.none) {
            script.execute(scriptReq, scriptRes);
        } else {
            boolean requiresNew;
            BufferedResponse bufferedRes;
            BufferedRequest bufferedReq;
            Description.RequiredTransactionParameters trxParams = description.getRequiredTransactionParameters();
            if (trxParams.getCapability() == Description.TransactionCapability.readwrite) {
                if (trxParams.getBufferSize() > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Creating Transactional Response for ReadWrite transaction; buffersize=" + trxParams.getBufferSize()));
                    }
                    bufferedReq = new BufferedRequest(scriptReq);
                    bufferedRes = new BufferedResponse(scriptRes, trxParams.getBufferSize());
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Transactional Response bypassed for ReadWrite - buffersize=0");
                    }
                    bufferedReq = null;
                    bufferedRes = null;
                }
            } else {
                bufferedReq = null;
                bufferedRes = null;
            }
            RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Exception {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Begin retry transaction block: " + description.getRequiredTransaction() + "," + description.getRequiredTransactionParameters().getCapability()));
                        }
                        if (bufferedRes == null) {
                            script.execute(scriptReq, scriptRes);
                        } else {
                            bufferedReq.reset();
                            bufferedRes.reset();
                            script.execute((WebScriptRequest)bufferedReq, (WebScriptResponse)bufferedRes);
                        }
                    }
                    catch (Exception e) {
                        block16: {
                            UserTransaction userTrx;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Transaction exception: " + description.getRequiredTransaction() + ": " + e.getMessage()));
                                userTrx = RetryingTransactionHelper.getActiveUserTransaction();
                                if (userTrx != null) {
                                    logger.debug((Object)("Transaction status: " + userTrx.getStatus()));
                                }
                            }
                            if ((userTrx = RetryingTransactionHelper.getActiveUserTransaction()) != null && userTrx.getStatus() != 1) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Marking web script transaction for rollback");
                                }
                                try {
                                    userTrx.setRollbackOnly();
                                }
                                catch (Throwable re) {
                                    if (!logger.isDebugEnabled()) break block16;
                                    logger.debug((Object)("Caught and ignoring exception during marking for rollback: " + re.getMessage()));
                                }
                            }
                        }
                        throw e;
                    }
                    finally {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("End retry transaction block: " + description.getRequiredTransaction() + "," + description.getRequiredTransactionParameters().getCapability()));
                        }
                    }
                    return null;
                }
            };
            boolean readonly = description.getRequiredTransactionParameters().getCapability() == Description.TransactionCapability.readonly;
            boolean bl = requiresNew = description.getRequiredTransaction() == Description.RequiredTransaction.requiresnew;
            if (logger.isDebugEnabled() && !readonly && "GET".equalsIgnoreCase(description.getMethod())) {
                logger.debug((Object)("Webscript with URL '" + scriptReq.getURL() + "' is a GET request but it's descriptor has declared a readwrite transaction is required"));
            }
            try {
                this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work, readonly, requiresNew);
            }
            catch (TooBusyException e) {
                throw new WebScriptException(503, e.getMessage(), (Throwable)e);
            }
            finally {
                if (bufferedReq != null) {
                    bufferedReq.close();
                }
            }
            if (bufferedRes != null) {
                bufferedRes.writeResponse();
            }
        }
    }

    private void transactionedExecuteAs(final WebScript script, final WebScriptRequest scriptReq, final WebScriptResponse scriptRes) throws IOException {
        String runAs = script.getDescription().getRunAs();
        if (runAs == null) {
            this.transactionedExecute(script, scriptReq, scriptRes);
        } else {
            AuthenticationUtil.RunAsWork<Object> work = new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    RepositoryContainer.this.transactionedExecute(script, scriptReq, scriptRes);
                    return null;
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)work, (String)runAs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registry getRegistry() {
        Registry registry;
        String tenantDomain = this.tenantAdminService.getCurrentUserDomain();
        this.webScriptsRegistryLock.readLock().lock();
        try {
            registry = (Registry)this.webScriptsRegistryCache.get((Serializable)((Object)tenantDomain));
        }
        finally {
            this.webScriptsRegistryLock.readLock().unlock();
        }
        if (registry == null) {
            this.webScriptsRegistryLock.writeLock().lock();
            try {
                registry = (Registry)this.webScriptsRegistryCache.get((Serializable)((Object)tenantDomain));
                if (registry == null) {
                    registry = (Registry)this.registryFactory.getObject();
                    if (this.initialized) {
                        registry.reset();
                    }
                    this.webScriptsRegistryCache.put((Serializable)((Object)tenantDomain), (Object)registry);
                }
            }
            finally {
                this.webScriptsRegistryLock.writeLock().unlock();
            }
        }
        return registry;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        ContextRefreshedEvent refreshEvent;
        ApplicationContext refreshContext;
        if (event instanceof ContextRefreshedEvent && (refreshContext = (refreshEvent = (ContextRefreshedEvent)event).getApplicationContext()) != null && refreshContext.equals(this.applicationContext)) {
            AuthenticationUtil.RunAsWork<Object> work = new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    RepositoryContainer.this.reset();
                    return null;
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)work, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    public Description.RequiredAuthentication getRequiredAuthentication() {
        if (AuthenticationUtil.isMtEnabled()) {
            return Description.RequiredAuthentication.guest;
        }
        return Description.RequiredAuthentication.none;
    }

    public boolean authenticate(Authenticator auth, Description.RequiredAuthentication required) {
        if (auth != null) {
            AuthenticationUtil.clearCurrentSecurityContext();
            return auth.authenticate(required, false);
        }
        return false;
    }

    public void reset() {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                RepositoryContainer.this.destroy();
                RepositoryContainer.this.init();
                return null;
            }
        }, true, false);
    }

    public void onEnableTenant() {
        this.init();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    public void init() {
        this.tenantAdminService.register((TenantDeployer)this);
        super.reset();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.webScriptsRegistryLock.writeLock().lock();
            this.webScriptsRegistryCache.remove((Serializable)((Object)this.tenantAdminService.getCurrentUserDomain()));
            if (logger.isTraceEnabled()) {
                Exception e = new Exception("RepositoryContainer destroy called.");
                e.fillInStackTrace();
                logger.trace((Object)"", (Throwable)e);
            }
        }
        finally {
            this.webScriptsRegistryLock.writeLock().unlock();
        }
        this.initialized = false;
    }

    private static class BufferedRequest
    implements WrappingWebScriptRequest {
        private WebScriptRequest req;
        private File requestBody;
        private InputStream contentStream;
        private BufferedReader contentReader;

        public BufferedRequest(WebScriptRequest req) {
            this.req = req;
        }

        private File getRequestBodyAsFile() throws IOException {
            if (this.requestBody == null) {
                this.requestBody = TempFileProvider.createTempFile((String)"webscript_", (String)".bin");
                FileOutputStream out = new FileOutputStream(this.requestBody);
                FileCopyUtils.copy((InputStream)this.req.getContent().getInputStream(), (OutputStream)out);
            }
            return this.requestBody;
        }

        public void reset() {
            if (this.contentStream != null) {
                try {
                    this.contentStream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.contentStream = null;
            }
            if (this.contentReader != null) {
                try {
                    this.contentReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.contentReader = null;
            }
        }

        public void close() {
            this.reset();
            if (this.requestBody != null) {
                try {
                    this.requestBody.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.requestBody = null;
            }
        }

        public WebScriptRequest getNext() {
            return this.req;
        }

        public boolean forceSuccessStatus() {
            return this.req.forceSuccessStatus();
        }

        public String getAgent() {
            return this.req.getAgent();
        }

        public Content getContent() {
            final Content wrapped = this.req.getContent();
            return new Content(){

                public String getContent() throws IOException {
                    return wrapped.getContent();
                }

                public String getEncoding() {
                    return wrapped.getEncoding();
                }

                public String getMimetype() {
                    return wrapped.getMimetype();
                }

                public long getSize() {
                    return wrapped.getSize();
                }

                public InputStream getInputStream() {
                    if (BufferedRequest.this.contentReader != null) {
                        throw new IllegalStateException("Reader in use");
                    }
                    if (BufferedRequest.this.contentStream == null) {
                        try {
                            BufferedRequest.this.contentStream = new FileInputStream(BufferedRequest.this.getRequestBodyAsFile());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return BufferedRequest.this.contentStream;
                }

                public BufferedReader getReader() throws IOException {
                    if (BufferedRequest.this.contentStream != null) {
                        throw new IllegalStateException("Input Stream in use");
                    }
                    if (BufferedRequest.this.contentReader == null) {
                        String encoding = wrapped.getEncoding();
                        BufferedRequest.this.contentReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(BufferedRequest.this.getRequestBodyAsFile()), encoding == null ? "ISO-8859-1" : encoding));
                    }
                    return BufferedRequest.this.contentReader;
                }
            };
        }

        public String getContentType() {
            return this.req.getContentType();
        }

        public String getContextPath() {
            return this.req.getContextPath();
        }

        public String getExtensionPath() {
            return this.req.getExtensionPath();
        }

        public String getFormat() {
            return this.req.getFormat();
        }

        public Description.FormatStyle getFormatStyle() {
            return this.req.getFormatStyle();
        }

        public String getHeader(String name) {
            return this.req.getHeader(name);
        }

        public String[] getHeaderNames() {
            return this.req.getHeaderNames();
        }

        public String[] getHeaderValues(String name) {
            return this.req.getHeaderValues(name);
        }

        public String getJSONCallback() {
            return this.req.getJSONCallback();
        }

        public String getParameter(String name) {
            return this.req.getParameter(name);
        }

        public String[] getParameterNames() {
            return this.req.getParameterNames();
        }

        public String[] getParameterValues(String name) {
            return this.req.getParameterValues(name);
        }

        public String getPathInfo() {
            return this.req.getPathInfo();
        }

        public String getQueryString() {
            return this.req.getQueryString();
        }

        public Runtime getRuntime() {
            return this.req.getRuntime();
        }

        public String getServerPath() {
            return this.req.getServerPath();
        }

        public String getServiceContextPath() {
            return this.req.getServiceContextPath();
        }

        public Match getServiceMatch() {
            return this.req.getServiceMatch();
        }

        public String getServicePath() {
            return this.req.getServicePath();
        }

        public String getURL() {
            return this.req.getURL();
        }

        public boolean isGuest() {
            return this.req.isGuest();
        }

        public Object parseContent() {
            return this.req.parseContent();
        }
    }

    private static class BufferedResponse
    implements WrappingWebScriptResponse {
        private WebScriptResponse res;
        private int bufferSize;
        private ByteArrayOutputStream outputStream = null;
        private StringBuilderWriter outputWriter = null;

        public BufferedResponse(WebScriptResponse res, int bufferSize) {
            this.res = res;
            this.bufferSize = bufferSize;
        }

        public WebScriptResponse getNext() {
            return this.res;
        }

        public void addHeader(String name, String value) {
            this.res.addHeader(name, value);
        }

        public String encodeScriptUrl(String url) {
            return this.res.encodeScriptUrl(url);
        }

        public String getEncodeScriptUrlFunction(String name) {
            return this.res.getEncodeScriptUrlFunction(name);
        }

        public String encodeResourceUrl(String url) {
            return this.res.encodeResourceUrl(url);
        }

        public String getEncodeResourceUrlFunction(String name) {
            return this.res.getEncodeResourceUrlFunction(name);
        }

        public OutputStream getOutputStream() throws IOException {
            if (this.outputStream == null) {
                if (this.outputWriter != null) {
                    throw new AlfrescoRuntimeException("Already buffering output writer");
                }
                this.outputStream = new ByteArrayOutputStream(this.bufferSize);
            }
            return this.outputStream;
        }

        public Runtime getRuntime() {
            return this.res.getRuntime();
        }

        public Writer getWriter() throws IOException {
            if (this.outputWriter == null) {
                if (this.outputStream != null) {
                    throw new AlfrescoRuntimeException("Already buffering output stream");
                }
                this.outputWriter = new StringBuilderWriter(this.bufferSize);
            }
            return this.outputWriter;
        }

        public void reset() {
            if (this.outputStream != null) {
                this.outputStream.reset();
            } else if (this.outputWriter != null) {
                this.outputWriter = null;
            }
            this.res.reset();
        }

        public void setCache(Cache cache) {
            this.res.setCache(cache);
        }

        public void setContentType(String contentType) {
            this.res.setContentType(contentType);
        }

        public void setContentEncoding(String contentEncoding) {
            this.res.setContentEncoding(contentEncoding);
        }

        public void setHeader(String name, String value) {
            this.res.setHeader(name, value);
        }

        public void setStatus(int status) {
            this.res.setStatus(status);
        }

        private void writeResponse() {
            try {
                if (logger.isDebugEnabled() && this.outputStream != null) {
                    logger.debug((Object)("Writing Transactional response: size=" + this.outputStream.size()));
                }
                if (this.outputWriter != null) {
                    this.outputWriter.flush();
                    this.res.getWriter().write(this.outputWriter.toString());
                } else if (this.outputStream != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Writing Transactional response: size=" + this.outputStream.size()));
                    }
                    this.outputStream.flush();
                    this.outputStream.writeTo(this.res.getOutputStream());
                }
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("Failed to commit buffered response", (Throwable)e);
            }
        }
    }
}

