/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.repo.web.scripts.RepositoryContainer;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class RepositoryContainerTest
extends BaseWebScriptTest {
    private MutableAuthenticationService authenticationService;
    private PersonService personService;
    private AuthenticationComponent authenticationComponent;
    private static final String USER_ONE = "RunAsOne";
    private static final String USER_TWO = "RunAsTwo";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(5);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    protected void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    public void testRunAsAdmin() throws Exception {
        this.authenticationComponent.setCurrentUser(USER_ONE);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/test/runas"), 200);
        RepositoryContainerTest.assertEquals((String)USER_ONE, (String)response.getContentAsString());
        this.authenticationComponent.setCurrentUser(USER_TWO);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/test/runasadmin"), 200);
        RepositoryContainerTest.assertEquals((String)USER_TWO, (String)response.getContentAsString());
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    public void testReset() throws Exception {
        RepositoryContainer repoContainer = (RepositoryContainer)((Object)this.getServer().getApplicationContext().getBean("webscripts.container"));
        repoContainer.reset();
    }
}

