/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import freemarker.cache.CacheStorage;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.StrongCacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.alfresco.processor.ProcessorExtension;
import org.alfresco.repo.template.FreeMarkerProcessor;
import org.alfresco.repo.template.QNameAwareObjectWrapper;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.Store;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.extensions.webscripts.WebScriptException;

public class RepositoryTemplateProcessor
extends FreeMarkerProcessor
implements TemplateProcessor,
ApplicationContextAware,
ApplicationListener {
    private ProcessorLifecycle lifecycle = new ProcessorLifecycle();
    protected SearchPath searchPath;
    protected String defaultEncoding;
    protected Configuration templateConfig;
    protected FreeMarkerProcessor freeMarkerProcessor;
    private int updateDelay = 1;

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setUpdateDelay(int updateDelay) {
        this.updateDelay = updateDelay;
    }

    @Deprecated
    public void setCacheSize(int cacheSize) {
    }

    public void setSearchPath(SearchPath searchPath) {
        this.searchPath = searchPath;
    }

    public void setFreeMarkerProcessor(FreeMarkerProcessor freeMarkerProcessor) {
        this.freeMarkerProcessor = freeMarkerProcessor;
    }

    protected Configuration getConfig() {
        return this.templateConfig;
    }

    public void reset() {
        if (this.templateConfig != null) {
            this.templateConfig.clearTemplateCache();
        }
        this.initConfig();
    }

    public boolean hasTemplate(String templatePath) {
        boolean hasTemplate = false;
        try {
            Template template = this.templateConfig.getTemplate(templatePath);
            hasTemplate = template != null;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new WebScriptException("Failed to retrieve template " + templatePath, (Throwable)e);
        }
        return hasTemplate;
    }

    protected void initConfig() {
        Configuration config = new Configuration();
        config.setCacheStorage((CacheStorage)new StrongCacheStorage());
        config.setTemplateUpdateDelay(this.updateDelay);
        ArrayList<TemplateLoader> loaders = new ArrayList<TemplateLoader>();
        for (Store apiStore : this.searchPath.getStores()) {
            TemplateLoader loader = apiStore.getTemplateLoader();
            if (loader == null) {
                throw new WebScriptException("Unable to retrieve template loader for Web Script store " + apiStore.getBasePath());
            }
            loaders.add(loader);
        }
        MultiTemplateLoader loader = new MultiTemplateLoader(loaders.toArray(new TemplateLoader[loaders.size()]));
        config.setTemplateLoader((TemplateLoader)loader);
        config.setObjectWrapper((ObjectWrapper)new QNameAwareObjectWrapper());
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        config.setLocalizedLookup(false);
        if (this.defaultEncoding != null) {
            config.setDefaultEncoding(this.defaultEncoding);
        }
        config.setOutputEncoding("UTF-8");
        this.templateConfig = config;
    }

    private void initProcessorExtensions() {
        for (ProcessorExtension processorExtension : this.freeMarkerProcessor.getProcessorExtensions()) {
            this.registerProcessorExtension(processorExtension);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.lifecycle.setApplicationContext(applicationContext);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        this.lifecycle.onApplicationEvent(event);
    }

    private class ProcessorLifecycle
    extends AbstractLifecycleBean {
        private ProcessorLifecycle() {
        }

        protected void onBootstrap(ApplicationEvent event) {
            RepositoryTemplateProcessor.this.initProcessorExtensions();
        }

        protected void onShutdown(ApplicationEvent event) {
        }
    }
}

