/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.activities;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
import org.springframework.extensions.surf.util.Base64;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class SiteActivitySystemTest
extends TestCase {
    private static Log logger = LogFactory.getLog(SiteActivitySystemTest.class);
    private static final String REPO = "http://localhost:8080/alfresco";
    private static final String WEBSCRIPT_ENDPOINT = "http://localhost:8080/alfresco/service";
    private static final String URL_SITES = "/api/sites";
    private static final String URL_MEMBERSHIPS = "/memberships";
    private static final String URL_PEOPLE = "/api/people";
    private static final String URL_ACTIVITIES = "/api/activities";
    private static final String URL_SITE_FEED = "/feed/site";
    private static final String URL_USER_FEED = "/feed/user";
    private static final String URL_USER_FEED_CTRL = "/feed/control";
    private static final String ADMIN_USER = "admin";
    private static final String ADMIN_PW = "admin";
    private static String user1 = null;
    private static String user2 = null;
    private static String user3 = null;
    private static String user4 = null;
    private static final String USER_PW = "password";
    private static String site1 = null;
    private static String site2 = null;
    private static String site3 = null;
    private static String appToolId = "siteService";
    private static int DELAY_MSECS = 120000;
    private static boolean setup = false;
    private static boolean sitesCreated = false;
    private static boolean membersAddedUpdated = false;
    private static boolean membersRemoved = false;
    private static boolean controlsCreated = false;

    protected void setUp() throws Exception {
        super.setUp();
        if (!setup) {
            String testid = "" + System.currentTimeMillis();
            site1 = "test_site1_" + testid;
            site2 = "test_site2_" + testid;
            site3 = "test_site3_" + testid;
            user1 = "test_user1_" + testid;
            user2 = "test_user2_" + testid;
            user3 = "test_user3_" + testid;
            user4 = "test_user4_" + testid;
            String ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, "admin", "admin");
            SiteActivitySystemTest.assertNotNull((Object)ticket);
            this.createUser(ticket, user1, USER_PW);
            this.createUser(ticket, user2, USER_PW);
            this.createUser(ticket, user3, USER_PW);
            this.createUser(ticket, user4, USER_PW);
            setup = true;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test01Login() throws Exception {
        String ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, "admin", "admin");
        SiteActivitySystemTest.assertNotNull((Object)ticket);
    }

    public void test02CreateSites() throws Exception {
        if (!sitesCreated) {
            String ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, "admin", "admin");
            this.createSite(site1, true, ticket);
            this.createSite(site2, false, ticket);
            this.createSite(site3, false, ticket);
            sitesCreated = true;
        }
    }

    protected void createSite(String siteId, boolean isPublic, String ticket) throws Exception {
        JSONObject site = new JSONObject();
        site.put("sitePreset", (Object)"myPreset");
        site.put("shortName", (Object)siteId);
        site.put("title", (Object)"myTitle");
        site.put("description", (Object)"myDescription");
        site.put("isPublic", isPublic);
        String url = "http://localhost:8080/alfresco/service/api/sites";
        String response = this.callPostWebScript(url, ticket, site.toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("createSite: " + siteId));
            logger.debug((Object)"----------");
            logger.debug((Object)url);
            logger.debug((Object)response);
        }
    }

    public void test03GetSites() throws Exception {
        this.test02CreateSites();
        String ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, "admin", "admin");
        this.getSite(site1, ticket);
        this.getSite(site2, ticket);
        this.getSite(site3, ticket);
    }

    protected void getSite(String siteId, String ticket) throws Exception {
        String url = "http://localhost:8080/alfresco/service/api/sites/" + siteId;
        String response = this.callGetWebScript(url, ticket);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getSite:" + siteId));
            logger.debug((Object)"-------");
            logger.debug((Object)url);
            logger.debug((Object)response);
        }
    }

    public void test04GetSiteFeedsBefore() throws Exception {
        this.test02CreateSites();
        String ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, "admin", "admin");
        this.getSiteFeed(site1, ticket, 0);
        this.getSiteFeed(site2, ticket, 0);
        this.getSiteFeed(site3, ticket, 0);
        ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, user4, USER_PW);
        this.getSiteFeed(site1, ticket, 0);
        try {
            this.getSiteFeed(site2, ticket, 0);
            SiteActivitySystemTest.fail((String)"Site feed for private site should not be accessible to non-admin / non-member");
        }
        catch (IOException ioe) {
            SiteActivitySystemTest.assertTrue((boolean)ioe.getMessage().contains("HTTP response code: 401"));
        }
        try {
            this.getSiteFeed(site3, ticket, 0);
            SiteActivitySystemTest.fail((String)"Site feed for private site should not be accessible to non-admin / non-member");
        }
        catch (IOException ioe) {
            SiteActivitySystemTest.assertTrue((boolean)ioe.getMessage().contains("HTTP response code: 401"));
        }
    }

    protected void getSiteFeed(String siteId, String ticket, int expectedCount) throws Exception {
        String url = "http://localhost:8080/alfresco/service/api/activities/feed/site/" + siteId + "?format=json";
        String jsonArrayResult = this.callGetWebScript(url, ticket);
        if (jsonArrayResult != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getSiteFeed:" + siteId));
                logger.debug((Object)"-----------");
                logger.debug((Object)url);
                logger.debug((Object)jsonArrayResult);
            }
            JSONArray ja = new JSONArray(jsonArrayResult);
            SiteActivitySystemTest.assertEquals((int)expectedCount, (int)ja.length());
        } else {
            SiteActivitySystemTest.fail((String)"Error getting site feed");
        }
    }

    public void test05GetUserFeedsBefore() throws Exception {
        this.test02CreateSites();
        String ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, "admin", "admin");
        this.getUserFeed(user1, ticket, true, 0);
        this.getUserFeed(user2, ticket, true, 0);
        this.getUserFeed(user3, ticket, true, 0);
        this.getUserFeed(user4, ticket, true, 0);
        ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, user1, USER_PW);
        this.getUserFeed(user1, ticket, false, 0);
        ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, user2, USER_PW);
        try {
            this.getUserFeed(user1, ticket, true, 0);
            SiteActivitySystemTest.fail((String)"User feed should only be accessible to user or an admin");
        }
        catch (IOException ioe) {
            SiteActivitySystemTest.assertTrue((boolean)ioe.getMessage().contains("HTTP response code: 401"));
        }
        ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, user1, USER_PW);
        this.getUserFeed(null, site1, ticket, false, false, false, 0);
        this.getUserFeed(null, site2, ticket, false, false, false, 0);
        this.getUserFeed(null, site3, ticket, false, false, false, 0);
        this.getUserFeed(null, null, ticket, false, true, false, 0);
        this.getUserFeed(null, null, ticket, false, false, true, 0);
        this.getUserFeed(null, null, ticket, false, true, true, 0);
    }

    protected void getUserFeed(String userId, String ticket, boolean isAdmin, int expectedCount) throws Exception {
        this.getUserFeed(userId, null, ticket, isAdmin, false, false, expectedCount);
    }

    protected void getUserFeed(String userId, String siteId, String ticket, boolean isAdmin, boolean excludeThisUser, boolean excludeOtherUsers, int expectedCount) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(WEBSCRIPT_ENDPOINT).append(URL_ACTIVITIES).append(URL_USER_FEED).append(isAdmin ? "/" + userId : "").append("?").append(siteId != null ? "s=" + siteId + "&" : "").append(excludeThisUser ? "exclUser=true&" : "").append(excludeOtherUsers ? "exclOthers=true&" : "").append("format=json");
        String url = sb.toString();
        String jsonArrayResult = this.callGetWebScript(url, ticket);
        if (jsonArrayResult != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getUserFeed:" + userId + (isAdmin ? "(as admin)" : "")));
                logger.debug((Object)"-----------");
                logger.debug((Object)url);
                logger.debug((Object)jsonArrayResult);
            }
            JSONArray ja = new JSONArray(jsonArrayResult);
            SiteActivitySystemTest.assertEquals((int)expectedCount, (int)ja.length());
        } else {
            SiteActivitySystemTest.fail((String)"Error getting user feed");
        }
    }

    public void test06UserFeedControls() throws Exception {
        if (!controlsCreated) {
            String ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, user1, USER_PW);
            this.addFeedControl(user1, site1, null, ticket);
            ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, user2, USER_PW);
            this.addFeedControl(user2, null, appToolId, ticket);
            ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, user3, USER_PW);
            this.addFeedControl(user3, site1, appToolId, ticket);
            controlsCreated = true;
        }
    }

    public void test07AddAndUpdateMembershipsWithPause() throws Exception {
        if (!membersAddedUpdated) {
            this.test02CreateSites();
            String ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, "admin", "admin");
            this.addAndUpdateMemberships(site1, ticket, true);
            this.addAndUpdateMemberships(site2, ticket, true);
            this.addAndUpdateMemberships(site3, ticket, false);
            Thread.sleep(DELAY_MSECS);
            membersAddedUpdated = true;
        }
    }

    public void test08GetSiteFeedsAfterAddAndUpdateMemberships() throws Exception {
        this.test02CreateSites();
        this.test07AddAndUpdateMembershipsWithPause();
        String ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, "admin", "admin");
        this.getSiteFeed(site1, ticket, 8);
        this.getSiteFeed(site2, ticket, 8);
        this.getSiteFeed(site3, ticket, 6);
        ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, user4, USER_PW);
        this.getSiteFeed(site1, ticket, 8);
        this.getSiteFeed(site2, ticket, 8);
        try {
            this.getSiteFeed(site3, ticket, 0);
            SiteActivitySystemTest.fail((String)"Site feed for private site should not be accessible to non-admin / non-member");
        }
        catch (IOException ioe) {
            SiteActivitySystemTest.assertTrue((boolean)ioe.getMessage().contains("HTTP response code: 401"));
        }
    }

    public void test09RemoveMembershipsWithPause() throws Exception {
        if (!membersRemoved) {
            this.test02CreateSites();
            this.test07AddAndUpdateMembershipsWithPause();
            String ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, "admin", "admin");
            this.removeMemberships(site1, ticket, true);
            this.removeMemberships(site2, ticket, true);
            this.removeMemberships(site3, ticket, false);
            Thread.sleep(DELAY_MSECS);
            membersRemoved = true;
        }
    }

    protected void addAndUpdateMemberships(String siteId, String ticket, boolean includeUser4) throws Exception {
        this.addMembership(siteId, user1, ticket, "SiteConsumer");
        this.addMembership(siteId, user2, ticket, "SiteManager");
        this.addMembership(siteId, user3, ticket, "SiteCollaborator");
        if (includeUser4) {
            this.addMembership(siteId, user4, ticket, "SiteConsumer");
        }
        this.updateMembership(siteId, user1, ticket, "SiteManager");
        this.updateMembership(siteId, user2, ticket, "SiteCollaborator");
        this.updateMembership(siteId, user3, ticket, "SiteConsumer");
        if (includeUser4) {
            this.updateMembership(siteId, user4, ticket, "SiteCollaborator");
        }
    }

    protected void removeMemberships(String siteId, String ticket, boolean includeUser4) throws Exception {
        this.removeMembership(siteId, user1, ticket);
        this.removeMembership(siteId, user2, ticket);
        this.removeMembership(siteId, user3, ticket);
        if (includeUser4) {
            this.removeMembership(siteId, user4, ticket);
        }
    }

    public void test10GetSiteFeedsAfterRemoveMemberships() throws Exception {
        this.test02CreateSites();
        this.test07AddAndUpdateMembershipsWithPause();
        this.test09RemoveMembershipsWithPause();
        String ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, "admin", "admin");
        this.getSiteFeed(site1, ticket, 12);
        this.getSiteFeed(site2, ticket, 12);
        this.getSiteFeed(site3, ticket, 9);
        ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, user4, USER_PW);
        this.getSiteFeed(site1, ticket, 12);
        try {
            this.getSiteFeed(site2, ticket, 0);
            SiteActivitySystemTest.fail((String)"Site feed for private site should not be accessible to non-admin / non-member");
        }
        catch (IOException ioe) {
            SiteActivitySystemTest.assertTrue((boolean)ioe.getMessage().contains("HTTP response code: 401"));
        }
        try {
            this.getSiteFeed(site3, ticket, 0);
            SiteActivitySystemTest.fail((String)"Site feed for private site should not be accessible to non-admin / non-member");
        }
        catch (IOException ioe) {
            SiteActivitySystemTest.assertTrue((boolean)ioe.getMessage().contains("HTTP response code: 401"));
        }
    }

    public void test11GetUserFeedsAfter() throws Exception {
        this.test02CreateSites();
        this.test07AddAndUpdateMembershipsWithPause();
        this.test09RemoveMembershipsWithPause();
        this.test06UserFeedControls();
        String ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, "admin", "admin");
        this.getUserFeed(user1, ticket, true, 14);
        this.getUserFeed(user2, ticket, true, 0);
        this.getUserFeed(user3, ticket, true, 14);
        this.getUserFeed(user4, ticket, true, 16);
        ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, user1, USER_PW);
        this.getUserFeed(user1, ticket, false, 14);
        ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, user2, USER_PW);
        try {
            this.getUserFeed(user1, ticket, true, 14);
            SiteActivitySystemTest.fail((String)"User feed should only be accessible to user or an admin");
        }
        catch (IOException ioe) {
            SiteActivitySystemTest.assertTrue((boolean)ioe.getMessage().contains("HTTP response code: 401"));
        }
        ticket = this.callLoginWebScript(WEBSCRIPT_ENDPOINT, user1, USER_PW);
        this.getUserFeed(null, site1, ticket, false, false, false, 0);
        this.getUserFeed(null, site2, ticket, false, false, false, 8);
        this.getUserFeed(null, site3, ticket, false, false, false, 6);
        this.getUserFeed(null, null, ticket, false, false, false, 14);
        this.getUserFeed(null, null, ticket, false, true, false, 12);
        this.getUserFeed(null, null, ticket, false, false, true, 2);
        this.getUserFeed(null, null, ticket, false, true, true, 0);
    }

    private void addMembership(String siteId, String userName, String ticket, String role) throws Exception {
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)role);
        JSONObject person = new JSONObject();
        person.put("userName", (Object)userName);
        membership.put("person", (Object)person);
        String url = "http://localhost:8080/alfresco/service/api/sites/" + siteId + URL_MEMBERSHIPS;
        String response = this.callPostWebScript(url, ticket, membership.toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("addMembership: " + siteId + " - " + userName));
            logger.debug((Object)"--------------");
            logger.debug((Object)url);
            logger.debug((Object)response);
        }
    }

    private void updateMembership(String siteId, String userName, String ticket, String role) throws Exception {
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)role);
        JSONObject person = new JSONObject();
        person.put("userName", (Object)userName);
        membership.put("person", (Object)person);
        String url = "http://localhost:8080/alfresco/service/api/sites/" + siteId + URL_MEMBERSHIPS;
        String response = this.callPutWebScript(url, ticket, membership.toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("updateMembership: " + siteId + " - " + userName));
            logger.debug((Object)"-----------------");
            logger.debug((Object)url);
            logger.debug((Object)response);
        }
    }

    private void removeMembership(String siteId, String userName, String ticket) throws Exception {
        String url = "http://localhost:8080/alfresco/service/api/sites/" + siteId + URL_MEMBERSHIPS + "/" + userName;
        String response = this.callDeleteWebScript(url, ticket);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removeMembership: " + siteId + " - " + userName));
            logger.debug((Object)"-----------------");
            logger.debug((Object)url);
            logger.debug((Object)response);
        }
    }

    private void addFeedControl(String userName, String siteId, String appToolId, String ticket) throws Exception {
        JSONObject feedControl = new JSONObject();
        feedControl.put("siteId", (Object)siteId);
        feedControl.put("appToolId", (Object)appToolId);
        String url = "http://localhost:8080/alfresco/service/api/activities/feed/control";
        String response = this.callPostWebScript(url, ticket, feedControl.toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("addFeedControl: " + userName));
            logger.debug((Object)"--------------");
            logger.debug((Object)url);
            logger.debug((Object)response);
        }
    }

    protected String callGetWebScript(String urlString, String ticket) throws MalformedURLException, URISyntaxException, IOException {
        return this.callOutWebScript(urlString, "GET", ticket);
    }

    protected String callDeleteWebScript(String urlString, String ticket) throws MalformedURLException, URISyntaxException, IOException {
        return this.callOutWebScript(urlString, "DELETE", ticket);
    }

    protected String callPostWebScript(String urlString, String ticket, String data) throws MalformedURLException, URISyntaxException, IOException {
        return this.callInOutWebScript(urlString, "POST", ticket, data);
    }

    protected String callPutWebScript(String urlString, String ticket, String data) throws MalformedURLException, URISyntaxException, IOException {
        return this.callInOutWebScript(urlString, "PUT", ticket, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String callOutWebScript(String urlString, String method, String ticket) throws MalformedURLException, URISyntaxException, IOException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        if (ticket != null) {
            conn.addRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])ticket.getBytes()));
        }
        String result = null;
        InputStream is = null;
        BufferedReader br = null;
        try {
            is = conn.getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            result = sb.toString();
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return result;
    }

    private String callInOutWebScript(String urlString, String method, String ticket, String data) throws MalformedURLException, URISyntaxException, IOException {
        return this.callInOutWeb(urlString, method, ticket, data, "application/json", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String callInOutWeb(String urlString, String method, String ticket, String data, String contentType, String soapAction) throws MalformedURLException, URISyntaxException, IOException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setRequestProperty("Content-type", contentType);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        if (soapAction != null) {
            conn.setRequestProperty("SOAPAction", soapAction);
        }
        if (ticket != null) {
            conn.addRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])ticket.getBytes()));
        }
        String result = null;
        BufferedReader br = null;
        FilterOutputStream wr = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            os = conn.getOutputStream();
            wr = new DataOutputStream(os);
            wr.write(data.getBytes());
            ((DataOutputStream)wr).flush();
        }
        finally {
            if (wr != null) {
                wr.close();
            }
            if (os != null) {
                os.close();
            }
        }
        try {
            is = conn.getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            result = sb.toString();
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return result;
    }

    protected String callLoginWebScript(String serviceUrl, String username, String password) throws MalformedURLException, URISyntaxException, IOException {
        String ticketResult = this.callGetWebScript(serviceUrl + "/api/login?u=" + username + "&pw=" + password, null);
        if (ticketResult != null) {
            int startTag = ticketResult.indexOf("<ticket>");
            int endTag = ticketResult.indexOf("</ticket>");
            if (startTag != -1 && endTag != -1) {
                ticketResult = ticketResult.substring(startTag + "<ticket>".length(), endTag);
            }
        }
        return ticketResult;
    }

    protected void createUser(String ticket, String username, String password) throws JSONException, IOException, URISyntaxException {
        JSONObject person = new JSONObject();
        person.put("userName", (Object)username);
        person.put("firstName", (Object)"first");
        person.put("lastName", (Object)"last");
        person.put("email", (Object)"email@email.com");
        person.put(USER_PW, (Object)password);
        String url = "http://localhost:8080/alfresco/service/api/people";
        String response = this.callPostWebScript(url, ticket, person.toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("addPerson: " + username));
            logger.debug((Object)"--------------");
            logger.debug((Object)url);
            logger.debug((Object)response);
        }
    }
}

