/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.activities.feed.control;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class FeedControlTest
extends BaseWebScriptTest {
    private static Log logger = LogFactory.getLog(FeedControlTest.class);
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private static final String TEST_USER = "my user";
    private static final String TEST_SITE_ID = "my site";
    private static final String TEST_APP_TOOL_ID = "my app tool";
    private static final String URL_CONTROLS = "/api/activities/feed/controls";
    private static final String URL_CONTROL = "/api/activities/feed/control";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.createUser(TEST_USER);
        this.authenticationComponent.setCurrentUser(TEST_USER);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    public void testCreateFeedControls() throws Exception {
        this.createFeedControl(TEST_SITE_ID, null);
        this.createFeedControl(null, TEST_APP_TOOL_ID);
        this.createFeedControl(TEST_SITE_ID, TEST_APP_TOOL_ID);
    }

    protected void createFeedControl(String siteId, String appToolId) throws Exception {
        JSONObject feedControl = new JSONObject();
        feedControl.put("siteId", (Object)siteId);
        feedControl.put("appToolId", (Object)appToolId);
        int expectedStatus = 200;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_CONTROL, feedControl.toString(), "application/json"), expectedStatus);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)response);
        }
    }

    public void testRetrieveFeedControls() throws Exception {
        int expectedStatus = 200;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_CONTROLS), expectedStatus);
        JSONArray result = new JSONArray(response.getContentAsString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)result);
        }
        FeedControlTest.assertNotNull((Object)result);
        FeedControlTest.assertEquals((int)3, (int)result.length());
    }

    public void testDeleteFeedControls() throws Exception {
        this.deleteFeedControl(TEST_SITE_ID, null);
        this.deleteFeedControl(null, TEST_APP_TOOL_ID);
        this.deleteFeedControl(TEST_SITE_ID, TEST_APP_TOOL_ID);
    }

    protected void deleteFeedControl(String siteId, String appToolId) throws Exception {
        int expectedStatus = 200;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/activities/feed/control?s=my site&a=my app tool"), expectedStatus);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)response);
        }
    }
}

