/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.admin;

import java.util.Collections;
import java.util.Map;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.admin.RepoUsageStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.DeclarativeWebScript;

public abstract class AbstractAdminWebScript
extends DeclarativeWebScript {
    public static final String JSON_KEY_LAST_UPDATE = "lastUpdate";
    public static final String JSON_KEY_USERS = "users";
    public static final String JSON_KEY_DOCUMENTS = "documents";
    public static final String JSON_KEY_LICENSE_MODE = "licenseMode";
    public static final String JSON_KEY_READ_ONLY = "readOnly";
    public static final String JSON_KEY_UPDATED = "updated";
    public static final String JSON_KEY_LICENSE_VALID_UNTIL = "licenseValidUntil";
    public static final String JSON_KEY_LEVEL = "level";
    public static final String JSON_KEY_WARNINGS = "warnings";
    public static final String JSON_KEY_ERRORS = "errors";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected RepoAdminService repoAdminService;

    public void setRepoAdminService(RepoAdminService repoAdminService) {
        this.repoAdminService = repoAdminService;
    }

    protected String getI18NMessage(String key, Object ... args) {
        return I18NUtil.getMessage((String)key, (Object[])args);
    }

    protected void putUsageInModel(Map<String, Object> model, RepoUsage repoUsage, boolean updated) {
        model.put(JSON_KEY_LAST_UPDATE, repoUsage.getLastUpdate());
        model.put(JSON_KEY_USERS, repoUsage.getUsers());
        model.put(JSON_KEY_DOCUMENTS, repoUsage.getDocuments());
        model.put(JSON_KEY_LICENSE_MODE, repoUsage.getLicenseMode());
        model.put(JSON_KEY_READ_ONLY, repoUsage.isReadOnly());
        model.put(JSON_KEY_LICENSE_VALID_UNTIL, repoUsage.getLicenseExpiryDate());
        model.put(JSON_KEY_UPDATED, updated);
        model.put(JSON_KEY_LEVEL, RepoUsageStatus.RepoUsageLevel.OK.ordinal());
        model.put(JSON_KEY_WARNINGS, Collections.emptyList());
        model.put(JSON_KEY_ERRORS, Collections.emptyList());
    }
}

