/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.admin;

import java.util.Date;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.admin.RepoUsageStatus;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.license.LicenseDescriptor;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class AdminWebScriptTest
extends BaseWebScriptTest {
    private ApplicationContext ctx;
    private RepoAdminService repoAdminService;
    private DescriptorService descriptorService;
    private String admin;
    private String guest;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.ctx = this.getServer().getApplicationContext();
        this.repoAdminService = (RepoAdminService)this.ctx.getBean("RepoAdminService");
        this.descriptorService = (DescriptorService)this.ctx.getBean("DescriptorService");
        this.admin = AuthenticationUtil.getAdminUserName();
        this.guest = AuthenticationUtil.getGuestUserName();
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.admin);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetRestrictions() throws Exception {
        RepoUsage restrictions = this.repoAdminService.getRestrictions();
        String url = "/api/admin/restrictions";
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(url);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.guest);
        JSONObject json = new JSONObject(response.getContentAsString());
        Long maxUsers = json.isNull("users") ? null : Long.valueOf(json.getLong("users"));
        AdminWebScriptTest.assertEquals((String)"Mismatched max users", (Object)restrictions.getUsers(), (Object)maxUsers);
        Long maxDocuments = json.isNull("documents") ? null : Long.valueOf(json.getLong("documents"));
        AdminWebScriptTest.assertEquals((String)"Mismatched max documents", (Object)restrictions.getDocuments(), (Object)maxDocuments);
    }

    public void testGetUsage() throws Exception {
        RepoUsageStatus usageStatus = this.repoAdminService.getUsageStatus();
        RepoUsage usage = usageStatus.getUsage();
        LicenseDescriptor licenseDescriptor = this.descriptorService.getLicenseDescriptor();
        Date validUntil = licenseDescriptor == null ? null : licenseDescriptor.getValidUntil();
        Integer checkLevel = new Integer(usageStatus.getLevel().ordinal());
        String url = "/api/admin/usage";
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(url);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.guest);
        System.out.println(response.getContentAsString());
        JSONObject json = new JSONObject(response.getContentAsString());
        Long users = json.isNull("users") ? null : Long.valueOf(json.getLong("users"));
        AdminWebScriptTest.assertEquals((String)"Mismatched users", (Object)usage.getUsers(), (Object)users);
        Long documents = json.isNull("documents") ? null : Long.valueOf(json.getLong("documents"));
        AdminWebScriptTest.assertEquals((String)"Mismatched documents", (Object)usage.getDocuments(), (Object)documents);
        String licenseMode = json.isNull("licenseMode") ? null : json.getString("licenseMode");
        AdminWebScriptTest.assertEquals((String)"Mismatched licenseMode", (String)usage.getLicenseMode().toString(), (String)licenseMode);
        boolean readOnly = json.getBoolean("readOnly");
        AdminWebScriptTest.assertEquals((String)"Mismatched readOnly", (boolean)usage.isReadOnly(), (boolean)readOnly);
        boolean updated = json.getBoolean("updated");
        AdminWebScriptTest.assertEquals((String)"Mismatched updated", (boolean)false, (boolean)updated);
        Long licenseValidUntil = json.isNull("licenseValidUntil") ? null : Long.valueOf(json.getLong("licenseValidUntil"));
        AdminWebScriptTest.assertEquals((String)"Mismatched licenseValidUntil", (Object)(validUntil == null ? null : Long.valueOf(validUntil.getTime())), (Object)licenseValidUntil);
        Integer level = json.isNull("level") ? null : Integer.valueOf(json.getInt("level"));
        AdminWebScriptTest.assertEquals((String)"Mismatched level", (Object)checkLevel, (Object)level);
        json.getJSONArray("warnings");
        json.getJSONArray("errors");
    }

    public void testUpdateUsageWithoutPermissions() throws Exception {
        String url = "/api/admin/usage";
        TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(url, "", "application/json");
        this.sendRequest((TestWebScriptServer.Request)req, 401, AuthenticationUtil.getGuestRoleName());
    }

    public void testUpdateUsage() throws Exception {
        this.repoAdminService.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        RepoUsage usage = this.repoAdminService.getUsage();
        String url = "/api/admin/usage";
        TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(url, "", "application/json");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        System.out.println(response.getContentAsString());
        JSONObject json = new JSONObject(response.getContentAsString());
        Long users = json.isNull("users") ? null : Long.valueOf(json.getLong("users"));
        AdminWebScriptTest.assertEquals((String)"Mismatched users", (Object)usage.getUsers(), (Object)users);
        Long documents = json.isNull("documents") ? null : Long.valueOf(json.getLong("documents"));
        AdminWebScriptTest.assertEquals((String)"Mismatched documents", (Object)usage.getDocuments(), (Object)documents);
        String licenseMode = json.isNull("licenseMode") ? null : json.getString("licenseMode");
        AdminWebScriptTest.assertEquals((String)"Mismatched licenseMode", (String)usage.getLicenseMode().toString(), (String)licenseMode);
        boolean readOnly = json.getBoolean("readOnly");
        AdminWebScriptTest.assertEquals((String)"Mismatched readOnly", (boolean)usage.isReadOnly(), (boolean)readOnly);
        boolean updated = json.getBoolean("updated");
        AdminWebScriptTest.assertEquals((String)"Mismatched updated", (boolean)true, (boolean)updated);
    }
}

