/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.archive;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class AbstractArchivedNodeWebScript
extends DeclarativeWebScript {
    public static final String NAME = "name";
    public static final String TITLE = "title";
    public static final String DESCRIPTION = "description";
    public static final String NODEREF = "nodeRef";
    public static final String ARCHIVED_BY = "archivedBy";
    public static final String ARCHIVED_DATE = "archivedDate";
    public static final String DISPLAY_PATH = "displayPath";
    public static final String USER_NAME = "userName";
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String NODE_TYPE = "nodeType";
    public static final String DELETED_NODES = "deletedNodes";
    protected ServiceRegistry serviceRegistry;
    protected NodeArchiveService nodeArchiveService;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setNodeArchiveService(NodeArchiveService nodeArchiveService) {
        this.nodeArchiveService = nodeArchiveService;
    }

    protected StoreRef parseRequestForStoreRef(WebScriptRequest req) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String storeType = (String)templateVars.get("store_type");
        String storeId = (String)templateVars.get("store_id");
        StoreRef storeRef = new StoreRef(storeType, storeId);
        return storeRef;
    }

    protected NodeRef parseRequestForNodeRef(WebScriptRequest req) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String storeType = (String)templateVars.get("store_type");
        String storeId = (String)templateVars.get("store_id");
        String id = (String)templateVars.get("id");
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        return new NodeRef(storeType, storeId, id);
    }

    protected int getIntParameter(WebScriptRequest req, String paramName, int defaultValue) {
        String paramString = req.getParameter(paramName);
        if (paramString != null) {
            try {
                int param = Integer.valueOf(paramString);
                if (param >= 0) {
                    return param;
                }
            }
            catch (NumberFormatException e) {
                throw new WebScriptException(400, e.getMessage());
            }
        }
        return defaultValue;
    }

    protected SortedSet<ChildAssociationRef> getArchivedNodesFrom(StoreRef storeRef) {
        NodeService nodeService = this.serviceRegistry.getNodeService();
        NodeRef archiveRootNode = nodeService.getStoreArchiveNode(storeRef);
        List children = nodeService.getChildAssocs(archiveRootNode);
        ArchivedDateComparator archivedNodeSorter = new ArchivedDateComparator();
        TreeSet<ChildAssociationRef> orderedChildren = new TreeSet<ChildAssociationRef>(archivedNodeSorter);
        for (ChildAssociationRef chAssRef : children) {
            if (!nodeService.hasAspect(chAssRef.getChildRef(), ContentModel.ASPECT_ARCHIVED)) continue;
            orderedChildren.add(chAssRef);
        }
        return orderedChildren;
    }

    protected class ArchivedDateComparator
    implements Comparator<ChildAssociationRef> {
        protected ArchivedDateComparator() {
        }

        @Override
        public int compare(ChildAssociationRef chAssRef1, ChildAssociationRef chAssRef2) {
            NodeService nodeService = AbstractArchivedNodeWebScript.this.serviceRegistry.getNodeService();
            Date archivedDate1 = (Date)nodeService.getProperty(chAssRef1.getChildRef(), ContentModel.PROP_ARCHIVED_DATE);
            Date archivedDate2 = (Date)nodeService.getProperty(chAssRef2.getChildRef(), ContentModel.PROP_ARCHIVED_DATE);
            return archivedDate2.compareTo(archivedDate1);
        }
    }
}

