/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.archive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.alfresco.repo.web.scripts.archive.AbstractArchivedNodeWebScript;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ArchivedNodesDelete
extends AbstractArchivedNodeWebScript {
    private static Log log = LogFactory.getLog(ArchivedNodesDelete.class);
    public static final String PURGED_NODES = "purgedNodes";

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        StoreRef storeRef = this.parseRequestForStoreRef(req);
        NodeRef nodeRef = this.parseRequestForNodeRef(req);
        ArrayList<NodeRef> nodesToBePurged = new ArrayList<NodeRef>();
        if (nodeRef != null) {
            nodesToBePurged.add(nodeRef);
        } else {
            SortedSet<ChildAssociationRef> archiveNodes = this.getArchivedNodesFrom(storeRef);
            for (ChildAssociationRef chAssRef : archiveNodes) {
                nodesToBePurged.add(chAssRef.getChildRef());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Purging " + nodesToBePurged.size() + " nodes"));
        }
        this.nodeArchiveService.purgeArchivedNodes(nodesToBePurged);
        model.put(PURGED_NODES, nodesToBePurged);
        return model;
    }
}

