/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.archive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.alfresco.repo.web.scripts.archive.AbstractArchivedNodeWebScript;
import org.alfresco.repo.web.scripts.archive.ArchivedNodeState;
import org.alfresco.repo.web.scripts.archive.ArchivedNodesFilter;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.ModelUtil;
import org.alfresco.util.ScriptPagingDetails;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ArchivedNodesGet
extends AbstractArchivedNodeWebScript {
    private static final String MAX_ITEMS = "maxItems";
    private static final String SKIP_COUNT = "skipCount";
    List<ArchivedNodesFilter> nodeFilters = new ArrayList<ArchivedNodesFilter>();

    public void setArchivedNodeFilters(List<ArchivedNodesFilter> nodeFilters) {
        this.nodeFilters = nodeFilters;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        StoreRef storeRef = this.parseRequestForStoreRef(req);
        SortedSet<ChildAssociationRef> orderedChildren = this.getArchivedNodesFrom(storeRef);
        ArrayList<ArchivedNodeState> deletedNodes = new ArrayList<ArchivedNodeState>(orderedChildren.size());
        for (ChildAssociationRef chAssRef : orderedChildren) {
            NodeRef nextArchivedNode = chAssRef.getChildRef();
            boolean nodeIsFilteredOut = false;
            for (ArchivedNodesFilter filter : this.nodeFilters) {
                if (filter.accept(nextArchivedNode)) continue;
                nodeIsFilteredOut = true;
                break;
            }
            if (nodeIsFilteredOut) continue;
            ArchivedNodeState state = ArchivedNodeState.create(nextArchivedNode, this.serviceRegistry);
            deletedNodes.add(state);
        }
        ScriptPagingDetails paging = new ScriptPagingDetails(this.getIntParameter(req, MAX_ITEMS, deletedNodes.size()), this.getIntParameter(req, SKIP_COUNT, 0));
        model.put("deletedNodes", ModelUtil.page(deletedNodes, (ScriptPagingDetails)paging));
        model.put("paging", ModelUtil.buildPaging((ScriptPagingDetails)paging));
        return model;
    }
}

