/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.archive;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class NodeArchiveServiceRestApiTest
extends BaseWebScriptTest {
    private static final String DATA = "data";
    private static final String ARCHIVE_URL_FORMAT = "/api/archive/{0}/{1}";
    private static final String TEST_TITLE = "FooBarTitle";
    private static final String TEST_DESCRIPTION = "This is a FooBar description";
    private NodeRef undeletedTestNode;
    private NodeRef deletedTestNode;
    private NodeService nodeService;
    private NodeArchiveService nodeArchiveService;
    private Repository repositoryHelper;
    private RetryingTransactionHelper transactionHelper;
    private StoreRef nodesOriginalStoreRef;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.nodeArchiveService = (NodeArchiveService)this.getServer().getApplicationContext().getBean("nodeArchiveService");
        this.repositoryHelper = (Repository)this.getServer().getApplicationContext().getBean("repositoryHelper");
        this.transactionHelper = (RetryingTransactionHelper)this.getServer().getApplicationContext().getBean("retryingTransactionHelper");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.undeletedTestNode = (NodeRef)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                HashMap<QName, String> props = new HashMap<QName, String>();
                String cmName = this.getClass().getSimpleName() + "_" + System.currentTimeMillis();
                props.put(ContentModel.PROP_NAME, cmName);
                props.put(ContentModel.PROP_TITLE, NodeArchiveServiceRestApiTest.TEST_TITLE);
                props.put(ContentModel.PROP_DESCRIPTION, NodeArchiveServiceRestApiTest.TEST_DESCRIPTION);
                ChildAssociationRef chAssRef = NodeArchiveServiceRestApiTest.this.nodeService.createNode(NodeArchiveServiceRestApiTest.this.repositoryHelper.getCompanyHome(), ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT, props);
                return chAssRef.getChildRef();
            }
        });
        this.nodesOriginalStoreRef = this.undeletedTestNode.getStoreRef();
        this.deletedTestNode = (NodeRef)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                HashMap<QName, String> props = new HashMap<QName, String>();
                String cmName = this.getClass().getSimpleName() + "_" + System.currentTimeMillis();
                props.put(ContentModel.PROP_NAME, cmName);
                props.put(ContentModel.PROP_TITLE, NodeArchiveServiceRestApiTest.TEST_TITLE);
                props.put(ContentModel.PROP_DESCRIPTION, NodeArchiveServiceRestApiTest.TEST_DESCRIPTION);
                ChildAssociationRef chAssRef = NodeArchiveServiceRestApiTest.this.nodeService.createNode(NodeArchiveServiceRestApiTest.this.repositoryHelper.getCompanyHome(), ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT, props);
                NodeArchiveServiceRestApiTest.this.nodeService.deleteNode(chAssRef.getChildRef());
                NodeRef archivedNode = NodeArchiveServiceRestApiTest.this.nodeArchiveService.getArchivedNode(chAssRef.getChildRef());
                return archivedNode;
            }
        });
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (NodeArchiveServiceRestApiTest.this.undeletedTestNode != null && NodeArchiveServiceRestApiTest.this.nodeService.exists(NodeArchiveServiceRestApiTest.this.undeletedTestNode)) {
                    NodeArchiveServiceRestApiTest.this.nodeService.deleteNode(NodeArchiveServiceRestApiTest.this.undeletedTestNode);
                }
                return null;
            }
        });
    }

    public void testGetDeletedItems() throws Exception {
        JSONObject jsonRsp = this.getArchivedNodes();
        JSONObject dataObj = (JSONObject)jsonRsp.get(DATA);
        NodeArchiveServiceRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        JSONArray deletedNodesArray = (JSONArray)dataObj.get("deletedNodes");
        NodeArchiveServiceRestApiTest.assertNotNull((String)"JSON 'deletedNodesArray' object was null", (Object)deletedNodesArray);
        NodeArchiveServiceRestApiTest.assertTrue((String)"Unexpectedly found 0 items in archive store", (0 != deletedNodesArray.length() ? 1 : 0) != 0);
        JSONObject deletedNodeToTest = null;
        for (int i = 0; i < deletedNodesArray.length(); ++i) {
            JSONObject nextJSONObj = (JSONObject)deletedNodesArray.get(i);
            String nodeRefString = nextJSONObj.getString("nodeRef");
            if (!nodeRefString.equals(this.deletedTestNode.toString())) continue;
            deletedNodeToTest = nextJSONObj;
            break;
        }
        NodeArchiveServiceRestApiTest.assertNotNull((String)"Failed to find an expected NodeRef within the archive store.", deletedNodeToTest);
        NodeArchiveServiceRestApiTest.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)deletedNodeToTest.getString("archivedBy"));
        NodeArchiveServiceRestApiTest.assertEquals((String)TEST_TITLE, (String)deletedNodeToTest.getString("title"));
        NodeArchiveServiceRestApiTest.assertEquals((String)TEST_DESCRIPTION, (String)deletedNodeToTest.getString("description"));
        NodeArchiveServiceRestApiTest.assertNotNull((Object)deletedNodeToTest.getString("name"));
        NodeArchiveServiceRestApiTest.assertNotNull((Object)deletedNodeToTest.getString("nodeRef"));
        NodeArchiveServiceRestApiTest.assertNotNull((Object)deletedNodeToTest.getString("displayPath"));
        NodeArchiveServiceRestApiTest.assertNotNull((Object)deletedNodeToTest.getString("archivedDate"));
        NodeArchiveServiceRestApiTest.assertNotNull((Object)deletedNodeToTest.getString("firstName"));
        NodeArchiveServiceRestApiTest.assertNotNull((Object)deletedNodeToTest.getString("lastName"));
        NodeArchiveServiceRestApiTest.assertNotNull((Object)deletedNodeToTest.getString("nodeType"));
        Date previousDate = null;
        for (int i = 0; i < deletedNodesArray.length(); ++i) {
            JSONObject nextJSONObj = deletedNodesArray.getJSONObject(i);
            String nextArchivedDateString = nextJSONObj.getString("archivedDate");
            String ftlDatePattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            Date nextArchivedDate = df.parse(nextArchivedDateString);
            if (previousDate != null) {
                NodeArchiveServiceRestApiTest.assertTrue((String)"Archived Dates were not reverse-sorted.", (boolean)nextArchivedDate.before(previousDate));
            }
            previousDate = nextArchivedDate;
        }
    }

    private JSONObject getArchivedNodes() throws IOException, JSONException, UnsupportedEncodingException {
        String url = this.getArchiveUrl(this.nodesOriginalStoreRef);
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        return jsonRsp;
    }

    public void testPurgeDeletedItems() throws Exception {
        JSONObject archivedNodesJson = this.getArchivedNodes();
        JSONObject dataJsonObj = archivedNodesJson.getJSONObject(DATA);
        JSONArray archivedNodesArray = dataJsonObj.getJSONArray("deletedNodes");
        int archivedNodesLength = archivedNodesArray.length();
        NodeArchiveServiceRestApiTest.assertTrue((String)"Insufficient archived nodes for test to run.", (archivedNodesLength > 1 ? 1 : 0) != 0);
        JSONObject requiredNodeInArchive = null;
        for (int i = 0; i < archivedNodesLength; ++i) {
            JSONObject archivedNode = archivedNodesArray.getJSONObject(i);
            if (!archivedNode.getString("nodeRef").equals(this.deletedTestNode.toString())) continue;
            requiredNodeInArchive = archivedNode;
            break;
        }
        NodeArchiveServiceRestApiTest.assertNotNull((String)"Expected node not found in archive", requiredNodeInArchive);
        String nodeRefString = requiredNodeInArchive.getString("nodeRef");
        NodeArchiveServiceRestApiTest.assertTrue((String)"nodeRef string is invalid", (boolean)NodeRef.isNodeRef((String)nodeRefString));
        NodeRef nodeRef = new NodeRef(nodeRefString);
        StoreRef currentStoreRef = nodeRef.getStoreRef();
        String deleteUrl = this.getArchiveUrl(currentStoreRef) + "/" + nodeRef.getId();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(deleteUrl), 200);
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        JSONObject dataObj = jsonRsp.getJSONObject(DATA);
        JSONArray purgedNodesArray = dataObj.getJSONArray("purgedNodes");
        NodeArchiveServiceRestApiTest.assertEquals((String)"Only expected one NodeRef to have been purged.", (int)1, (int)purgedNodesArray.length());
        String deleteAllUrl = this.getArchiveUrl(this.nodesOriginalStoreRef);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(deleteAllUrl), 200);
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        dataObj = jsonRsp.getJSONObject(DATA);
        purgedNodesArray = dataObj.getJSONArray("purgedNodes");
        NodeArchiveServiceRestApiTest.assertEquals((String)"Archive store was unexpectedly not empty", (int)0, (int)this.getArchivedNodesCount());
    }

    private int getArchivedNodesCount() throws IOException, JSONException, UnsupportedEncodingException {
        JSONObject archiveContents = this.getArchivedNodes();
        JSONObject datatObject = archiveContents.getJSONObject(DATA);
        JSONArray deletedNodesArray = datatObject.getJSONArray("deletedNodes");
        return deletedNodesArray.length();
    }

    public void testRestoreDeletedItems() throws Exception {
        JSONObject archivedNodesJson = this.getArchivedNodes();
        JSONObject dataJsonObj = archivedNodesJson.getJSONObject(DATA);
        JSONArray archivedNodesArray = dataJsonObj.getJSONArray("deletedNodes");
        int archivedNodesLength = archivedNodesArray.length();
        NodeArchiveServiceRestApiTest.assertTrue((String)"Insufficient archived nodes for test to run.", (archivedNodesLength > 1 ? 1 : 0) != 0);
        JSONObject firstArchivedNode = archivedNodesArray.getJSONObject(0);
        String nodeRefString = firstArchivedNode.getString("nodeRef");
        NodeArchiveServiceRestApiTest.assertTrue((String)"nodeRef string is invalid", (boolean)NodeRef.isNodeRef((String)nodeRefString));
        NodeRef nodeRef = new NodeRef(nodeRefString);
        StoreRef currentStoreRef = nodeRef.getStoreRef();
        String restoreUrl = this.getArchiveUrl(currentStoreRef) + "/" + nodeRef.getId();
        int archivedNodesCountBeforeRestore = this.getArchivedNodesCount();
        String jsonString = new JSONStringer().object().key("restoreLocation").value((Object)"").endObject().toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(restoreUrl, jsonString, "application/json"), 200);
        NodeArchiveServiceRestApiTest.assertEquals((String)"Expected archive to shrink by one", (int)(archivedNodesCountBeforeRestore - 1), (int)this.getArchivedNodesCount());
    }

    private String getArchiveUrl(StoreRef storeRef) {
        String result = MessageFormat.format(ARCHIVE_URL_FORMAT, storeRef.getProtocol(), storeRef.getIdentifier());
        return result;
    }
}

