/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.audit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.audit.AbstractAuditWebScript;
import org.alfresco.service.cmr.audit.AuditService;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class AuditControlGet
extends AbstractAuditWebScript {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(7);
        String appName = this.getParamAppName(req);
        String path = this.getParamPath(req);
        boolean enabledGlobal = this.auditService.isAuditEnabled();
        Map<String, AuditService.AuditApplication> appsByName = this.auditService.getAuditApplications();
        if (appName != null) {
            if (path == null) {
                throw new WebScriptException(400, "audit.err.path.notProvided");
            }
            AuditService.AuditApplication app = (AuditService.AuditApplication)appsByName.get(appName);
            if (app == null) {
                throw new WebScriptException(404, "audit.err.app.notFound", new Object[]{appName});
            }
            appsByName = Collections.singletonMap(appName, app);
        }
        model.put("enabled", enabledGlobal);
        model.put("applications", appsByName.values());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Result: \n\tRequest: " + req + "\n\tModel: " + model));
        }
        return model;
    }
}

