/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.audit.AbstractAuditWebScript;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class AuditQueryGet
extends AbstractAuditWebScript {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Map appsByName;
        AuditService.AuditApplication app;
        HashMap<String, Object> model = new HashMap<String, Object>(7);
        String appName = this.getParamAppName(req);
        String path = this.getParamPath(req);
        Object value = this.getParamValue(req);
        String valueType = this.getParamValueType(req);
        Long fromTime = this.getParamFromTime(req);
        Long toTime = this.getParamToTime(req);
        Long fromId = this.getParamFromId(req);
        Long toId = this.getParamToId(req);
        String user = this.getParamUser(req);
        boolean forward = this.getParamForward(req);
        int limit = this.getParamLimit(req);
        final boolean verbose = this.getParamVerbose(req);
        if (appName == null && (app = (AuditService.AuditApplication)(appsByName = this.auditService.getAuditApplications()).get(appName)) == null) {
            throw new WebScriptException(404, "audit.err.app.notFound", new Object[]{appName});
        }
        if (value != null && valueType != null) {
            try {
                Class<?> clazz = Class.forName(valueType);
                value = (Serializable)DefaultTypeConverter.INSTANCE.convert(clazz, value);
            }
            catch (ClassNotFoundException e) {
                throw new WebScriptException(400, "audit.err.value.classNotFound", new Object[]{valueType});
            }
            catch (Throwable e) {
                throw new WebScriptException(400, "audit.err.value.convertFailed", new Object[]{value, valueType});
            }
        }
        AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName(appName);
        params.setFromTime(fromTime);
        params.setToTime(toTime);
        params.setFromId(fromId);
        params.setToId(toId);
        params.setUser(user);
        params.setForward(forward);
        if (path != null || value != null) {
            params.addSearchKey(path, (Serializable)value);
        }
        final ArrayList entries = new ArrayList(limit);
        AuditService.AuditQueryCallback callback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return verbose;
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                return true;
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                HashMap<String, Object> entry = new HashMap<String, Object>(11);
                entry.put("id", entryId);
                entry.put("application", applicationName);
                if (user != null) {
                    entry.put("user", user);
                }
                entry.put("time", new Date(time));
                if (values != null) {
                    HashMap<String, String> valueStrings = new HashMap<String, String>(values.size() * 2);
                    for (Map.Entry<String, Serializable> mapEntry : values.entrySet()) {
                        String key = mapEntry.getKey();
                        Serializable value = mapEntry.getValue();
                        try {
                            String valueString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
                            valueStrings.put(key, valueString);
                        }
                        catch (TypeConversionException e) {
                            valueStrings.put(key, value.toString());
                        }
                    }
                    entry.put("values", valueStrings);
                }
                entries.add(entry);
                return true;
            }
        };
        this.auditService.auditQuery(callback, params, limit);
        model.put("count", entries.size());
        model.put("entries", entries);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Result: \n\tRequest: " + req + "\n\tModel: " + model));
        }
        return model;
    }
}

